/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* gnome-peercast.c
 *
 * Copyright (C) 2005 Takuo KITAME.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * Author: Takuo KITAME.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdarg.h>
#include <stdio.h>
#include "channel.h"
#include "servent.h"
#include "servmgr.h"
#include "stats.h"
#include "unix/usys.h"
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>

#include <gconf/gconf-client.h>

#include "utils.h"
#include "callbacks.h"
#include "gnome-peercast.h"

extern String iniFileName;
WLock loglock;

#define GLADE_FILE_NAME "gnome-peercast.glade"
#define DELAY_UPDATE 1000 /* 1 second */
#define DELAY_STATS  1000


// ---------------------------------
void APICALL
GnomePeercastApp::channelStart (ChanInfo *info)
{
	// cl->setInfo (info);
}

void APICALL
GnomePeercastApp::delChannel (ChanInfo *info)
{
	// cl->deleteInfo (info);
}

const char *
APICALL GnomePeercastApp::getIniFilename()
{
	return iniFileName;
}

static gboolean
update_app_status (gpointer data)
{
	GnomePeercastApp *gapp = (GnomePeercastApp *)data;
	Channel *ch;
	gchar ti[1024];

	gnome_appbar_pop (gapp->appbar);

	ch = gapp->cl->selectedChannel();
	if (!ch) return TRUE;

	if (! ch->info.track.artist.isEmpty () &&
	    ! ch->info.track.title.isEmpty ())
		g_snprintf (ti, sizeof(ti), _("Playing: %s - %s"),
			    ch->info.track.artist.cstr(),
			    ch->info.track.title.cstr());
	else if (! ch->info.track.artist.isEmpty ())
		g_snprintf (ti, sizeof(ti), _("Playing: %s "),
			    ch->info.track.artist.cstr());
	else if (! ch->info.track.title.isEmpty ())
		g_snprintf (ti, sizeof(ti), _("Playing: %s "),
			    ch->info.track.title.cstr());
	else
		g_snprintf (ti, sizeof(ti), _("Channel: %s "),
			    ch->info.name.cstr());

	gnome_appbar_push (gapp->appbar, ti);
	return TRUE;
}


static gboolean
info_update_stats (gpointer data)

{
	GnomePeercastApp *app = (GnomePeercastApp *)data;
	gchar buf[1024];
	GtkWidget *label;
	String str;

	/* main informations */
	label =  app->getWidget ("label_serverip");
	servMgr->serverHost.IPtoStr(buf);
	gtk_label_set_text (GTK_LABEL (label), buf);

	label =  app->getWidget ("label_port");
	g_snprintf (buf, sizeof (buf), "%d", servMgr->serverHost.port);
	gtk_label_set_text (GTK_LABEL (label), buf);

	label =  app->getWidget ("label_uptime");
	make_time_str (buf, sizeof (buf), servMgr->getUptime());
	gtk_label_set_text (GTK_LABEL (label), buf);

	label =  app->getWidget ("label_chancache");
	g_snprintf (buf, sizeof (buf), "%d", chanMgr->numHitLists());
	gtk_label_set_text (GTK_LABEL (label), buf);

	label =  app->getWidget ("label_gnet_host_cache");
	g_snprintf (buf, sizeof (buf), "%d",
		    servMgr->numHosts(ServHost::T_SERVENT));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label =  app->getWidget ("label_fw");
	switch (servMgr->getFirewall ()) {
	case ServMgr::FW_OFF:
		g_snprintf (buf, sizeof (buf), _("<span weight=\"bold\" foreground=\"#3a8548\"><b>NO</b></span>"));
		break;
	case ServMgr::FW_ON:
		g_snprintf (buf, sizeof (buf), _("<span weight=\"bold\" foreground=\"#FF0000\"><b>YES</b></span>"));
		break;
	default:
		g_snprintf (buf, sizeof (buf), _("<span weight=\"bold\">Unknown</span>"));
	}
	gtk_label_set_markup (GTK_LABEL (label), buf);

	/* Bandwidth */
	label =  app->getWidget ("label_total_in");
	g_snprintf (buf, sizeof (buf), "%.1f",
		    BYTES_TO_KBPS(stats.getPerSecond(Stats::BYTESIN)));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label =  app->getWidget ("label_total_out");
	g_snprintf (buf, sizeof (buf), "%.1f",
		    BYTES_TO_KBPS(stats.getPerSecond(Stats::BYTESOUT)));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_total_total");
	g_snprintf (buf, sizeof (buf), "%.1f",
		    BYTES_TO_KBPS(stats.getPerSecond(Stats::BYTESIN)+
				  stats.getPerSecond(Stats::BYTESOUT)));
	gtk_label_set_text (GTK_LABEL (label), buf);


	label = app->getWidget ("label_inet_in");
	g_snprintf (buf, sizeof (buf), "%.1f",
		    BYTES_TO_KBPS(stats.getPerSecond(Stats::BYTESIN) -
				  stats.getPerSecond(Stats::LOCALBYTESIN)));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_inet_out");
	g_snprintf (buf, sizeof (buf), "%.1f",
		    BYTES_TO_KBPS(stats.getPerSecond(Stats::BYTESOUT) -
				  stats.getPerSecond(Stats::LOCALBYTESOUT)));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_inet_total");
	g_snprintf (buf, sizeof (buf), "%.1f",
		    BYTES_TO_KBPS((stats.getPerSecond(Stats::BYTESIN) -
				   stats.getPerSecond(Stats::LOCALBYTESIN)) +
				  (stats.getPerSecond(Stats::BYTESOUT) -
				   stats.getPerSecond(Stats::LOCALBYTESOUT))));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_gnet_in");
	g_snprintf (buf, sizeof (buf), "%.1f",
		    BYTES_TO_KBPS(stats.getPerSecond(Stats::PACKETDATAIN)));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_gnet_out");
	g_snprintf (buf, sizeof (buf), "%.1f",
		    BYTES_TO_KBPS(stats.getPerSecond(Stats::PACKETDATAOUT)));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_gnet_total");
	g_snprintf (buf, sizeof (buf), "%.1f",
		    BYTES_TO_KBPS(stats.getPerSecond(Stats::PACKETDATAIN) +
				  stats.getPerSecond(Stats::PACKETDATAOUT)));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_gnet_pin");
	g_snprintf (buf, sizeof (buf), "%.1f",
		    (double)stats.getPerSecond(Stats::NUMPACKETSIN));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_gnet_pout");
	g_snprintf (buf, sizeof (buf), "%.1f",
		    (double)stats.getPerSecond(Stats::NUMPACKETSOUT));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_gnet_ptotal");
	g_snprintf (buf, sizeof (buf), "%.1f",
		    (double)(stats.getPerSecond(Stats::NUMPACKETSIN) +
			     stats.getPerSecond(Stats::NUMPACKETSOUT)));
	gtk_label_set_text (GTK_LABEL (label), buf);

	/* Connections */
	label = app->getWidget ("label_cdirect");
	g_snprintf (buf, sizeof (buf), "%d",
		    servMgr->numStreams(Servent::T_DIRECT,true));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_crelay");
	g_snprintf (buf, sizeof (buf), "%d",
		    servMgr->numStreams(Servent::T_RELAY,true));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_ccinout");
	g_snprintf (buf, sizeof (buf), "%d / %d",
		    servMgr->numConnected(Servent::T_CIN),
		    servMgr->numConnected(Servent::T_COUT));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_cpgnu");
	g_snprintf (buf, sizeof (buf), "%d",
		    servMgr->numConnected(Servent::T_PGNU));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_cincoming");
	g_snprintf (buf, sizeof (buf), "%d",
		    servMgr->numActive(Servent::T_INCOMING));
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_cport_label");
	g_snprintf (buf, sizeof (buf), _("Port %d / %d"),
		    servMgr->serverHost.port,servMgr->serverHost.port + 1);
	gtk_label_set_text (GTK_LABEL (label), buf);

	label = app->getWidget ("label_cport");
	g_snprintf (buf, sizeof (buf), "%d / %d",
		    servMgr->numActiveOnPort(servMgr->serverHost.port),
		    servMgr->numActiveOnPort(servMgr->serverHost.port + 1));
	gtk_label_set_text (GTK_LABEL (label), buf);


	label = app->getWidget ("label_mode");
	gtk_label_set_text (GTK_LABEL (label),
			    servMgr->isRoot ? _("Root") : _("Normal"));

	return TRUE;
}

GtkWidget *
GnomePeercastApp::getWidget (const gchar *name)
{
	return glade_xml_get_widget (xml, name);
}

void
GnomePeercastApp::infoInit (void)
{
	GtkWidget *w;
	gchar *tmp;
	gchar buf[1024];
	static gint timeout_source = 1;

	if (! gui) return;

	info_update_stats (this);

	timeout_source = g_timeout_add (DELAY_STATS, info_update_stats,
					this);

	w = getWidget ("href_xml_stats");
	gnome_href_set_text (GNOME_HREF(w), _("View"));
	tmp = get_local_ip ();
	g_snprintf (buf, sizeof (buf), "http://%s:%d/admin?cmd=viewxml",
		    tmp, servMgr->serverHost.port);
	gnome_href_set_url (GNOME_HREF (w), buf);
	gtk_tooltips_set_tip (tips, w, buf, NULL);
	g_free (tmp);

	w = getWidget ("label_ini_file");
	gtk_label_set_text (GTK_LABEL (w), getIniFilename());

	w = getWidget ("label_version");
	gtk_label_set_text (GTK_LABEL (w), PCX_VERSTRING);
}

void
GnomePeercastApp::guiInit (void)
{
	GtkWidget *button;
	static gint timeout_source = 1;

	gui = TRUE;

	tips = gtk_tooltips_new ();

	xml = load_glade_xml (GLADE_FILE_NAME, "main_app");

	window =  getWidget ("main_app");

	button = getWidget ("yp_image");
	gtk_image_set_from_file (GTK_IMAGE (button), ICON_DIR"/peercast.png");

	appbar =  GNOME_APPBAR (getWidget ("main_appbar"));
	gtk_widget_set_sensitive (getWidget ("main_toolbar"), FALSE);
	gtk_widget_set_sensitive (getWidget ("con_stop"), FALSE);

	g_signal_connect (G_OBJECT (window), "delete-event",
			  G_CALLBACK (gp_quit_app), NULL);

	/* Channel List */
	cl = new ChannelList (getWidget ("channel_list"), GTK_WINDOW (window));

	g_signal_connect (G_OBJECT (cl->getSelection ()), "changed",
			  G_CALLBACK (chan_selection_changed_cb), this);

	glade_xml_signal_connect_data (xml, "cl_play_clicked",
				       G_CALLBACK (chan_play_cb), cl);
	glade_xml_signal_connect_data (xml, "cl_info_clicked",
				       G_CALLBACK (chan_info_cb), cl);
	glade_xml_signal_connect_data (xml, "cl_url_clicked",
				       G_CALLBACK (chan_url_cb), cl);
	glade_xml_signal_connect_data (xml, "cl_bump_clicked",
				       G_CALLBACK (chan_bump_cb), cl);
	glade_xml_signal_connect_data (xml, "cl_stop_clicked",
				       G_CALLBACK (chan_stop_cb), cl);

	/* Connections List */
	conlist = new ConnectionList (getWidget ("connection_list"));

	glade_xml_signal_connect_data (xml, "con_stop_clicked",
				       G_CALLBACK (con_stop_cb), conlist);
	g_signal_connect (G_OBJECT (conlist->getSelection ()), "changed",
			  G_CALLBACK (con_selection_changed_cb), getWidget ("con_stop"));

	/* Log view */
	logview = new LogView;
	logview->init (getWidget ("log_list"));

	glade_xml_signal_connect_data (xml, "log_clear_clicked",
				       G_CALLBACK (log_clear_cb),
				       logview);

	/* Main toolbar signal */
	glade_xml_signal_connect_data (xml, "tool_new_clicked",
				       G_CALLBACK (menu_new_cb), this);
	glade_xml_signal_connect_data (xml, "tool_yp_clicked",
				       G_CALLBACK (menu_yp_cb), this);
	glade_xml_signal_connect_data (xml, "tool_pref_clicked",
				       G_CALLBACK (menu_pref_cb), this);

	/* Menu signal */
	/* File */
	glade_xml_signal_connect_data (xml, "menu_new_activate",
				       G_CALLBACK (menu_new_cb), this);
	glade_xml_signal_connect_data (xml, "menu_yp_activate",
				       G_CALLBACK (menu_yp_cb), this);
	glade_xml_signal_connect_data (xml, "menu_web_activate",
				       G_CALLBACK (menu_web_cb), this);
	glade_xml_signal_connect_data (xml, "menu_quit_activate",
				       G_CALLBACK (menu_quit_cb), this);

	/* Pref */
	glade_xml_signal_connect_data (xml, "menu_pref_activate",
				       G_CALLBACK (menu_pref_cb), this);

	/* Help */
	glade_xml_signal_connect_data (xml, "menu_about_activate",
				       G_CALLBACK (menu_about_cb), this);

	timeout_source = g_timeout_add (DELAY_UPDATE,
					update_app_status,
					this);
}

void APICALL
GnomePeercastApp::printLog(LogBuffer::TYPE t, const char *str)
{
	loglock.on();
	if (gui)
		logview->appendLog (t, str);
	else {
		if (t != LogBuffer::T_NONE)
			g_print ("[%s] ", LogBuffer::getTypeStr(t));
		g_print ("%s\n",str);
	}
	loglock.off();
}

gint
GnomePeercastApp::getConfigInt (const gchar *key)
{
	gint ret;
	client = gconf_client_get_default ();

	ret = gconf_client_get_int (client, key, NULL);

	g_object_unref (client);
	return ret;
}

gboolean
GnomePeercastApp::getConfigBool (const gchar *key)
{
	gboolean ret;

	client = gconf_client_get_default ();

	ret = gconf_client_get_bool (client, key, NULL);

	g_object_unref (client);
	return ret;
}

gchar *
GnomePeercastApp::getConfigString (const gchar *key)
{
	gchar *ret;
	client = gconf_client_get_default ();

	ret = gconf_client_get_string (client, key, NULL);

	g_object_unref (client);
	return ret;
}

void
GnomePeercastApp::setConfigInt (const gchar *key, gint value)
{
	client = gconf_client_get_default ();
	gconf_client_set_int (client, key, value, NULL);
	g_object_unref (client);
}

void
GnomePeercastApp::setConfigBool (const gchar *key, gboolean value)
{
	client = gconf_client_get_default ();
	gconf_client_set_bool (client, key, value, NULL);
	g_object_unref (client);
}

void
GnomePeercastApp::setConfigString (const gchar *key, gchar *value)
{
	client = gconf_client_get_default ();
	gconf_client_set_string (client, key, value, NULL);
	g_object_unref (client);
}


void
GnomePeercastApp::gconfInit (void)
{
	GError *err = NULL;

	client = gconf_client_get_default ();

	gconf_client_add_dir (client, CONF_GLOBAL_PREFIX,
			      GCONF_CLIENT_PRELOAD_ONELEVEL,
			      &err);
	if (err) {
		g_printerr (_("There was an error loading config from %s. (%s)\n"),
			    CONF_GLOBAL_PREFIX, err->message);
		g_error_free (err);
		return;
	}

	err = NULL;
	gconf_client_add_dir (client, CONF_NETWORK_PREFIX,
			      GCONF_CLIENT_PRELOAD_ONELEVEL,
			      &err);
	if (err) {
		g_printerr (_("There was an error loading config from %s. (%s)\n"),
			    CONF_NETWORK_PREFIX, err->message);
		g_error_free (err);
		return;
	}

	err = NULL;
	gconf_client_add_dir (client, CONF_GUI_PREFIX,
			      GCONF_CLIENT_PRELOAD_ONELEVEL,
			      &err);
	if (err) {
		g_printerr (_("There was an error loading config from %s. (%s)\n"),
			    CONF_GUI_PREFIX, err->message);
		g_error_free (err);
		return;
	}
	
}
