/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2005 Imendio AB
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "config.h"

#include <gtk/gtkmain.h>
#include <libgnomevfs/gnome-vfs-init.h>
#include <string.h>

#include "bacon-message-connection.h"
#include "lb-window.h"
#include "lb-module-manager.h"

#define COMMAND_SHOW_WINDOW "ShowWindow"

static LbModuleManager *manager = NULL;
static GtkWidget       *window = NULL;

static void
main_show_window (void)
{
	if (!manager) {
		manager = g_object_new (LB_TYPE_MODULE_MANAGER,
					NULL);

		window = lb_window_new (manager);
		gtk_window_set_default_size (GTK_WINDOW (window), 300, -1);
	}
		
	lb_window_present (LB_WINDOW (window));
}

static void
main_message_received_cb (const gchar *message, gpointer unused)
{
	if (strcmp (message, COMMAND_SHOW_WINDOW) != 0) {
		return;
	}

	main_show_window ();
}

int
main (int argc, char **argv)
{
	BaconMessageConnection *message_conn;

	message_conn = bacon_message_connection_new ("gnome-launch-box");
	if (!bacon_message_connection_get_is_server (message_conn)) {
		bacon_message_connection_send (message_conn, 
					       COMMAND_SHOW_WINDOW);
		return 0;
	}

	bacon_message_connection_set_callback (message_conn,
					       (BaconMessageReceivedFunc) main_message_received_cb,
					       NULL);
	
	
	gnome_vfs_init ();
	gtk_init (&argc, &argv);

	main_show_window ();

	gtk_main ();
	g_object_unref (manager);

	return 0;
}
