/*
 * gnome-gmail-notifier: the gnome gmail notifier.
 * Copyright (C) 2007 Bradley A. Worley.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * 
 *     Free Software Foundation, Inc.
 *     59 Temple Place, Suite 330
 *     Boston, MA 02111-1307 USA
 */

/*
 * ensure this is a once-only header.
 */
#ifndef __GNOME_GMAIL_NOTIFIER_PRESENCE_H__
#define __GNOME_GMAIL_NOTIFIER_PRESENCE_H__

/*
 * our header is just beginning.
 */
G_BEGIN_DECLS

/*
 * notify style definitions.
 */
enum {
    GGN_PRESENCE_STYLE_NORMAL,
    GGN_PRESENCE_STYLE_ERROR,
    GGN_PRESENCE_STYLE_MESSAGE,
    GGN_PRESENCE_STYLE_CHECKING,
    GGN_PRESENCE_STYLE_WARNING
};

/*
 * object function macros.
 */
#define GGN_TYPE_PRESENCE (ggn_presence_get_type ())
#define GGN_PRESENCE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GGN_TYPE_PRESENCE, GgnPresence))
#define GGN_PRESENCE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GGN_TYPE_PRESENCE, GgnPresenceClass))
#define GGN_IS_PRESENCE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GGN_TYPE_PRESENCE))
#define GGN_IS_PRESENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GGN_TYPE_PRESENCE))
#define GGN_PRESENCE_GET_CLASS(obj)  (G_TYPE_CHECK_CLASS_CAST ((obj), GGN_TYPE_PRESENCE, GgnPresenceClass))

/*
 * type macros.
 */
typedef struct _GgnPresence GgnPresence;
typedef struct _GgnPresenceClass GgnPresenceClass;
typedef struct _GgnPresencePrivate GgnPresencePrivate;

/*
 * object definition.
 */
struct _GgnPresence {
    /* parent gobject class. */
    GObject parent_object;
    
    /* private instance members. */
    GgnPresencePrivate* priv;
};

/*
 * class definition.
 */
struct _GgnPresenceClass {
    /* parent gobject class. */
    GObjectClass parent;
    
    /* tray menu "*_clicked" signals. */
    void (*selected) (GgnPresence* pres);
    void (*check_clicked) (GgnPresence* pres);
    void (*prefs_clicked) (GgnPresence* pres);
    void (*about_clicked) (GgnPresence* pres);
    void (*quit_clicked) (GgnPresence* pres);
};

/*
 * gobject-type definition.
 */
GType ggn_presence_get_type (void);

/*
 * object creation functions.
 */
GgnPresence* ggn_presence_new (void);
void ggn_presence_free (GgnPresence* pres);

/*
 * tray icon functions.
 */
void ggn_presence_set_icon_style (GgnPresence* pres, guint style);
void ggn_presence_set_icon_tip (GgnPresence* pres, gchar* text);
void ggn_presence_set_icon_visible (GgnPresence* pres, gboolean vis);

/*
 * bubble notification functions.
 */
void ggn_presence_set_notify_style (GgnPresence* pres, guint style);
void ggn_presence_set_notify_title (GgnPresence* pres, gchar* text);
void ggn_presence_set_notify_summary (GgnPresence* pres, gchar* text);
void ggn_presence_show_notify (GgnPresence* pres);

/*
 * sound playing function.
 */
void ggn_presence_play_sound (GgnPresence* pres, const gchar* soundfile);

/*
 * our header is at its end.
 */
G_END_DECLS

#endif /* __GNOME_GMAIL_NOTIFIER_PRESENCE_H__ */

