/*
 * gnome-gmail-notifier: the gnome gmail notifier.
 * Copyright (C) 2007 Bradley A. Worley.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * 
 *     Free Software Foundation, Inc.
 *     59 Temple Place, Suite 330
 *     Boston, MA 02111-1307 USA
 */

/*
 * ensure this is a once-only header.
 */
#ifndef __GNOME_GMAIL_NOTIFIER_PREFERENCES_H__
#define __GNOME_GMAIL_NOTIFIER_PREFERENCES_H__

/*
 * our header is just beginning.
 */
G_BEGIN_DECLS

/*
 * xpath-ish definitions.
 */
#define GGN_PREFS_XPATH_ACCOUNT     "/preferences/account"
#define GGN_PREFS_XPATH_USERNAME    "/preferences/account/username/text"
#define GGN_PREFS_XPATH_RATE        "/preferences/application/checkrate/text"
#define GGN_PREFS_XPATH_MESSAGES    "/preferences/application/notification/messages/text"
#define GGN_PREFS_XPATH_ERRORS      "/preferences/application/notification/errors/text"
#define GGN_PREFS_XPATH_SOUNDS      "/preferences/application/notification/sounds/text"
#define GGN_PREFS_XPATH_SOUND       "/preferences/application/notification/sound/text"
#define GGN_PREFS_XPATH_FIRSTRUN    "/preferences/application/firstrun/text"

/*
 * our default string formatting.
 */
#define GGN_PREFERENCES_WFORMAT "\
<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\
<preferences>\n\
  <!--\n\
    <account name=\"%s\" enabled=\"%s\">\n\
        <username>%s</username>\n\
    </account>\n\
  -->\n\
    <application>\n\
        <checkrate>%d</checkrate>\n\
        <notification>\n\
            <messages>%s</messages>\n\
            <errors>%s</errors>\n\
            <sounds>%s</sounds>\n\
            <sound>%s</sound>\n\
        </notification>\n\
        <firstrun>%s</firstrun>\n\
    </application>\n\
</preferences>\n"

/*
 * object function macros.
 */
#define GGN_TYPE_PREFERENCES (ggn_preferences_get_type ())
#define GGN_PREFERENCES(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GGN_TYPE_PREFERENCES, GgnPreferences))
#define GGN_PREFERENCES_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GGN_TYPE_PREFERENCES, GgnPreferencesClass))
#define GGN_IS_PREFERENCES(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GGN_TYPE_PREFERENCES))
#define GGN_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GGN_TYPE_PREFERENCES))
#define GGN_PREFERENCES_GET_CLASS(obj)  (G_TYPE_CHECK_CLASS_CAST ((obj), GGN_TYPE_PREFERENCES, GgnPreferencesClass))

/*
 * type macros.
 */
typedef struct _GgnPreferences GgnPreferences;
typedef struct _GgnPreferencesClass GgnPreferencesClass;
typedef struct _GgnPreferencesPrivate GgnPreferencesPrivate;

/*
 * object definition.
 */
struct _GgnPreferences {
    /* parent gobject class. */
    GObject parent_object;
    
    /* private instance members. */
    GgnPreferencesPrivate* priv;
};

/*
 * class definition.
 */
struct _GgnPreferencesClass {
    /* parent gobject class. */
    GObjectClass parent;
    
    /* signal definitions. */
    void (*accounts_modified) (GgnPreferences* prefs);
};

/*
 * gobject-type definition.
 */
GType ggn_preferences_get_type (void);

/*
 * object creation functions.
 */
GgnPreferences* ggn_preferences_new (void);
void ggn_preferences_free (GgnPreferences* prefs);

/*
 * read/write functions.
 */
gboolean ggn_preferences_read (GgnPreferences* prefs);
gboolean ggn_preferences_write (GgnPreferences* prefs);

/*
 * parameter-get functions.
 */
gint ggn_preferences_get_accounts (GgnPreferences* prefs);
gboolean ggn_preferences_get_account_enab (GgnPreferences* prefs, gint num);
gchar* ggn_preferences_get_account_name (GgnPreferences* prefs, gint num);
gchar* ggn_preferences_get_account_username (GgnPreferences* prefs, gint num);
gchar* ggn_preferences_get_account_password (GgnPreferences* prefs, gint num);
gchar* ggn_preferences_get_proxy (GgnPreferences* prefs);
gint ggn_preferences_get_rate (GgnPreferences* prefs);
gboolean ggn_preferences_get_notify_msgs (GgnPreferences* prefs);
gboolean ggn_preferences_get_notify_errs (GgnPreferences* prefs);
gboolean ggn_preferences_get_notify_snds (GgnPreferences* prefs);
gchar* ggn_preferences_get_soundfile (GgnPreferences* prefs);
gboolean ggn_preferences_get_firstrun (GgnPreferences* prefs);

/*
 * parameter-set functions.
 */
void ggn_preferences_set_account_enab (GgnPreferences* prefs, gint num, gboolean value);
void ggn_preferences_set_account_name (GgnPreferences* prefs, gint num, gchar* value);
void ggn_preferences_set_account_username (GgnPreferences* prefs, gint num, gchar* value);
void ggn_preferences_set_account_password (GgnPreferences* prefs, gint num, gchar* value);
void ggn_preferences_set_rate (GgnPreferences* prefs, gint value);
void ggn_preferences_set_notify_msgs (GgnPreferences* prefs, gboolean value);
void ggn_preferences_set_notify_errs (GgnPreferences* prefs, gboolean value);
void ggn_preferences_set_notify_snds (GgnPreferences* prefs, gboolean value);
void ggn_preferences_set_soundfile (GgnPreferences* prefs, gchar* value);
void ggn_preferences_set_firstrun (GgnPreferences* prefs, gboolean value);

/*
 * account manipulation functions.
 */
gint ggn_preferences_get_account_by_name (GgnPreferences* prefs,
                                          gchar* value);
void ggn_preferences_add_account (GgnPreferences* prefs,
                                  gchar* name,
                                  gchar* user,
                                  gchar* pass);
void ggn_preferences_remove_account (GgnPreferences* prefs,
                                     gint num);
void ggn_preferences_remove_account_by_name (GgnPreferences* prefs,
                                             gchar* name);

/*
 * our header is at its end.
 */
G_END_DECLS

#endif /* __GNOME_GMAIL_NOTIFIER_PREFERENCES_H__ */

