/*
 * gnome-gmail-notifier: the gnome gmail notifier.
 * Copyright (C) 2007 Bradley A. Worley.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * 
 *     Free Software Foundation, Inc.
 *     59 Temple Place, Suite 330
 *     Boston, MA 02111-1307 USA
 */

/*
 * ensure this is a once-only header.
 */
#ifndef __GNOME_GMAIL_NOTIFIER_CONFIG_H__
#define __GNOME_GMAIL_NOTIFIER_CONFIG_H__

/*
 * our header is just beginning.
 */
G_BEGIN_DECLS

/*
 * object function macros.
 */
#define GGN_TYPE_CONFIG (ggn_config_get_type ())
#define GGN_CONFIG(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GGN_TYPE_CONFIG, GgnConfig))
#define GGN_CONFIG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GGN_TYPE_CONFIG, GgnConfigClass))
#define GGN_IS_CONFIG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GGN_TYPE_CONFIG))
#define GGN_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GGN_TYPE_CONFIG))
#define GGN_CONFIG_GET_CLASS(obj)  (G_TYPE_CHECK_CLASS_CAST ((obj), GGN_TYPE_CONFIG, GgnConfigClass))

/*
 * the escape key.
 */
#define GGN_CONFIG_KEY_ESCAPE    GDK_Escape

/*
 * type macros.
 */
typedef struct _GgnConfig GgnConfig;
typedef struct _GgnConfigClass GgnConfigClass;
typedef struct _GgnConfigPrivate GgnConfigPrivate;

/*
 * object definition.
 */
struct _GgnConfig {
    /* parent gobject class. */
    GObject parent_object;
    
    /* private instance members. */
    GgnConfigPrivate* priv;
};

/*
 * class definition.
 */
struct _GgnConfigClass {
    /* parent gobject class. */
    GObjectClass parent;
    
    /* signals. */
};

/*
 * gobject-type definition.
 */
GType ggn_config_get_type (void);

/*
 * object creation functions.
 */
GgnConfig* ggn_config_new (void);
void ggn_config_free (GgnConfig* cfg);

/*
 * show/hide functions.
 */
void ggn_config_show (GgnConfig* cfg);
void ggn_config_hide (GgnConfig* cfg);

/*
 * prefs-setting functions.
 */
void ggn_config_set_prefs (GgnConfig* cfg, GgnPreferences* prefs);
void ggn_config_set_presence (GgnConfig* cfg, GgnPresence* pres);

/*
 * our header is at its end.
 */
G_END_DECLS

#endif /* __GNOME_GMAIL_NOTIFIER_ABOUT_CONFIG_H__ */

