/* -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4:ts=4:
 *
 * Gnome Apt main utility functions
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2003 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef GNOME_APT_GNOME_APT_H
#define GNOME_APT_GNOME_APT_H

#include "config.h"
#include <bonobo/bonobo-i18n.h>
#include <gtk/gtkwidget.h>
#include "gadefs.h"

#define APPNAME "gnome-apt"
#define COPYRIGHT_NOTICE _("(C) 1998-2003, GNU General Public License.")

#define GAPT_PAD_BIG 12

// Initiate quit sequence - check sanity, ask if we're sure, etc.
void gnome_apt_quit(void);

// Append anything on error_ to message and display.
void gnome_apt_error_dialog(const char* message);
// Same but modal and quit the app when it closes.
void gnome_apt_fatal_dialog(const char* message);

// This mostly just sets the dialog as a transient of the main window,
//  so we don't have to keep a pointer to the main window around
//  all over the place.
void gnome_apt_setup_dialog(GtkWidget* dialog);

class GAptCacheFile;
/* Return our cache file, or 0 if the cache file creation failed */
GAptCacheFile* gnome_apt_cache_file (void);

#endif
