%define name	gnomad2
%define version 2.8.0
%define release 1
# Release scheme for different RPM-based distributions:
# release = "1" for distro-independent stuff like source packages
# release = "1.rh9" - release 1 for Red Hat Linux 9
# release = "1.FC1" -release 1 for Fedora Core Linux 1
%define prefix  /usr

# Considering that there is no reliable distribution of id3lib and
# libnjb, I usually link these statically by commenting them out
# below. This involves particular building procedures:
#
# First install id3lib and libnjb from source or packages, then
# break your packages :-) thusly:
#
# rm /usr/local/lib/libnjb.so*
# rm /usr/local/lib/libid3*so*
#
# The build will then automatically link to the static .a files
# instead. I haven't found any better way to do this unfortunately.

Summary:	Gnomad 2 is a Linux/BSD GNOME 2.0 client for the Creative Nomad/Zen Jukeboxes and Dell DJs
Name:		%{name}
Version:    	%{version}
Release:	%{release}
License:	GPL
URL:		http://gnomad2.sourceforge.net
Group:		Applications/Multimedia
Source0:	%{name}-%{version}.tar.gz
Packager:       Linus Walleij <triad@df.lth.se>
BuildRoot:	%{_builddir}/%{name}-%{version}-root
Requires:       glib2
Requires:       gtk2
Requires:	libgnome
Requires:	libgnomeui
Requires:	libusb >= 0.1.5
Requires:	libstdc++
Requires:	zlib
Requires:	libnjb >= 2.2
# Comment out the following line when linking statically.
Requires:	libid3tag >= 0.15.1
BuildRequires:	glib2-devel
BuildRequires:	gtk2-devel
BuildRequires:	libgnome-devel
BuildRequires:	libgnomeui-devel
BuildRequires:	libusb-devel >= 0.1.5
# Comment out the following line when linking statically.
BuildRequires:	libid3tag-devel >= 0.15.1
Docdir:         %{prefix}/share/doc
Prefix:		%{_prefix}

%description
Gnomad 2 is a client for the Creative Nomad Jukeboxes, 
Zen, Zen USB 2.0, NX, Xtra, Touch and Micro, plus the
Dell DJs utilizing the
libnjb library for jukebox communication. It is used for
storing MP3 (and WAV, WMA) files on the jukebox and
retrieving them again, it also handles data file storage
and retrieval, playlists and a rudimentary player
with full support for the Creative EAX sound processor.

%prep
%setup 

%build
%configure
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_bindir}/gnomad2
%{_datadir}/man/man1/gnomad2.1.gz
%{_datadir}/applications/gnomad2.desktop
%{_datadir}/locale/*/LC_MESSAGES/gnomad2.mo
%{_datadir}/application-registry/gnomad2.applications
%{_datadir}/pixmaps/gnomad2-logo.png
%doc AUTHORS NEWS README COPYING

%changelog
* Thu Jun 30 2005 Linus Walleij <triad@df.lth.se> 2.8.0-1
- New release with many fixes and new libnjb stuff.
* Sat Jun 4 2005 Linus Walleij <triad@df.lth.se> 2.7.0-1
- New release with many fixes.
* Wed Feb 9 2005 Linus Walleij <triad@df.lth.se> 2.6.3-1
- Incremental update to sync with libnjb.
* Thu Jan 20 2005 Linus Walleij <triad@df.lth.se> 2.6.1-1
- Fixed Dell Pocket DJ and some more things.
* Fri Dec 10 2004 Linus Walleij <triad@df.lth.se> 2.6.1-1
- Fixed Dell DJ 2 and NJB1 issues
* Tue Nov 30 2004 Linus Walleij <triad@df.lth.se> 2.6.0-1
- File system folders and Zen Micro support, libnjb 1.3 CVS needed
* Wed Sep 29 2004 Linus Walleij <triad@df.lth.se> 2.5.0-1
- Lots of cool features, libnjb 1.2 CVS version needed
* Thu Apr 29 2004 Linus Walleij <triad@df.lth.se> 2.4.4-1
- Bug fixes, compilation on Gnome 2.5/2.6, libnjb 1.1
* Sat Apr 10 2004 Linus Walleij <triad@df.lth.se> 2.4.3-1
- Minor bug fixes, syncing up with some libnjb fixes.
* Mon Feb 22 2004 Linus Walleij <triad@df.lth.se> 2.4.2-1
- Minor bug fixes, syncing up with some libnjb fixes.
* Thu Jan 22 2004 Linus Walleij <triad@df.lth.se> 2.4.1-1
- Bug fixes, mainly NJB1 works again :-)
* Sat Jan 10 2004 Linus Walleij <triad@df.lth.se> 2.4.0-1
- Dell Digital Jukebox support, and syncs with CVS libnjb.
* Sat Dec 06 2003 Linus Walleij <triad@df.lth.se> 2.3.0-1
- Nomad Zen Xtra support, and sync to libnjb 1.0
* Mon Oct 27 2003 Linus Walleij <triad@df.lth.se> 2.2.0-1
- Nomad Zen NX support and full GTK+-2.0 migration.
* Sun Aug 10 2003 Linus Walleij <triad@df.lth.se> 2.1.0-2
- Relinking with updated version of libnjb.
* Sun Aug 10 2003 Linus Walleij <triad@df.lth.se> 2.1.0-1
- Several enhancements including stuff in libnjb.
* Thu May 22 2003 Linus Walleij <triad@df.lth.se> 2.0.2-1
- Making an RPM with minor bug fixes and some upgrade libnjb code.
* Sun Apr 20 2003 Linus Walleij <triad@df.lth.se> 2.0.1-2_rh9
- Fixing up a clean and working post script for the hotplugging
* Sat Apr 19 2003 Linus Walleij <triad@df.lth.se> 2.0.1-1_rh9
- Creating a RedHat 9 special, adding automated hotplug installation.
* Sun Mar 30 2003 Linus Walleij <triad@df.lth.se> 2.0.1
- Some fixes. Still relying on CVS version of libnjb.
* Thu Jan 16 2003 Linus Walleij <triad@df.lth.se> 2.0.0
- Skipped alpha. Going to sharp.
* Sun Jan 12 2003 Linus Walleij <triad@df.lth.se> 2.0.0a-1
- Initial alpha release of 2.0.0
* Mon Oct 07 2002 Linus Walleij <triad@df.lth.se> 1.1.6-1
- Bugfixes and preliminary NJB3 support
* Sat Sep 07 2002 Linus Walleij <triad@df.lth.se> 1.1.5-1
- Bugfixes again
* Fri Jul 19 2002 Linus Walleij <triad@df.lth.se> 1.1.4-1
- Bugfix release
* Tue Jun 18 2002 Linus Walleij <triad@df.lth.se> 1.1.3-1
- Bugfix release
* Sat Jun 1 2002 Linus Walleij <triad@df.lth.se> 1.1.2-1
- Another packaging.
* Sat Apr 6 2002 Linus Walleij <triad@df.lth.se> 1.1.0-1
- First try at a GNOMAD RPM package.
