/*
 * GNoise
 *
 * Copyright (C) 1999-2001 Dwight Engen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: edit.h,v 1.6 2001/03/25 20:10:49 dengen Exp $
 *
 */

#ifndef _EDIT_H
#define _EDIT_H

#include <pthread.h>
#include <stdio.h>
#include "gnoise.h"
#include "gtkwaveset.h"

typedef struct edit_s		edit_t;
typedef struct selection_s	selection_t;
typedef struct selection_set_s	selection_set_t;
typedef struct undo_s		undo_t;

typedef enum 
{
    EDIT_UNDO,			// undo last edit
    EDIT_SELECTION_SAVE,
    EDIT_MUTE,
    EDIT_FADE_LINEAR_IN,
    EDIT_FADE_LINEAR_OUT,
    EDIT_INTERP_LINEAR,
    EDIT_REVERSE,
    EDIT_NORMALIZE,
    EDIT_CUT,
    EDIT_COPY,
    EDIT_PASTE,
    EDIT_INSERT_SILENCE,
#   ifdef ENABLE_LADSPA
    EDIT_PLUGIN,
#   endif
    EDIT_LAST,
} edit_enum_t;

struct selection_s
{
    smpl_indx	start;	// in samples
    smpl_indx	end;	// in samples
};

struct selection_set_s
{
    chnl_indx	channel_start;
    chnl_indx	channel_end;
    smpl_indx	min_smp;		/* min sample in the set */
    smpl_indx	max_smp;		/* max sample in the set */
    smpl_indx	min_sel;		/* size of smallest selection */
    smpl_indx	max_sel;		/* size of largest  selection */
    selection_t	selection[MAX_CHANNELS];
};

struct undo_s
{
    undo_t	    *next;
    GtkWaveSet	    *ws;		/* display to update when done */
    void	    *cmd_arg;
    edit_enum_t	     cmd;
    char	     filename[NAME_MAX];
    int		     fd;
    gint32	     ref;		/* reference count */
    selection_set_t  selection_set;
    selection_t	     dcache;		/* display cache regen region */
    selection_t	     display;		/* redraw region */
    gint32	     size_change;
};

struct edit_s
{
    edit_enum_t	cmd;
    char	*name;
    gboolean	display_update;
    gboolean	undoable;
    gboolean	save_data;
    gboolean	(*func)(undo_t *);
};


/* prototypes */
gboolean edit_cmd(GtkWaveSet *ws, edit_enum_t cmd, void *cmd_arg, gboolean thread, pthread_t *new_thread);
void     edit_undos_free(GtkWaveSet *ws);

#endif /* _EDIT_H */
