/*
 * GNoise
 *
 * Copyright (C) 1999-2001 Dwight Engen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: dlgundo.c,v 1.5 2001/02/24 02:42:35 dengen Exp $
 *
 */

#include <gtk/gtk.h>
#include "gnoise.h"

static GtkWidget	*win_undo	= NULL;

void on_dlgundo(GtkMenuItem *menuitem, gpointer user_data)
{
    if ((!file_open) || (win_undo != NULL))
	return;

    win_undo = create_UndoDialog();
    gtk_widget_show(win_undo);
}


gboolean on_dlgundo_destroy(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
    win_undo = NULL;
    return FALSE;
}


void on_dlgundo_through(GtkButton *button, gpointer user_data)
{
}


void on_dlgundo_close(GtkButton *button, gpointer user_data)
{
    if (win_undo)
	gtk_widget_destroy(win_undo);
    win_undo = NULL;
}
