/******************************************************************************\
 gnofin/preferences-page-row-color.c   $Revision: 1.3 $
 Copyright (C) 2000 Saillard Luc

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

//#define ENABLE_DEBUG_TRACE

#include "common.h"
#include <gtk/gtksignal.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtktable.h>
#include <gtk/gtktooltips.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkcolorsel.h>
#include <gtk/gtkclist.h>
#include "preferences.h"
#include "preferences-pages.h"
#include "dialogs.h"
#include "row-color.h"


typedef struct {
  gpointer  key;
  GdkColor  row_bright_fg;
  GdkColor  row_bright_bg;
  GdkColor  row_dark_fg;
  GdkColor  row_dark_bg;
  GtkCList *clist;
  GdkColor *being_edited;
} PageContext;

static char *some_sampletext[]={"comment","-90.67","31415265359","blah blah blah"};

static void colorseldlg_destroy(GtkWidget *igad, GtkWidget *dgad);
static void colorseldlg_ok(GtkWidget *ok, GtkWidget *colorseldlg);
static void colorseldlg_update(GtkWidget *ok, GtkWidget *colorseldlg);
static void colorseldlg_create(GtkWidget *button, PageContext *page);


static void colorseldlg_destroy(GtkWidget *igad, GtkWidget *dgad)
{
  trace("");
  gtk_widget_hide (GTK_WIDGET(dgad));
}

static void colorseldlg_ok(GtkWidget *ok, GtkWidget *colorseldlg)
{
  trace("");
  colorseldlg_update(ok,colorseldlg);
  gtk_widget_hide(GTK_WIDGET(colorseldlg));
}

static void colorseldlg_update(GtkWidget *widget, GtkWidget *colorseldlg)
{
  GdkColor *gdk_color;
  GtkColorSelection *colorsel;
  PageContext *page;
  gdouble color[3];
  int i;

  trace("");
  /* Retrieve PageContext from colorseldlg */
  page=(PageContext *)gtk_object_get_user_data(GTK_OBJECT(colorseldlg));
  gdk_color=page->being_edited;

  colorsel=(GtkColorSelection *)GTK_COLOR_SELECTION_DIALOG(colorseldlg)->colorsel;
  gtk_color_selection_get_color (colorsel,color);
  gdk_color->red=(guint16)(color[0]*65535.0);
  gdk_color->green=(guint16)(color[1]*65535.0);
  gdk_color->blue=(guint16)(color[2]*65535.0);
  /* trace("%2.2x%2.2x%2.2x",gdk_color->red>>8,gdk_color->green>>8,gdk_color->blue>>8); */

  /* Update the sample table */
  for (i=0;i<4;i++)
   {
     gtk_clist_set_foreground(page->clist,i,(i&1?&(page->row_dark_fg):&(page->row_bright_fg)));
     gtk_clist_set_background(page->clist,i,(i&1?&(page->row_dark_bg):&(page->row_bright_bg)));
   }
  preferences_page_changed (page->key);
}

static void colorseldlg_create(GtkWidget *button, PageContext *page)
{
  static GtkWidget *colorseldlg=NULL;
  gdouble col[4];
  GdkColor *gdk_color;

  trace("");

  if (colorseldlg==NULL)
   {
     colorseldlg = gtk_color_selection_dialog_new ("Select color");
     gtk_widget_hide ( GTK_COLOR_SELECTION_DIALOG(colorseldlg)->help_button );
     gtk_signal_connect (GTK_OBJECT(((GtkColorSelectionDialog *)colorseldlg)->colorsel),
	 "color_changed", GTK_SIGNAL_FUNC (colorseldlg_update), colorseldlg);
     gtk_signal_connect (GTK_OBJECT (((GtkColorSelectionDialog *) colorseldlg)->ok_button),
	 "clicked", GTK_SIGNAL_FUNC (colorseldlg_ok), colorseldlg);
     gtk_signal_connect (GTK_OBJECT (((GtkColorSelectionDialog *) colorseldlg)->cancel_button),
	 "clicked", GTK_SIGNAL_FUNC (colorseldlg_destroy), colorseldlg);
     gtk_window_set_transient_for (GTK_WINDOW (colorseldlg), GTK_WINDOW (gtk_widget_get_toplevel (button)));
   }

  /* Retrieve color information from the button */
  gdk_color=gtk_object_get_user_data(GTK_OBJECT(button));
  col[0]=gdk_color->red/65535.0;
  col[1]=gdk_color->green/65535.0;
  col[2]=gdk_color->blue/65535.0;
  /* and use this color in the widget colorselection */
  gtk_color_selection_set_color ((GtkColorSelection *) ((GtkColorSelectionDialog *) colorseldlg)->colorsel, col);
  /* We keep color information into the PageContext, because we can edit only one color a the same time  */
  page->being_edited=gdk_color;
  gtk_object_set_user_data(GTK_OBJECT(colorseldlg),(gpointer)page);
  gtk_widget_show (colorseldlg);
}

static GtkWidget *make_page(PageContext *page)
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *button;
  GtkCList  *clist;
  int i;

  trace ("");
  vbox = gtk_vbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);

  /* Page description */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  label = gtk_label_new (_("Select the colors Gnofin should use for the rows\nof the transaction list."));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  /* Packing table */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  table = gtk_table_new (2, 3, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), 10);
  gtk_table_set_col_spacings (GTK_TABLE (table), 15);
  gtk_box_pack_start (GTK_BOX (hbox), table, FALSE, FALSE, 0);

  /* Line Bright */
  hbox=gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), hbox, 0, 1, 0, 1);
  label=gtk_label_new (_("Odd Line:"));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 20);

  button=gtk_button_new_with_label(_("Foreground"));
  gtk_table_attach_defaults(GTK_TABLE (table),button, 1, 2, 0, 1);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
      GTK_SIGNAL_FUNC (colorseldlg_create),(gpointer)page);
  gtk_object_set_user_data(GTK_OBJECT(button),&(page->row_bright_fg));

  button=gtk_button_new_with_label(_("Background"));
  gtk_table_attach_defaults(GTK_TABLE (table),button, 2, 3, 0, 1);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
      GTK_SIGNAL_FUNC (colorseldlg_create),(gpointer)page);
  gtk_object_set_user_data(GTK_OBJECT(button),&(page->row_bright_bg));

	/* Line Dark */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), hbox, 0, 1, 1, 2);
  label = gtk_label_new (_("Even Line:"));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 20);

  button=gtk_button_new_with_label(_("Foreground"));
  gtk_table_attach_defaults(GTK_TABLE (table),button, 1, 2, 1, 2);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
      GTK_SIGNAL_FUNC (colorseldlg_create),(gpointer)page);
  gtk_object_set_user_data(GTK_OBJECT(button),&(page->row_dark_fg));

  button=gtk_button_new_with_label(_("Background"));
  gtk_table_attach_defaults(GTK_TABLE (table),button, 2, 3, 1, 2);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
      GTK_SIGNAL_FUNC (colorseldlg_create),(gpointer)page);
  gtk_object_set_user_data(GTK_OBJECT(button),&(page->row_dark_bg));

  /* The sample table */
  hbox = gtk_hbox_new (FALSE, 0); 
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 5);

  clist=(GtkCList *)gtk_clist_new(4);
  page->clist=clist;
  gtk_clist_column_titles_show(clist);
  for (i=0;i<4;i++) /* We can do this because, it's a 4x4 table */
   {
     char buf[64];
     g_snprintf(buf,sizeof buf,_("Column %d"),i);
     gtk_clist_set_column_title(clist,i,buf);
     gtk_clist_set_column_width(clist,i,50);
     gtk_clist_append(clist,some_sampletext);
     gtk_clist_set_foreground(clist,i,(i&1?&(page->row_dark_fg):&(page->row_bright_fg)));
     gtk_clist_set_background(clist,i,(i&1?&(page->row_dark_bg):&(page->row_bright_bg)));
   }
  gtk_clist_columns_autosize (clist);
  gtk_box_pack_start (GTK_BOX (vbox), (GtkWidget *)clist, FALSE, FALSE, 10);
 
  return vbox;
}

static void
init_page (PageContext *page)
{
  int i;
  trace ("");

  row_color_get(&page->row_dark_fg,
		&page->row_dark_bg,
		&page->row_bright_fg,
		&page->row_bright_bg);
  /* Update the sample table */
  for (i=0;i<4;i++)
   {
     gtk_clist_set_foreground(page->clist,i,(i&1?&(page->row_dark_fg):&(page->row_bright_fg)));
     gtk_clist_set_background(page->clist,i,(i&1?&(page->row_dark_bg):&(page->row_bright_bg)));
   }
}

static gboolean
apply_page (GtkWindow *parent, PageContext *page)
{
  trace ("");

  row_color_set(&page->row_dark_fg,
		&page->row_dark_bg,
		&page->row_bright_fg,
		&page->row_bright_bg);

  return TRUE;
}

void
preferences_page_row_color_init (void)
{
  PreferencesPage page = {0};
  PageContext *context;

  trace ("");

  context = g_new0 (PageContext, 1);

  page.category = _("Appearance");
  page.label = _("Row Colors");
  page.make = (PreferencesPageMakeFunc) make_page;
  page.init = (PreferencesPageInitFunc) init_page;
  page.apply = (PreferencesPageApplyFunc) apply_page;
  page.user_data = context;
  
  context->key = preferences_page_register (&page);
}

