/******************************************************************************\
 gnofin/config-saver.h   $Revision: 1.2 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef CONFIG_SAVE_H
#define CONFIG_SAVE_H

GNOFIN_API_BEGIN

/* The configuration scheme for Gnofin is as follows:
 *   - each component loads its configuration separately and when needed
 *   - a component registers a save function when first used
 *   - the save functions might be called at any time
 */

typedef void (* ConfigSaveFunc) (gpointer user_data);

/* Each save function must be associated with a unique category */
gboolean config_saver_register   (const gchar *category, ConfigSaveFunc, gpointer user_data);
void     config_saver_unregister (const gchar *category);
void     config_save_all         (void);

GNOFIN_API_END

#endif
