/******************************************************************************\
 gnofin/plugin.c   $Revision: 1.1 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

/*
 * Sample plugin demostration
 *
 * Author:
 *   Darin Fisher (dfisher@jagger.me.berkeley.edu)
 */
 
#include "common.h"
#include "dialogs.h"
#include "plugin.h"
#include "gnofin-api.h"
#include "tool.h"
#include "dialogs.h"
#include "ui.h"

static void
run_tool (gpointer foo, UI *ui)
{
  trace ("");
  dialog_notice (ui_get_window (ui),
	       _("Sorry, but this feature is not yet implemented."));
}

static void
free_plugin (PluginData *pd)
{
  Tool *tool;

  trace ("");

  tool = (Tool *) pd->private_data;
  tool_unregister (tool);
  g_free (tool);
}

int
init_plugin (PluginData *pd)
{
  Tool *tool;
  guint maj, min;

  trace ("libfind");

  /* Verify gnofin API version */
  gnofin_api_version_get (&maj, &min);
  if ((maj != GNOFIN_API_VERSION_MAJOR) || (min  < GNOFIN_API_VERSION_MINOR))
    return PLUGIN_ERROR_INVALID_API;

  /* initialize PluginData structure */
  pd->free_plugin = free_plugin;
  pd->description = _("Search and replace plugin");
  pd->author = "None";

  /* register this tool */
  tool = g_new0 (Tool, 1);
  tool->name = _("Find");
  tool->label = _("_Find...");
  tool->description = _("Find transaction");
  tool->funcs.run = run_tool;
  tool_register (tool);

  /* remember our importer structure */
  pd->private_data = (gpointer) tool;

  return PLUGIN_OK;
}

