/**
 * GMyth Library
 * 
 * @file gmyth/gmyth_transcoder.h
 * 
 * @brief <p> This file contains the transcoder class.
 *
 * Copyright (C) 2007 INdT - Instituto Nokia de Tecnologia.
 * @author Artur Duque de Souza <artur.souza@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _GMYTH_TRANSCODER_H
#define _GMYTH_TRANSCODER_H

#include <glib.h>
#include <glib-object.h>

#include "gmyth_stringlist.h"
#include "gmyth_backendinfo.h"
#include "gmyth_socket.h"
#include "gmyth_http.h"
#include "gmyth_recprofile.h"

G_BEGIN_DECLS
#define GMYTH_TRANSCODER_TYPE               (gmyth_transcoder_get_type ())
#define GMYTH_TRANSCODER(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_TRANSCODER_TYPE, GMythTranscoder))
#define GMYTH_TRANSCODER_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_TRANSCODER_TYPE, GMythTranscoderClass))
#define IS_GMYTH_TRANSCODER(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMYTH_TRANSCODER_TYPE))
#define IS_GMYTH_TRANSCODER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_TRANSCODER_TYPE))
#define GMYTH_TRANSCODER_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_TRANSCODER_TYPE, GMythTranscoderClass))
#define DATE_ISO 0
#define DATE_FILE 1
typedef struct _GMythTranscoder GMythTranscoder;
typedef struct _GMythTranscoderClass GMythTranscoderClass;

struct _GMythTranscoderClass {
    GObjectClass    parent_class;

    /*
     * callbacks 
     */
};

/**
 * The GMythTranscoder structure is a class to implement functions
 * related to transcoding.
 */
struct _GMythTranscoder {
    GObject         parent;

    gboolean        cutlist;
    gboolean        output;
    gboolean        started;

    /*
     * private begin 
     */
    gchar          *output_filename;
    gchar          *filename;
    gchar          *profile;
    /*
     * private end 
     */

    gchar          *starttime;

    gint            chanid;

    GMythBackendInfo *backend_info;
};

GType           gmyth_transcoder_type(void);

GMythTranscoder *gmyth_transcoder_new(GMythBackendInfo * backend_info);
void            gmyth_transcoder_set_output(GMythTranscoder * transcode,
                                            gboolean value,
                                            const gchar * outputfile);
void            gmyth_transcoder_set_filename(GMythTranscoder * transcode,
                                              const gchar * file);
gint            gmyth_transcoder_set_profile(GMythTranscoder * trans,
                                             const gchar * value);
gboolean        gmyth_transcoder_start(GMythTranscoder * trans);
gboolean        gmyth_transcoder_pause(GMythTranscoder * trans);
gboolean        gmyth_transcoder_resume(GMythTranscoder * trans);
gboolean        gmyth_transcoder_cancel(GMythTranscoder * trans);
gint            gmyth_transcoder_get_progress(GMythTranscoder * trans);


G_END_DECLS
#endif /*_GMYTH_TRANSCODER_H*/
