.TH PSHISTOGRAM l "1 Nov 2006" "GMT4.1.4" "GMT4.1.4"
.SH NAME
pshistogram \- Bin data and plot histograms
.SH SYNOPSIS
\fBpshistogram\fB \fIfile\fP \fB\-Jx\fP|\fBX\fP\fIparameters\fP \fB\-W\fP\fIbin_width\fP [ \fB\-A\fP ] [ \fB\-B\fP[\fBp\fP|\fBs\fP]\fIparameters\fP ] 
[ \fB\-C\fP ] [ \fB\-E\fP\fIazimuth\fP/\fIelevation\fP ] [ \fB\-G\fP\fIfill\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-Jz\fP|\fBZ\fP\fIparameters\fP ] 
[ \fB\-I\fP[\fBo\fP|\fBO\fP] ] [ \fB\-K\fP ] [ \fB\-L\fP\fIpen\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-Q\fP ] 
[ \fB\-R\fP\fIxmin\fP/\fIxmax\fP/\fIymin\fP/\fIymax\fP[\fBr\fP] ] [ \fB\-S\fP ] [ \fB\-T\fP\fIcol\fP ] [ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ] [ \fB\-V\fP ]  
[ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ] [ \fB\-Y\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ] [ \fB\-Z\fP\fItype\fP ] [ \fB\-c\fP\fIcopies\fP ] 
[ \fB\-bi\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP[\fBi\fP|\fBo\fP]\fIcolinfo\fP ]
.SH DESCRIPTION
\fBpshistogram\fP reads \fIfile\fP [or standard input] and examines data column \fIcol\fP to
calculate histogram parameters based on the bin-width provided.  Using these parameters,
scaling, and optional range parameters it will generate \fIPostScript\fP code that plots a histogram.
A cumulative histogram may also be specified.  
.TP
\fIfile\fP
ASCII [or binary, see \fB\-b\fP] datafile. If no file is given, \fBpshistogram\fP will read standard input.
.TP
.B \-Jx
\fIxscale[/yscale]\fP (Linear scale(s) in distance unit/data unit).
.TP
.B \-W
Sets the bin width used for histogram calculations.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
Plot the histogram horizontally from x = 0 [Default is vertically from y = 0].
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-C
Center bin on each value. [Default is left edge].
.TP
.B \-E
Sets the viewpoint's azimuth and elevation (for perspective view) [180/90].\"'
.TP
.B \-G
Select filling of bars.  [Default is no fill].
Specify the grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
Alternatively, specify \fB\-Gp\fP\fIdpi/pattern\fP, where \fIpattern\fP gives
the number of the built-in pattern (1-90) \fIor\fP the name of a Sun 1-, 8-,
or 24-bit raster file. The \fIdpi\fP sets the resolution of the image. For
1-bit rasters: use \fB\-GP\fP for inverse video, or append
\fB:F\fP\fIcolor\fP[\fBB\fP[\fIcolor\fP]] to specify fore- and background
colors (use \fIcolor\fP = - for transparency).
See \fBGMT\fP Cookbook & Technical Reference Appendix E for information
on individual patterns.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-I
Inquire about min/max x and y after binning.  No plotting is done.  Append \fBo\fP
to output an ASCII table of the resulting x,y data to stdout.  Alternatively, append
\fBO\fP to output all x,y bin data even when y == 0.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Draw bar outline using the specified pen thickness.  [Default is no outline].
\fIpen\fP is a comma delimetered list of \fIwidth\fP, \fIcolor\fP and \fItexture\fP, each of which is optional.
\fIwidth\fP can be indicated as a measure (points, centimeters, inches) or as \fBfaint\fP, \fBthin\fP[\fBner\fP|\fBnest\fP],
\fBthick\fP[\fBer\fP|\fBest\fP], \fBfat\fP[\fBter\fP|\fBtest\fP], or \fBobese\fP.
\fIcolor\fP specifies a grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
\fItexture\fP is a combination of dashes `-' and dots `.'.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-Q
Draw a cumulative histogram.
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
If not given, \fBpshistogram\fP will automatically find reasonable values for the region.
.TP
.B \-S
Draws a stairs-step diagram instead of histogram.
.TP
.B \-T
Specify which column to use for the histogram data.  First column is 0 [0].
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift plot origin relative to the current origin by (\fIx-shift,y-shift\fP) and
optionally append the length unit (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
You can prepend \fBa\fP to shift the origin back to the original position after plotting,
or prepend  \fBr\fP [Default] to reset the current origin to the new location.
If \fB\-O\fP is used then the default (\fIx-shift,y-shift\fP) is (0,0), otherwise it is
(r1i, r1i) or (r2.5c, r2.5c).
Alternatively, give \fBc\fP to align the center coordinate (x or y) of the plot with the center of the page
based on current page size.
.TP
.B \-Z
Choose between 6 types of histograms: 0 = counts [Default], 1 = frequency_percent,
2 = log (1.0 + count), 3 = log (1.0 + frequency_percent),
4 = log10 (1.0 + count), 5 = log10 (1.0 + frequency_percent).
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 2 input columns].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH EXAMPLES
To draw a histogram of the data v3206.t containing seafloor depths, using a 250 meter
bin width, center bars, and draw bar outline, use:
.br
.sp
\fBpshistogram\fP v3206.t \fB\-JX\fPh \fB\-W\fP250 \fB\-C \-L\fP0.5\fBp\fP \fB\-V\fP > plot.ps
.br
.sp
If you know the distribution of your data, you may explicitly specify range and scales.  E.g.,
to plot a histogram of the y-values (2nd column) in the file errors.xy using a 1 meter
bin width, plot from -10 to +10 meters @ 0.75 cm/m, annotate every 2 m and 100 counts,
and use black bars, run:
.br
.sp
\fBpshistogram\fP errors.xy \fB\-W\fP1 \fB\-R\fP-10/10/0/0 \fB\-Jx\fP0.75\fBc\fP/0.01\fBc\fP
\fB\-B\fP2:Error:/100:Counts: \fB\-G\fPblack \fB\-T\fP1 \fB\-V\fP > plot.ps
.br
.sp
Since no y-range was specified, pshistogram will calculate ymax in even increments of 100.
.SH BUGS
The \fB\-W\fP option does not yet work properly with time series data (e.g., \fB\-f\fP0T).  Thus, such
variable intervals as months and years are not calculated.  Instead, specify your interval in the
same units as the current setting of \fBTIME_UNIT\fP.
.SH "SEE ALSO"
.IR GMT (l),
.IR psbasemap (l),
.IR psrose (l),
.IR psxy (l)
