.TH MGD77PATH GMTMANSECTION "1 Nov 2006" "GMT4.1.4" "GMT4.1.4"
.SH NAME
mgd77path \- Get full pathname for MGD77 files
.SH SYNOPSIS
\fBmgd77path\fP \fINGDC-ids\fP [ \fB\-D\fP ] [ \fB\-I\fP\fIignore\fP ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBmgd77path\fP returns the full pathname to one or more MGD77 files. The pathname returned for a given
cruise may change with time due to reshuffling of disks/subdirectories.
.TP
\fINGDC-ids\fP
Can be one or more of five kinds of specifiers:
.br
1) 8-character NGDC IDs, e.g., 01010083, JA010010etc., etc.
.br
2) 2-character <agency> codes which will return all cruises from each agency.
.br
3) 4-character <agency><vessel> codes, which will return all cruises from those vessels.
.br
4) =<list>, where <list> is a table with NGDC IDs, one per line.
.br
5) If nothing is specified we return all cruises in the data base.
.br
(See mgd77info \fB\-F\fP for agency and vessel codes).
The ".mgd77" or ".nc" extensions will automatically be appended, if needed (use \fB\-I\fP
to ignore certain file types).  Cruise files will be looked for first in the current directory
and second in all directories listed in \fB$MGD77_HOME\fP/mgd77_paths.txt [If \fB$MGD77_HOME\fP
is not set it will default to \fB$GMTHOME\fP/share/mgd77].
.br
NOTE: Under Windows, only (1) and (4) are currently supported.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-D
Instead of cruise listings, just show the directory paths currently used in the search.
.TP
.B \-I
Ignore certain data file formats from consideration. Append \fBa|c|t\fP to ignore
MGD77 ASCII, MGD77+ netCDF, or plain tab-separated ASCII table files, respectively. The option may
be repreated to ignore more than one format.  [Default ignores none].
.TP
.B \-V
Report the total number of cruises found.
.SH EXAMPLES
To obtain pathnames for cruises 01010008 and 01010007, run
.br
.sp
\fBmgd77path\fP 01010008 01010007
.br
.sp
To obtain pathnames for cruises 01010008 and 01010007, but only if there are MGD77+ version in netCDF, run
.br
.sp
\fBmgd77path\fP 01010008 01010007 \fB\-Ia \-It\fP
.br
.sp
To see the list of active directories where MGD77 files might be stored, run
.br
.sp
\fBmgd77path\fP \fB\-D\fP
.SH "SEE ALSO"
.IR GMT (GMTMANSECTION)
.IR mgd77info (GMTMANSECTION)
.IR mgd77list (GMTMANSECTION)
.IR mgd77manage (GMTMANSECTION)
.IR mgd77track (GMTMANSECTION)
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 2005, The Generic Mapping Tools (GMT) version
4.1 Technical Reference & Cookbook, SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1998, New, Improved Version of Generic Mapping
Tools Released, EOS Trans., AGU, 79 (47), p. 579.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, EOS Trans., AGU, 76 (33), p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the
American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data,
EOS Trans., AGU, 72 (41), p. 441.
.br
The Marine Geophysical Data Exchange Format - "MGD77", see
\fIhttp://www.ngdc.noaa.gov/mgg/dat/geodas/docs/mgd77.txt\fP
.br
