.TH X2SYS_CROSS l "1 Jan 2004"
.SH NAME
\fBx2sys_cross\fP \- Find and compute Cross-Over Errors
.SH SYNOPSIS
\fBx2sys_cross\fP \fIfile(s)\fP OR \fB\-L\fP\fIflist\fP [ \fB\-A\fP\fIgap\fP ]
[ \fB\-Cc|f|g\fP ] [ \fB\-D\fP\fIdeffile\fP ] [ \fB\-F\fP\fIflags\fP ]
[ \fB\-Gd|g\fP ] [ \fB\-J\fP\fIparams\fP ] [\fB\-K\fP\fIcombi.lis\fP]
[ \fB\-N\fP\fIwindow\fP ] [ \fB\-O\fP ] [ \fB\-Sl|u\fP\fIspeed\fP ]
[ \fB\-Tl|a|c\fP ] [ \fB\-W\fP\fIsize\fP ] [ \fB\-V\fP ] [ \fB\-Xe|i\fP ]
[ \fB\-bo\fP[\fBs\fP][\fIn\fP] ] [ \fB\-2\fP ]
.SH DESCRIPTION
\fBx2sys_cross\fP is used to determine all intersections between or within
tracks, and report the time, position, discrepancies in all observables, the
mean values of the observables, heading along each track segment, and the
distance along track at the cross-over point. The names of the files are passed
on the command line, or as a list of files with the \fB\-L\fP option.
If they are identical or only one name is passed, then
\fBx2sys_cross\fP will also look for internal cross-overs. The optional
parameters are:
.TP
.B \-A
Ignore crossovers on segments of length > \fIgap\fP [no gap checking].
.TP
.B \-C
Select procedure for along-track distance calculation:
.br
        \fBc\fP Cartesian distances [Default].
.br
        \fBf\fP Flat earth distances.
.br
        \fBg\fP Great circle distances.
.br
.TP
.B \-D
Give the definition file for this data format [x2sys].
.TP
.B \-F
Sets which columns to use. Give a comma-separated list of column names [Default
is all columns].
.TP
.B \-G
Selects geographical coordinates. Append \fBd\fP for discontinuity at the
Dateline (makes longitude go from -180 to + 180) or \fBg\fP for discontinuity
at Greenwhich (makes longitude go from 0 to 360 [Default]).
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in .gmtdefaults, but this can be
overridden on the command line by appending the c, i, or m to the scale/width value.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-K
Only process the pair-combinations found in the file \fIcombi.lis\fP
[Default process all possible combinations among the specified files].
Suitable option for passing old \fBx_setup\fP output.
.TP
.B \-N
Maximum number of points to use in the interpolation [6].
.TP
.B \-O
Output results using the old XOVER format [Default is X2SYS format].
This option should only be used with *.gmt-formatted MGD77 files.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest. To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.TP
.B \-S
Defines window of track speed within which to calculate crossovers.
.br
        \fB\-Sl\fP sets lower speed [Default is 0].
.br
        \fB\-Su\fP sets upper speed [Default is Infinity].
.br
.TP
.B \-T
Sets the interpolation mode. Choose among:
.br
        l Linear interpolation [Default].
.br
        a Akima spline interpolation.
.br
        c Cubic spline interpolation.
.br
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Sets maximum time gap (in user units) allowed between points on either
side of a crossover [Default is Infinity].
.TP
.B \-X
Append \fBe\fP for external crossovers only, and \fBi\fP for internal
crossovers only [Default is all crossovers].
.TP
.B \-2
Report the values of each track at the crossover [Default is the crossover value and the mean value].
.TP
.B \-bo
Selects binary output. Append \fBs\fP for single precision [Default is double].
.SH REMARKS
The COEs found are printed out to standard output in ASCII format (unless
\fB\-bo\fP is set). When ASCII is chosen, the output format depends on
whether or not old-style XOVER output (\fB\-O\fP) has been selected.
If so, then the first record contains the file names and their start year,
whereas subsequent records have the data for each COE encountered. The fields
written out are lat, lon, time along track #1, time along track #2,
x_gravity, x_magnetics, x_bathymetry, average gravity, average magnetics,
average bathymetry, heading along track #1, and heading along track #2. If
the default format is chosen then the header record starts with "> ", and
the output format for crossovers are first 8 columns that contain
x, y, time along track #1, time along track #2, distance along track #1,
distance along track #2, heading along track #1, and heading along track #2,
and then pairs of (COE, average value) for each data type. Sign convention:
If lega and legb are passed on the command line, then the COE value is Value
(lega) - Value (legb). It is recommended that the Akima's spline is used'
instead of the natural cubic spline, since it is less sensitive to outliers
that tend to introduce wild oscillations in the interpolation.
.SH EXAMPLES
To compute all internal crossovers in the gmt-formatted file c2104.gmt, and
output in the old XOVER format, use
.br
.sp
\fBx2sys_cross\fP c2104.gmt \fB\-O \-D\fPgmt > c2104.d
.br
.sp
To find the crossover locations with bathymetry between the two MGD77
files A13232.mgd77 and A99938.mgd77, try
.br
.sp
\fBx2sys_cross\fP A13232.mgd77 A99938.mgd77 \fB\-Xe \-D\fPmgd77 \fB\-F\fPlon,lat,top > crossovers.d
.SH "SEE ALSO"
.IR gmt (GMTMANSECTION),
.IR x2sys_datalist (GMTMANSECTION)
