/* gmpc-song-links.c generated by valac, the Vala compiler
 * generated from gmpc-song-links.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2010 Qball Cow <qball@sarine.nl>
 * Project homepage: http://gmpc.wikia.com/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include "gmpc-extras.h"
#include <libmpd/libmpdclient.h>
#include <libmpd/libmpd.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <misc.h>
#include <glib/gi18n-lib.h>
#include <plugin.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gmpc_easy_download.h>

#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _GmpcSongLinksPrivate {
	GmpcSongLinksType type;
	mpd_Song* song;
};


extern gboolean initialized;
gboolean initialized = FALSE;
static gpointer gmpc_song_links_parent_class = NULL;

#define use_transition_sl TRUE
#define GMPC_SONG_LINKS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_SONG_TYPE_LINKS, GmpcSongLinksPrivate))
enum  {
	GMPC_SONG_LINKS_DUMMY_PROPERTY
};
#define GMPC_SONG_LINKS_some_unique_name VERSION
static void gmpc_song_links_open_uri_function (GtkLinkButton* but, const char* uri);
static void gmpc_song_links_parse_uris (GmpcSongLinks* self);
static void _gmpc_song_links_open_uri_function_gtk_link_button_uri_func (GtkLinkButton* button, const char* link_, gpointer self);
static void gmpc_song_links_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);




GType gmpc_song_links_type_get_type (void) {
	static GType gmpc_song_links_type_type_id = 0;
	if (G_UNLIKELY (gmpc_song_links_type_type_id == 0)) {
		static const GEnumValue values[] = {{GMPC_SONG_LINKS_TYPE_ARTIST, "GMPC_SONG_LINKS_TYPE_ARTIST", "artist"}, {GMPC_SONG_LINKS_TYPE_ALBUM, "GMPC_SONG_LINKS_TYPE_ALBUM", "album"}, {GMPC_SONG_LINKS_TYPE_SONG, "GMPC_SONG_LINKS_TYPE_SONG", "song"}, {0, NULL, NULL}};
		gmpc_song_links_type_type_id = g_enum_register_static ("GmpcSongLinksType", values);
	}
	return gmpc_song_links_type_type_id;
}


static void gmpc_song_links_open_uri_function (GtkLinkButton* but, const char* uri) {
	g_return_if_fail (but != NULL);
	g_return_if_fail (uri != NULL);
	open_uri (uri);
}


static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


static void _gmpc_song_links_open_uri_function_gtk_link_button_uri_func (GtkLinkButton* button, const char* link_, gpointer self) {
	gmpc_song_links_open_uri_function (button, link_);
}


GmpcSongLinks* gmpc_song_links_construct (GType object_type, GmpcSongLinksType type, const mpd_Song* song) {
	GmpcSongLinks * self;
	mpd_Song* _tmp0_;
	GtkEventBox* event;
	GtkLabel* label;
	char* _tmp1_;
	g_return_val_if_fail (song != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	self->priv->type = type;
	self->priv->song = (_tmp0_ = _mpd_songDup0 (song), _mpd_freeSong0 (self->priv->song), _tmp0_);
	event = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ());
	label = g_object_ref_sink ((GtkLabel*) gtk_label_new (""));
	gtk_container_add ((GtkContainer*) event, (GtkWidget*) label);
	gtk_event_box_set_visible_window (event, FALSE);
	gtk_frame_set_label_widget ((GtkFrame*) self, (GtkWidget*) event);
	gtk_label_set_markup (label, _tmp1_ = g_strdup_printf ("<b>%s:</b>", _ ("Web Links")));
	_g_free0 (_tmp1_);
	g_object_set ((GtkFrame*) self, "shadow", GTK_SHADOW_NONE, NULL);
	gmpc_song_links_parse_uris (self);
	if (!initialized) {
		gtk_link_button_set_uri_hook (_gmpc_song_links_open_uri_function_gtk_link_button_uri_func, NULL, NULL);
		initialized = TRUE;
	}
	_g_object_unref0 (event);
	_g_object_unref0 (label);
	return self;
}


GmpcSongLinks* gmpc_song_links_new (GmpcSongLinksType type, const mpd_Song* song) {
	return gmpc_song_links_construct (GMPC_SONG_TYPE_LINKS, type, song);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally13;
	__catch13_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void gmpc_song_links_parse_uris (GmpcSongLinks* self) {
	GError * _inner_error_;
	GtkWidget* child;
	GKeyFile* file;
	char* path;
	GtkAlignment* ali;
	GtkVBox* vbox;
	char** _tmp2_;
	gint groups_size;
	gint groups_length1;
	gsize _tmp1_;
	char** groups;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	child = _g_object_ref0 (gtk_bin_get_child ((GtkBin*) self));
	if (child != NULL) {
		gtk_object_destroy ((GtkObject*) child);
	}
	file = g_key_file_new ();
	path = gmpc_get_user_path ("weblinks.list");
	if (!g_file_test (path, G_FILE_TEST_EXISTS)) {
		char* _tmp0_;
		path = (_tmp0_ = gmpc_get_full_glade_path ("weblinks.list"), _g_free0 (path), _tmp0_);
		if (!g_file_test (path, G_FILE_TEST_EXISTS)) {
			_g_object_unref0 (child);
			_g_key_file_free0 (file);
			_g_free0 (path);
			return;
		}
	}
	{
		g_key_file_load_from_file (file, path, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stdout, "Failed to load file: %s\n", path);
			_g_error_free0 (e);
			_g_object_unref0 (child);
			_g_key_file_free0 (file);
			_g_free0 (path);
			return;
		}
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (child);
		_g_key_file_free0 (file);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	ali = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.0f, 0.0f, 0.0f, 0.0f));
	gtk_alignment_set_padding (ali, (guint) 8, (guint) 8, (guint) 12, (guint) 6);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) ali);
	vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) vbox);
	groups = (_tmp2_ = g_key_file_get_groups (file, &_tmp1_), groups_length1 = _tmp1_, groups_size = groups_length1, _tmp2_);
	{
		char** entry_collection;
		int entry_collection_length1;
		int entry_it;
		entry_collection = groups;
		entry_collection_length1 = groups_length1;
		for (entry_it = 0; entry_it < groups_length1; entry_it = entry_it + 1) {
			char* entry;
			entry = g_strdup (entry_collection[entry_it]);
			{
				{
					char* typestr;
					char* uri;
					GmpcSongLinksType type = 0;
					GQuark _tmp16_;
					const char* _tmp15_;
					static GQuark _tmp16__label0 = 0;
					static GQuark _tmp16__label1 = 0;
					typestr = g_key_file_get_string (file, entry, "type", &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch12_g_error;
					}
					uri = g_key_file_get_string (file, entry, "url", &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_free0 (typestr);
						goto __catch12_g_error;
					}
					_tmp15_ = typestr;
					_tmp16_ = (NULL == _tmp15_) ? 0 : g_quark_from_string (_tmp15_);
					if (_tmp16_ == ((0 != _tmp16__label0) ? _tmp16__label0 : (_tmp16__label0 = g_quark_from_static_string ("artist"))))
					do {
						type = GMPC_SONG_LINKS_TYPE_ARTIST;
						if (self->priv->song->artist != NULL) {
							char* _tmp4_;
							char* _tmp3_;
							uri = (_tmp4_ = string_replace (uri, "%ARTIST%", _tmp3_ = gmpc_easy_download_uri_escape (self->priv->song->artist)), _g_free0 (uri), _tmp4_);
							_g_free0 (_tmp3_);
						}
						break;
					} while (0); else if (_tmp16_ == ((0 != _tmp16__label1) ? _tmp16__label1 : (_tmp16__label1 = g_quark_from_static_string ("album"))))
					do {
						type = GMPC_SONG_LINKS_TYPE_ALBUM;
						if (self->priv->song->album != NULL) {
							char* _tmp6_;
							char* _tmp5_;
							uri = (_tmp6_ = string_replace (uri, "%ALBUM%", _tmp5_ = gmpc_easy_download_uri_escape (self->priv->song->album)), _g_free0 (uri), _tmp6_);
							_g_free0 (_tmp5_);
						}
						if (self->priv->song->artist != NULL) {
							char* _tmp8_;
							char* _tmp7_;
							uri = (_tmp8_ = string_replace (uri, "%ARTIST%", _tmp7_ = gmpc_easy_download_uri_escape (self->priv->song->artist)), _g_free0 (uri), _tmp8_);
							_g_free0 (_tmp7_);
						}
						break;
					} while (0); else
					do {
						type = GMPC_SONG_LINKS_TYPE_SONG;
						if (self->priv->song->title != NULL) {
							char* _tmp10_;
							char* _tmp9_;
							uri = (_tmp10_ = string_replace (uri, "%TITLE%", _tmp9_ = gmpc_easy_download_uri_escape (self->priv->song->title)), _g_free0 (uri), _tmp10_);
							_g_free0 (_tmp9_);
						}
						if (self->priv->song->album != NULL) {
							char* _tmp12_;
							char* _tmp11_;
							uri = (_tmp12_ = string_replace (uri, "%ALBUM%", _tmp11_ = gmpc_easy_download_uri_escape (self->priv->song->album)), _g_free0 (uri), _tmp12_);
							_g_free0 (_tmp11_);
						}
						if (self->priv->song->artist != NULL) {
							char* _tmp14_;
							char* _tmp13_;
							uri = (_tmp14_ = string_replace (uri, "%ARTIST%", _tmp13_ = gmpc_easy_download_uri_escape (self->priv->song->artist)), _g_free0 (uri), _tmp14_);
							_g_free0 (_tmp13_);
						}
						break;
					} while (0); {
						char* sar;
						sar = g_key_file_get_string (file, entry, "search-and-replace", &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch14_g_error;
						}
						if (sar != NULL) {
							char** _tmp18_;
							gint s_size;
							gint s_length1;
							char** _tmp17_;
							char** s;
							s = (_tmp18_ = _tmp17_ = g_strsplit (sar, "::", 0), s_length1 = _vala_array_length (_tmp17_), s_size = s_length1, _tmp18_);
							if (s_length1 == 2) {
								{
									GRegex* regex;
									char* _tmp19_;
									char* _tmp20_;
									regex = g_regex_new (s[0], 0, 0, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == G_REGEX_ERROR) {
											goto __catch15_g_regex_error;
										}
										s = (_vala_array_free (s, s_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (sar);
										_g_free0 (typestr);
										_g_free0 (uri);
										_g_free0 (entry);
										_g_object_unref0 (child);
										_g_key_file_free0 (file);
										_g_free0 (path);
										_g_object_unref0 (ali);
										_g_object_unref0 (vbox);
										groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
									_tmp19_ = g_regex_replace_literal (regex, uri, (gssize) (-1), 0, s[1], 0, &_inner_error_);
									if (_inner_error_ != NULL) {
										_g_regex_unref0 (regex);
										if (_inner_error_->domain == G_REGEX_ERROR) {
											goto __catch15_g_regex_error;
										}
										_g_regex_unref0 (regex);
										s = (_vala_array_free (s, s_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (sar);
										_g_free0 (typestr);
										_g_free0 (uri);
										_g_free0 (entry);
										_g_object_unref0 (child);
										_g_key_file_free0 (file);
										_g_free0 (path);
										_g_object_unref0 (ali);
										_g_object_unref0 (vbox);
										groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
									uri = (_tmp20_ = _tmp19_, _g_free0 (uri), _tmp20_);
									_g_regex_unref0 (regex);
								}
								goto __finally15;
								__catch15_g_regex_error:
								{
									GError * e;
									e = _inner_error_;
									_inner_error_ = NULL;
									{
										fprintf (stdout, "Failed to compile regex: '%s'\n", e->message);
										_g_error_free0 (e);
									}
								}
								__finally15:
								if (_inner_error_ != NULL) {
									s = (_vala_array_free (s, s_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (sar);
									goto __catch14_g_error;
								}
							}
							s = (_vala_array_free (s, s_length1, (GDestroyNotify) g_free), NULL);
						}
						_g_free0 (sar);
					}
					goto __finally14;
					__catch14_g_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						{
							_g_error_free0 (e);
						}
					}
					__finally14:
					if (_inner_error_ != NULL) {
						_g_free0 (typestr);
						_g_free0 (uri);
						goto __catch12_g_error;
					}
					if (((gint) type) <= ((gint) self->priv->type)) {
						GtkLinkButton* label;
						char* _tmp21_;
						label = g_object_ref_sink ((GtkLinkButton*) gtk_link_button_new (uri));
						gtk_button_set_label ((GtkButton*) label, _tmp21_ = g_strdup_printf (_ ("Lookup %s on %s"), _ (typestr), entry));
						_g_free0 (_tmp21_);
						gtk_button_set_alignment ((GtkButton*) label, 0.0f, 0.5f);
						gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) label, FALSE, TRUE, (guint) 0);
						_g_object_unref0 (label);
					}
					_g_free0 (typestr);
					_g_free0 (uri);
				}
				goto __finally12;
				__catch12_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						fprintf (stdout, "Failed to get entry from %s: '%s'\n", path, e->message);
						_g_error_free0 (e);
					}
				}
				__finally12:
				if (_inner_error_ != NULL) {
					_g_free0 (entry);
					_g_object_unref0 (child);
					_g_key_file_free0 (file);
					_g_free0 (path);
					_g_object_unref0 (ali);
					_g_object_unref0 (vbox);
					groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (entry);
			}
		}
	}
	_g_object_unref0 (child);
	_g_key_file_free0 (file);
	_g_free0 (path);
	_g_object_unref0 (ali);
	_g_object_unref0 (vbox);
	groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
}


static void gmpc_song_links_class_init (GmpcSongLinksClass * klass) {
	gmpc_song_links_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcSongLinksPrivate));
	G_OBJECT_CLASS (klass)->finalize = gmpc_song_links_finalize;
}


static void gmpc_song_links_instance_init (GmpcSongLinks * self) {
	self->priv = GMPC_SONG_LINKS_GET_PRIVATE (self);
	self->priv->type = GMPC_SONG_LINKS_TYPE_ARTIST;
	self->priv->song = NULL;
}


static void gmpc_song_links_finalize (GObject* obj) {
	GmpcSongLinks * self;
	self = GMPC_SONG_LINKS (obj);
	{
	}
	_mpd_freeSong0 (self->priv->song);
	G_OBJECT_CLASS (gmpc_song_links_parent_class)->finalize (obj);
}


GType gmpc_song_links_get_type (void) {
	static GType gmpc_song_links_type_id = 0;
	if (gmpc_song_links_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcSongLinksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_song_links_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcSongLinks), 0, (GInstanceInitFunc) gmpc_song_links_instance_init, NULL };
		gmpc_song_links_type_id = g_type_register_static (GTK_TYPE_FRAME, "GmpcSongLinks", &g_define_type_info, 0);
	}
	return gmpc_song_links_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




