/* gmpc-image-async.c generated by valac, the Vala compiler
 * generated from gmpc-image-async.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2010 Qball Cow <qball@sarine.nl>
 * Project homepage: http://gmpc.wikia.com/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "gmpc-extras.h"
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gtk/gtk.h>
#include <plugin.h>
#include <config1.h>
#include <float.h>
#include <math.h>
#include <misc.h>
#include <Widgets/pixbuf-cache.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_tree_row_reference_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_row_reference_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _GmpcPixbufLoaderAsyncLoadFromFileAsyncData GmpcPixbufLoaderAsyncLoadFromFileAsyncData;

struct _GmpcPixbufLoaderAsyncPrivate {
	GCancellable* pcancel;
	GdkPixbuf* _pixbuf;
	GtkTreeRowReference* rref;
};

struct _Block2Data {
	int _ref_count_;
	GmpcPixbufLoaderAsync * self;
	GdkPixbufLoader* loader;
	gint size;
	gboolean border;
	gpointer _async_data_;
};

struct _GmpcPixbufLoaderAsyncLoadFromFileAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GmpcPixbufLoaderAsync* self;
	char* uri;
	gint size;
	GCancellable* cancel;
	gboolean border;
	GFile* file;
	gsize _result_;
	GFileInputStream* stream;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	guchar data[1024];
	gssize _tmp3_;
	GError * erro;
	GError * e;
	GError * err;
	GdkPixbuf* pix;
	GdkPixbuf* final;
	GdkPixbuf* _tmp4_;
	GdkPixbufLoader* _tmp5_;
	Block2Data* _data2_;
	GError * _inner_error_;
};

struct _GmpcMetaImageAsyncPrivate {
	GmpcPixbufLoaderAsync* loader;
};


static gpointer gmpc_pixbuf_loader_async_parent_class = NULL;
static gpointer gmpc_meta_image_async_parent_class = NULL;

#define LOG_DOMAIN "ImageAsync"
#define GMPC_PIXBUF_LOADER_ASYNC_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_TYPE_PIXBUF_LOADER_ASYNC, GmpcPixbufLoaderAsyncPrivate))
enum  {
	GMPC_PIXBUF_LOADER_ASYNC_DUMMY_PROPERTY,
	GMPC_PIXBUF_LOADER_ASYNC_PIXBUF
};
static void gmpc_pixbuf_loader_async_call_row_changed (GmpcPixbufLoaderAsync* self);
static GdkPixbuf* gmpc_pixbuf_loader_async_modify_pixbuf (GmpcPixbufLoaderAsync* self, GdkPixbuf* pix, gint size, gboolean casing);
static void gmpc_pixbuf_loader_async_load_from_file_async (GmpcPixbufLoaderAsync* self, const char* uri, gint size, GCancellable* cancel, gboolean border, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gmpc_pixbuf_loader_async_load_from_file_finish (GmpcPixbufLoaderAsync* self, GAsyncResult* _res_);
static void gmpc_pixbuf_loader_async_load_from_file_async_data_free (gpointer _data);
static void gmpc_pixbuf_loader_async_load_from_file_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _lambda1_ (GdkPixbufLoader* source, gint width, gint height, Block2Data* _data2_);
static void __lambda1__gdk_pixbuf_loader_size_prepared (GdkPixbufLoader* _sender, gint width, gint height, gpointer self);
static void _lambda2_ (GdkPixbufLoader* source, Block2Data* _data2_);
static void __lambda2__gdk_pixbuf_loader_area_prepared (GdkPixbufLoader* _sender, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean gmpc_pixbuf_loader_async_load_from_file_async_co (GmpcPixbufLoaderAsyncLoadFromFileAsyncData* data);
static GObject * gmpc_pixbuf_loader_async_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gmpc_pixbuf_loader_async_finalize (GObject* obj);
static void gmpc_pixbuf_loader_async_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gmpc_pixbuf_loader_async_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GMPC_META_IMAGE_ASYNC_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_TYPE_META_IMAGE_ASYNC, GmpcMetaImageAsyncPrivate))
enum  {
	GMPC_META_IMAGE_ASYNC_DUMMY_PROPERTY
};
static void _lambda3_ (GmpcPixbufLoaderAsync* source, GdkPixbuf* pixbuf, GmpcMetaImageAsync* self);
static void __lambda3__gmpc_pixbuf_loader_async_pixbuf_update (GmpcPixbufLoaderAsync* _sender, GdkPixbuf* pixbuf, gpointer self);
static GObject * gmpc_meta_image_async_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gmpc_meta_image_async_finalize (GObject* obj);



static gpointer _gtk_tree_row_reference_copy0 (gpointer self) {
	return self ? gtk_tree_row_reference_copy (self) : NULL;
}


void gmpc_pixbuf_loader_async_set_rref (GmpcPixbufLoaderAsync* self, const GtkTreeRowReference* rreference) {
	GtkTreeRowReference* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rreference != NULL);
	self->priv->rref = (_tmp0_ = _gtk_tree_row_reference_copy0 (rreference), _gtk_tree_row_reference_free0 (self->priv->rref), _tmp0_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gmpc_pixbuf_loader_async_call_row_changed (GmpcPixbufLoaderAsync* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->rref != NULL) {
		GtkTreeModel* model;
		GtkTreePath* path;
		GtkTreeIter iter = {0};
		model = _g_object_ref0 (gtk_tree_row_reference_get_model (self->priv->rref));
		path = gtk_tree_row_reference_get_path (self->priv->rref);
		if (gtk_tree_model_get_iter (model, &iter, path)) {
			gtk_tree_model_row_changed (model, path, &iter);
		}
		_g_object_unref0 (model);
		_gtk_tree_path_free0 (path);
	}
}


static GdkPixbuf* gmpc_pixbuf_loader_async_modify_pixbuf (GmpcPixbufLoaderAsync* self, GdkPixbuf* pix, gint size, gboolean casing) {
	GdkPixbuf* result;
	GError * _inner_error_;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	if (pix == NULL) {
		result = NULL;
		return result;
	}
	if (casing) {
		_tmp0_ = cfg_get_single_value_as_int_with_default (config, "metaimage", "addcase", 1) == 1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint width;
		gint height;
		double spineRatio;
		GtkIconInfo* ii;
		width = gdk_pixbuf_get_width (pix);
		height = gdk_pixbuf_get_height (pix);
		spineRatio = 5.0 / 65.0;
		ii = gtk_icon_theme_lookup_icon (gtk_icon_theme_get_default (), "stylized-cover", size, 0);
		if (ii != NULL) {
			char* path;
			path = g_strdup (gtk_icon_info_get_filename (ii));
			{
				GdkPixbuf* case_image;
				gint tempw;
				GdkPixbuf* pix2;
				GdkPixbuf* blank;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint temph;
				case_image = gdk_pixbuf_new_from_file_at_scale (path, size, size, TRUE, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch1_g_error;
				}
				tempw = (gint) (gdk_pixbuf_get_width (case_image) * (1.0 - spineRatio));
				pix2 = NULL;
				if (((gdk_pixbuf_get_height (case_image) / ((double) height)) * width) < tempw) {
					GdkPixbuf* _tmp1_;
					pix2 = (_tmp1_ = gdk_pixbuf_scale_simple (pix, tempw, (gint) ((height * tempw) / width), GDK_INTERP_BILINEAR), _g_object_unref0 (pix2), _tmp1_);
				} else {
					GdkPixbuf* _tmp2_;
					pix2 = (_tmp2_ = gdk_pixbuf_scale_simple (pix, (gint) (width * (gdk_pixbuf_get_height (case_image) / ((double) height))), gdk_pixbuf_get_height (case_image), GDK_INTERP_BILINEAR), _g_object_unref0 (pix2), _tmp2_);
				}
				blank = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, gdk_pixbuf_get_width (case_image), gdk_pixbuf_get_height (case_image));
				gdk_pixbuf_fill (blank, (guint32) 0x000000FF);
				if (tempw >= gdk_pixbuf_get_width (pix2)) {
					_tmp3_ = gdk_pixbuf_get_width (pix2);
				} else {
					_tmp3_ = tempw;
				}
				tempw = _tmp3_;
				if (gdk_pixbuf_get_height (case_image) > gdk_pixbuf_get_height (pix2)) {
					_tmp4_ = gdk_pixbuf_get_height (pix2);
				} else {
					_tmp4_ = gdk_pixbuf_get_height (case_image);
				}
				temph = _tmp4_;
				gdk_pixbuf_copy_area (pix2, 0, 0, tempw - 1, temph - 2, blank, gdk_pixbuf_get_width (case_image) - tempw, 1);
				gdk_pixbuf_composite (case_image, blank, 0, 0, gdk_pixbuf_get_width (case_image), gdk_pixbuf_get_height (case_image), (double) 0, (double) 0, (double) 1, (double) 1, GDK_INTERP_BILINEAR, 250);
				result = blank;
				_g_object_unref0 (case_image);
				_g_object_unref0 (pix2);
				_g_free0 (path);
				_gtk_icon_info_free0 (ii);
				return result;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (e);
				}
			}
			__finally1:
			if (_inner_error_ != NULL) {
				_g_free0 (path);
				_gtk_icon_info_free0 (ii);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (path);
		}
		_gtk_icon_info_free0 (ii);
	}
	screenshot_add_border (pix);
	result = gdk_pixbuf_copy (pix);
	return result;
}


void gmpc_pixbuf_loader_async_set_from_file (GmpcPixbufLoaderAsync* self, const char* uri, gint size, gboolean border) {
	char* _tmp0_;
	GdkPixbuf* pb;
	GCancellable* cancel;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	if (self->priv->pcancel != NULL) {
		g_cancellable_cancel (self->priv->pcancel);
	}
	self->priv->pcancel = NULL;
	self->uri = (_tmp0_ = g_strdup (uri), _g_free0 (self->uri), _tmp0_);
	pb = pixbuf_cache_lookup_icon (size, uri);
	if (pb != NULL) {
		gmpc_pixbuf_loader_async_set_pixbuf (self, pb);
		g_signal_emit_by_name (self, "pixbuf-update", self->priv->_pixbuf);
		gmpc_pixbuf_loader_async_call_row_changed (self);
		_g_object_unref0 (pb);
		return;
	}
	cancel = g_cancellable_new ();
	self->priv->pcancel = cancel;
	gmpc_pixbuf_loader_async_load_from_file_async (self, uri, size, cancel, border, NULL, NULL);
	_g_object_unref0 (pb);
	_g_object_unref0 (cancel);
}


static void gmpc_pixbuf_loader_async_load_from_file_async_data_free (gpointer _data) {
	GmpcPixbufLoaderAsyncLoadFromFileAsyncData* data;
	data = _data;
	_g_free0 (data->uri);
	_g_object_unref0 (data->cancel);
	g_slice_free (GmpcPixbufLoaderAsyncLoadFromFileAsyncData, data);
}


static void gmpc_pixbuf_loader_async_load_from_file_async (GmpcPixbufLoaderAsync* self, const char* uri, gint size, GCancellable* cancel, gboolean border, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GmpcPixbufLoaderAsyncLoadFromFileAsyncData* _data_;
	_data_ = g_slice_new0 (GmpcPixbufLoaderAsyncLoadFromFileAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gmpc_pixbuf_loader_async_load_from_file_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gmpc_pixbuf_loader_async_load_from_file_async_data_free);
	_data_->self = self;
	_data_->uri = g_strdup (uri);
	_data_->size = size;
	_data_->cancel = _g_object_ref0 (cancel);
	_data_->border = border;
	gmpc_pixbuf_loader_async_load_from_file_async_co (_data_);
}


static void gmpc_pixbuf_loader_async_load_from_file_finish (GmpcPixbufLoaderAsync* self, GAsyncResult* _res_) {
	GmpcPixbufLoaderAsyncLoadFromFileAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void gmpc_pixbuf_loader_async_load_from_file_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GmpcPixbufLoaderAsyncLoadFromFileAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	gmpc_pixbuf_loader_async_load_from_file_async_co (data);
}


static void _lambda1_ (GdkPixbufLoader* source, gint width, gint height, Block2Data* _data2_) {
	GmpcPixbufLoaderAsync * self;
	double dsize;
	gint _tmp0_ = 0;
	gint nwidth;
	gint _tmp1_ = 0;
	gint nheight;
	self = _data2_->self;
	g_return_if_fail (source != NULL);
	dsize = (double) _data2_->size;
	if (height > width) {
		_tmp0_ = (gint) ((dsize / height) * width);
	} else {
		_tmp0_ = _data2_->size;
	}
	nwidth = _tmp0_;
	if (width > height) {
		_tmp1_ = (gint) ((dsize / width) * height);
	} else {
		_tmp1_ = _data2_->size;
	}
	nheight = _tmp1_;
	gdk_pixbuf_loader_set_size (_data2_->loader, nwidth, nheight);
}


static void __lambda1__gdk_pixbuf_loader_size_prepared (GdkPixbufLoader* _sender, gint width, gint height, gpointer self) {
	_lambda1_ (_sender, width, height, self);
}


static void _lambda2_ (GdkPixbufLoader* source, Block2Data* _data2_) {
	GmpcPixbufLoaderAsync * self;
	GdkPixbuf* apix;
	GdkPixbuf* afinal;
	self = _data2_->self;
	g_return_if_fail (source != NULL);
	apix = _g_object_ref0 (gdk_pixbuf_loader_get_pixbuf (_data2_->loader));
	afinal = gmpc_pixbuf_loader_async_modify_pixbuf (self, apix, _data2_->size, _data2_->border);
	gmpc_pixbuf_loader_async_set_pixbuf (self, afinal);
	g_signal_emit_by_name (self, "pixbuf-update", self->priv->_pixbuf);
	gmpc_pixbuf_loader_async_call_row_changed (self);
	_g_object_unref0 (apix);
	_g_object_unref0 (afinal);
}


static void __lambda2__gdk_pixbuf_loader_area_prepared (GdkPixbufLoader* _sender, gpointer self) {
	_lambda2_ (_sender, self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	++_data2_->_ref_count_;
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if ((--_data2_->_ref_count_) == 0) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->loader);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean gmpc_pixbuf_loader_async_load_from_file_async_co (GmpcPixbufLoaderAsyncLoadFromFileAsyncData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->_data2_ = g_slice_new0 (Block2Data);
			data->_data2_->_ref_count_ = 1;
			data->_data2_->self = g_object_ref (data->self);
			data->_data2_->size = data->size;
			data->_data2_->border = data->border;
			data->_data2_->_async_data_ = data;
			data->file = g_file_new_for_path (data->uri);
			data->_result_ = (gsize) 0;
			data->_data2_->loader = gdk_pixbuf_loader_new ();
			g_signal_connect_data (data->_data2_->loader, "size-prepared", (GCallback) __lambda1__gdk_pixbuf_loader_size_prepared, block2_data_ref (data->_data2_), (GClosureNotify) block2_data_unref, 0);
			g_signal_connect_data (data->_data2_->loader, "area-prepared", (GCallback) __lambda2__gdk_pixbuf_loader_area_prepared, block2_data_ref (data->_data2_), (GClosureNotify) block2_data_unref, 0);
			{
				data->_state_ = 1;
				g_file_read_async (data->file, 0, data->cancel, gmpc_pixbuf_loader_async_load_from_file_async_ready, data);
				return FALSE;
				case 1:
				data->stream = g_file_read_finish (data->file, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch2_g_error;
				}
				if (!g_cancellable_is_cancelled (data->cancel)) {
					data->_tmp0_ = data->stream != NULL;
				} else {
					data->_tmp0_ = FALSE;
				}
				if (data->_tmp0_) {
					{
						data->_tmp1_ = TRUE;
						while (TRUE) {
							if (!data->_tmp1_) {
								if (!g_cancellable_is_cancelled (data->cancel)) {
									data->_tmp2_ = data->_result_ > 0;
								} else {
									data->_tmp2_ = FALSE;
								}
								if (!data->_tmp2_) {
									break;
								}
							}
							data->_tmp1_ = FALSE;
							{
								data->_state_ = 2;
								g_input_stream_read_async ((GInputStream*) data->stream, data->data, (gsize) 1024, 0, data->cancel, gmpc_pixbuf_loader_async_load_from_file_async_ready, data);
								return FALSE;
								case 2:
								data->_tmp3_ = g_input_stream_read_finish ((GInputStream*) data->stream, data->_res_, &data->_inner_error_);
								if (data->_inner_error_ != NULL) {
									goto __catch3_g_error;
								}
								data->_result_ = (gsize) data->_tmp3_;
								gdk_pixbuf_loader_write (data->_data2_->loader, (const char*) data->data, data->_result_, &data->_inner_error_);
								if (data->_inner_error_ != NULL) {
									goto __catch3_g_error;
								}
							}
							goto __finally3;
							__catch3_g_error:
							{
								data->erro = data->_inner_error_;
								data->_inner_error_ = NULL;
								{
									g_warning ("gmpc-image-async.vala:155: Error trying to fetch image: %s", data->erro->message);
									_g_error_free0 (data->erro);
								}
							}
							__finally3:
							if (data->_inner_error_ != NULL) {
								_g_object_unref0 (data->stream);
								goto __catch2_g_error;
							}
						}
					}
				}
				_g_object_unref0 (data->stream);
			}
			goto __finally2;
			__catch2_g_error:
			{
				data->e = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
					g_warning ("gmpc-image-async.vala:160: Error trying to fetch image: %s", data->e->message);
					_g_error_free0 (data->e);
				}
			}
			__finally2:
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->file);
				block2_data_unref (data->_data2_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			{
				gdk_pixbuf_loader_close (data->_data2_->loader, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch4_g_error;
				}
			}
			goto __finally4;
			__catch4_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
					g_warning ("gmpc-image-async.vala:165: Error trying to parse image: %s", data->err->message);
					g_signal_emit_by_name (data->self, "pixbuf-update", NULL);
					_g_error_free0 (data->err);
					_g_object_unref0 (data->file);
					block2_data_unref (data->_data2_);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
					_g_error_free0 (data->err);
				}
			}
			__finally4:
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->file);
				block2_data_unref (data->_data2_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			if (g_cancellable_is_cancelled (data->cancel)) {
				g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-image-async.vala:173: Cancelled loading of image");
				g_cancellable_reset (data->cancel);
				_g_object_unref0 (data->file);
				block2_data_unref (data->_data2_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->pix = _g_object_ref0 (gdk_pixbuf_loader_get_pixbuf (data->_data2_->loader));
			data->final = pixbuf_cache_lookup_icon (data->_data2_->size, data->uri);
			if (data->final == NULL) {
				data->final = (data->_tmp4_ = gmpc_pixbuf_loader_async_modify_pixbuf (data->self, data->pix, data->_data2_->size, data->_data2_->border), _g_object_unref0 (data->final), data->_tmp4_);
				pixbuf_cache_add_icon (data->_data2_->size, data->uri, data->final);
			}
			gmpc_pixbuf_loader_async_set_pixbuf (data->self, data->final);
			g_signal_emit_by_name (data->self, "pixbuf-update", data->self->priv->_pixbuf);
			gmpc_pixbuf_loader_async_call_row_changed (data->self);
			data->self->priv->pcancel = NULL;
			data->_data2_->loader = (data->_tmp5_ = NULL, _g_object_unref0 (data->_data2_->loader), data->_tmp5_);
			_g_object_unref0 (data->file);
			_g_object_unref0 (data->pix);
			_g_object_unref0 (data->final);
			block2_data_unref (data->_data2_);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


GmpcPixbufLoaderAsync* gmpc_pixbuf_loader_async_construct (GType object_type) {
	GmpcPixbufLoaderAsync * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GmpcPixbufLoaderAsync* gmpc_pixbuf_loader_async_new (void) {
	return gmpc_pixbuf_loader_async_construct (GMPC_TYPE_PIXBUF_LOADER_ASYNC);
}


GdkPixbuf* gmpc_pixbuf_loader_async_get_pixbuf (GmpcPixbufLoaderAsync* self) {
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_pixbuf;
	return result;
}


void gmpc_pixbuf_loader_async_set_pixbuf (GmpcPixbufLoaderAsync* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_pixbuf = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_pixbuf), _tmp0_);
	g_object_notify ((GObject *) self, "pixbuf");
}


static GObject * gmpc_pixbuf_loader_async_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcPixbufLoaderAsync * self;
	parent_class = G_OBJECT_CLASS (gmpc_pixbuf_loader_async_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_PIXBUF_LOADER_ASYNC (obj);
	{
		g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-image-async.vala:55: Create the image loading\n");
	}
	return obj;
}


static void gmpc_pixbuf_loader_async_class_init (GmpcPixbufLoaderAsyncClass * klass) {
	gmpc_pixbuf_loader_async_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcPixbufLoaderAsyncPrivate));
	G_OBJECT_CLASS (klass)->get_property = gmpc_pixbuf_loader_async_get_property;
	G_OBJECT_CLASS (klass)->set_property = gmpc_pixbuf_loader_async_set_property;
	G_OBJECT_CLASS (klass)->constructor = gmpc_pixbuf_loader_async_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_pixbuf_loader_async_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GMPC_PIXBUF_LOADER_ASYNC_PIXBUF, g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("pixbuf_update", GMPC_TYPE_PIXBUF_LOADER_ASYNC, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GDK_TYPE_PIXBUF);
}


static void gmpc_pixbuf_loader_async_instance_init (GmpcPixbufLoaderAsync * self) {
	self->priv = GMPC_PIXBUF_LOADER_ASYNC_GET_PRIVATE (self);
	self->priv->pcancel = NULL;
	self->uri = NULL;
	self->priv->_pixbuf = NULL;
	self->priv->rref = NULL;
}


static void gmpc_pixbuf_loader_async_finalize (GObject* obj) {
	GmpcPixbufLoaderAsync * self;
	self = GMPC_PIXBUF_LOADER_ASYNC (obj);
	{
		g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-image-async.vala:59: Free the image loading");
		if (self->priv->pcancel != NULL) {
			g_cancellable_cancel (self->priv->pcancel);
		}
	}
	_g_free0 (self->uri);
	_g_object_unref0 (self->priv->_pixbuf);
	_gtk_tree_row_reference_free0 (self->priv->rref);
	G_OBJECT_CLASS (gmpc_pixbuf_loader_async_parent_class)->finalize (obj);
}


GType gmpc_pixbuf_loader_async_get_type (void) {
	static GType gmpc_pixbuf_loader_async_type_id = 0;
	if (gmpc_pixbuf_loader_async_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcPixbufLoaderAsyncClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_pixbuf_loader_async_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcPixbufLoaderAsync), 0, (GInstanceInitFunc) gmpc_pixbuf_loader_async_instance_init, NULL };
		gmpc_pixbuf_loader_async_type_id = g_type_register_static (G_TYPE_OBJECT, "GmpcPixbufLoaderAsync", &g_define_type_info, 0);
	}
	return gmpc_pixbuf_loader_async_type_id;
}


static void gmpc_pixbuf_loader_async_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GmpcPixbufLoaderAsync * self;
	self = GMPC_PIXBUF_LOADER_ASYNC (object);
	switch (property_id) {
		case GMPC_PIXBUF_LOADER_ASYNC_PIXBUF:
		g_value_set_object (value, gmpc_pixbuf_loader_async_get_pixbuf (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gmpc_pixbuf_loader_async_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GmpcPixbufLoaderAsync * self;
	self = GMPC_PIXBUF_LOADER_ASYNC (object);
	switch (property_id) {
		case GMPC_PIXBUF_LOADER_ASYNC_PIXBUF:
		gmpc_pixbuf_loader_async_set_pixbuf (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _lambda3_ (GmpcPixbufLoaderAsync* source, GdkPixbuf* pixbuf, GmpcMetaImageAsync* self) {
	g_return_if_fail (source != NULL);
	gtk_image_set_from_pixbuf ((GtkImage*) self, pixbuf);
}


static void __lambda3__gmpc_pixbuf_loader_async_pixbuf_update (GmpcPixbufLoaderAsync* _sender, GdkPixbuf* pixbuf, gpointer self) {
	_lambda3_ (_sender, pixbuf, self);
}


void gmpc_meta_image_async_set_from_file (GmpcMetaImageAsync* self, const char* uri, gint size, gboolean border) {
	char* _tmp0_;
	GmpcPixbufLoaderAsync* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	self->uri = (_tmp0_ = g_strdup (uri), _g_free0 (self->uri), _tmp0_);
	self->priv->loader = (_tmp1_ = gmpc_pixbuf_loader_async_new (), _g_object_unref0 (self->priv->loader), _tmp1_);
	g_signal_connect_object (self->priv->loader, "pixbuf-update", (GCallback) __lambda3__gmpc_pixbuf_loader_async_pixbuf_update, self, 0);
	gmpc_pixbuf_loader_async_set_from_file (self->priv->loader, uri, size, border);
}


void gmpc_meta_image_async_clear_now (GmpcMetaImageAsync* self) {
	GmpcPixbufLoaderAsync* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->loader = (_tmp0_ = NULL, _g_object_unref0 (self->priv->loader), _tmp0_);
	self->uri = (_tmp1_ = NULL, _g_free0 (self->uri), _tmp1_);
	gtk_image_clear ((GtkImage*) self);
}


void gmpc_meta_image_async_set_pixbuf (GmpcMetaImageAsync* self, GdkPixbuf* pb) {
	GmpcPixbufLoaderAsync* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->loader = (_tmp0_ = NULL, _g_object_unref0 (self->priv->loader), _tmp0_);
	self->uri = (_tmp1_ = NULL, _g_free0 (self->uri), _tmp1_);
	if (pb != NULL) {
		gtk_image_set_from_pixbuf ((GtkImage*) self, pb);
	} else {
		gtk_image_clear ((GtkImage*) self);
	}
}


GmpcMetaImageAsync* gmpc_meta_image_async_construct (GType object_type) {
	GmpcMetaImageAsync * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GmpcMetaImageAsync* gmpc_meta_image_async_new (void) {
	return gmpc_meta_image_async_construct (GMPC_TYPE_META_IMAGE_ASYNC);
}


static GObject * gmpc_meta_image_async_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcMetaImageAsync * self;
	parent_class = G_OBJECT_CLASS (gmpc_meta_image_async_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_META_IMAGE_ASYNC (obj);
	{
	}
	return obj;
}


static void gmpc_meta_image_async_class_init (GmpcMetaImageAsyncClass * klass) {
	gmpc_meta_image_async_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcMetaImageAsyncPrivate));
	G_OBJECT_CLASS (klass)->constructor = gmpc_meta_image_async_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_meta_image_async_finalize;
}


static void gmpc_meta_image_async_instance_init (GmpcMetaImageAsync * self) {
	self->priv = GMPC_META_IMAGE_ASYNC_GET_PRIVATE (self);
	self->priv->loader = NULL;
	self->uri = NULL;
}


static void gmpc_meta_image_async_finalize (GObject* obj) {
	GmpcMetaImageAsync * self;
	self = GMPC_META_IMAGE_ASYNC (obj);
	{
		g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-image-async.vala:203: Freeing metaimageasync\n");
	}
	_g_object_unref0 (self->priv->loader);
	_g_free0 (self->uri);
	G_OBJECT_CLASS (gmpc_meta_image_async_parent_class)->finalize (obj);
}


GType gmpc_meta_image_async_get_type (void) {
	static GType gmpc_meta_image_async_type_id = 0;
	if (gmpc_meta_image_async_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcMetaImageAsyncClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_meta_image_async_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcMetaImageAsync), 0, (GInstanceInitFunc) gmpc_meta_image_async_instance_init, NULL };
		gmpc_meta_image_async_type_id = g_type_register_static (GTK_TYPE_IMAGE, "GmpcMetaImageAsync", &g_define_type_info, 0);
	}
	return gmpc_meta_image_async_type_id;
}




