/* gmpc-nowplaying2.c generated by valac, the Vala compiler
 * generated from gmpc-nowplaying2.vala, do not modify */

/* Gnome Music Player Client Multimedia Keys plugin (gmpc-mmkeys)
 * Copyright (C) 2009 Qball Cow <qball@sarine.nl>
 * Project homepage: http://gmpc.wikia.com/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include <config.h>
#include <gmpc-plugin.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <plugin.h>
#include <config1.h>
#include <libmpd/libmpd.h>
#include <glib/gi18n-lib.h>
#include <gmpc-connection.h>
#include <libmpd/libmpdclient.h>
#include <misc.h>
#include <metadata.h>
#include <gmpc-metaimage.h>
#include <gmpc-favorites.h>
#include <pango/pango.h>
#include <gmpc-rating.h>
#include <stdio.h>
#include <gmpc-meta-text-view.h>
#include <gmpc-metadata-browser2.h>
#include <gmpc-song-links.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <main.h>


#define GMPC_PLUGIN_TYPE_MOCKUP (gmpc_plugin_mockup_get_type ())
#define GMPC_PLUGIN_MOCKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMPC_PLUGIN_TYPE_MOCKUP, GmpcPluginMockup))
#define GMPC_PLUGIN_MOCKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GMPC_PLUGIN_TYPE_MOCKUP, GmpcPluginMockupClass))
#define GMPC_PLUGIN_IS_MOCKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMPC_PLUGIN_TYPE_MOCKUP))
#define GMPC_PLUGIN_IS_MOCKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GMPC_PLUGIN_TYPE_MOCKUP))
#define GMPC_PLUGIN_MOCKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GMPC_PLUGIN_TYPE_MOCKUP, GmpcPluginMockupClass))

typedef struct _GmpcPluginMockup GmpcPluginMockup;
typedef struct _GmpcPluginMockupClass GmpcPluginMockupClass;
typedef struct _GmpcPluginMockupPrivate GmpcPluginMockupPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_tree_row_reference_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_row_reference_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _mpd_data_free0(var) ((var == NULL) ? NULL : (var = (mpd_data_free (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block1Data Block1Data;
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))

struct _GmpcPluginMockup {
	GmpcPluginBase parent_instance;
	GmpcPluginMockupPrivate * priv;
};

struct _GmpcPluginMockupClass {
	GmpcPluginBaseClass parent_class;
};

struct _GmpcPluginMockupPrivate {
	gboolean theme_colors;
	char* title_color;
	char* item_color;
	GdkColor background;
	GdkColor foreground;
	GtkLabel* bitrate_label;
	GtkTreeRowReference* np_ref;
	GtkScrolledWindow* paned;
	GtkEventBox* container;
	gboolean selected;
	char* song_checksum;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	gint j;
};

struct _Block3Data {
	int _ref_count_;
	Block1Data * _data1_;
	GmpcMetaTextView* text_view;
	gboolean text_view_queried;
	gint j;
};

struct _Block4Data {
	int _ref_count_;
	Block1Data * _data1_;
	gboolean similar_songs_queried;
	GtkAlignment* similar_songs_box;
	gint j;
};

struct _Block5Data {
	int _ref_count_;
	Block1Data * _data1_;
	gint j;
};

struct _Block6Data {
	int _ref_count_;
	Block1Data * _data1_;
	gint j;
};

struct _Block7Data {
	int _ref_count_;
	Block1Data * _data1_;
	mpd_Song* but_song;
};

struct _Block1Data {
	int _ref_count_;
	GmpcPluginMockup * self;
	mpd_Song* song;
	GtkNotebook* notebook;
};


static gpointer gmpc_plugin_mockup_parent_class = NULL;
static GmpcPluginBrowserIfaceIface* gmpc_plugin_mockup_gmpc_plugin_browser_iface_parent_iface = NULL;

#define use_transition_mb2 TRUE
#define some_unique_name_mb2 VERSION
GType gmpc_plugin_mockup_get_type (void);
#define GMPC_PLUGIN_MOCKUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_PLUGIN_TYPE_MOCKUP, GmpcPluginMockupPrivate))
enum  {
	GMPC_PLUGIN_MOCKUP_DUMMY_PROPERTY
};
static gint* gmpc_plugin_mockup_real_get_version (GmpcPluginBase* base, int* result_length1);
static const char* gmpc_plugin_mockup_real_get_name (GmpcPluginBase* base);
static void gmpc_plugin_mockup_browser_init (GmpcPluginMockup* self);
static void gmpc_plugin_mockup_real_set_enabled (GmpcPluginBase* base, gboolean state);
static void gmpc_plugin_mockup_real_save_yourself (GmpcPluginBase* base);
static void gmpc_plugin_mockup_update (GmpcPluginMockup* self);
static void gmpc_plugin_mockup_status_changed (GmpcPluginMockup* self, GmpcConnection* conn, MpdObj* server, ChangedStatusType what);
static void gmpc_plugin_mockup_real_browser_add (GmpcPluginBrowserIface* base, GtkWidget* category_tree);
static void gmpc_plugin_mockup_real_browser_selected (GmpcPluginBrowserIface* base, GtkContainer* container);
static void gmpc_plugin_mockup_real_browser_unselected (GmpcPluginBrowserIface* base, GtkContainer* container);
static void gmpc_plugin_mockup_change_color_style (GmpcPluginMockup* self, GtkWidget* bg);
static void gmpc_plugin_mockup_browser_bg_style_changed (GmpcPluginMockup* self, GtkContainer* bg, GtkStyle* style);
static void _gmpc_plugin_mockup_browser_bg_style_changed_gtk_widget_style_set (GtkScrolledWindow* _sender, GtkStyle* previous_style, gpointer self);
static void gmpc_plugin_mockup_clear (GmpcPluginMockup* self);
static void gmpc_plugin_mockup_update_not_playing (GmpcPluginMockup* self);
static void _lambda0_ (GtkButton* source, Block2Data* _data2_);
static void __lambda0__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda1_ (GtkButton* source, Block3Data* _data3_);
static void __lambda1__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void _lambda2_ (GtkButton* source, Block4Data* _data4_);
static void __lambda2__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void _lambda3_ (GtkButton* source, Block5Data* _data5_);
static void __lambda3__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void _lambda4_ (GtkButton* source, Block6Data* _data6_);
static void __lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void _lambda5_ (GtkButton* source, Block7Data* _data7_);
static void __lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void gmpc_plugin_mockup_update_playing (GmpcPluginMockup* self);
static void gmpc_plugin_mockup_select_now_playing_browser (GmpcPluginMockup* self, GtkImageMenuItem* item);
static void _gmpc_plugin_mockup_select_now_playing_browser_gtk_menu_item_activate (GtkImageMenuItem* _sender, gpointer self);
static gint gmpc_plugin_mockup_real_browser_add_go_menu (GmpcPluginBrowserIface* base, GtkMenu* menu);
GmpcPluginMockup* gmpc_plugin_mockup_new (void);
GmpcPluginMockup* gmpc_plugin_mockup_construct (GType object_type);
static void _gmpc_plugin_mockup_status_changed_gmpc_connection_status_changed (GmpcConnection* _sender, MpdObj* server, ChangedStatusType what, gpointer self);
static void _lambda6_ (MpdObj* source, gint connect, GmpcPluginMockup* self);
static void __lambda6__gmpc_connection_connection_changed (GmpcConnection* _sender, MpdObj* server, gint connect, gpointer self);
static GObject * gmpc_plugin_mockup_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gmpc_plugin_mockup_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const gint GMPC_PLUGIN_MOCKUP_version[] = {0, 0, 0};


static gint* gmpc_plugin_mockup_real_get_version (GmpcPluginBase* base, int* result_length1) {
	GmpcPluginMockup * self;
	gint* result;
	gint* _tmp0_;
	self = (GmpcPluginMockup*) base;
	result = (_tmp0_ = GMPC_PLUGIN_MOCKUP_version, *result_length1 = G_N_ELEMENTS (GMPC_PLUGIN_MOCKUP_version), _tmp0_);
	return result;
}


static const char* gmpc_plugin_mockup_real_get_name (GmpcPluginBase* base) {
	GmpcPluginMockup * self;
	const char* result;
	self = (GmpcPluginMockup*) base;
	result = "Now Playing";
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gmpc_plugin_mockup_real_set_enabled (GmpcPluginBase* base, gboolean state) {
	GmpcPluginMockup * self;
	self = (GmpcPluginMockup*) base;
	if (state) {
		if (self->priv->paned == NULL) {
			gmpc_plugin_browser_iface_browser_add ((GmpcPluginBrowserIface*) self, (GtkWidget*) playlist3_get_category_tree_view ());
			gmpc_plugin_mockup_browser_init (self);
		}
	} else {
		if (self->priv->np_ref != NULL) {
			GtkTreePath* path;
			path = gtk_tree_row_reference_get_path (self->priv->np_ref);
			if (path != NULL) {
				gint* _tmp0_;
				gint indices_size;
				gint indices_length1;
				gint* indices;
				GtkListStore* model;
				GtkTreeIter iter = {0};
				indices = (_tmp0_ = gtk_tree_path_get_indices (path), indices_length1 = -1, indices_size = indices_length1, _tmp0_);
				cfg_set_single_value_as_int (config, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), "position", indices[0]);
				model = _g_object_ref0 (GTK_LIST_STORE (gtk_tree_row_reference_get_model (self->priv->np_ref)));
				if (gtk_tree_model_get_iter ((GtkTreeModel*) model, &iter, path)) {
					gtk_list_store_remove (model, &iter);
				}
				_g_object_unref0 (model);
			}
			_gtk_tree_path_free0 (path);
		}
		if (self->priv->paned != NULL) {
			GtkScrolledWindow* _tmp1_;
			char* _tmp2_;
			gtk_object_destroy ((GtkObject*) self->priv->paned);
			self->priv->paned = (_tmp1_ = NULL, _g_object_unref0 (self->priv->paned), _tmp1_);
			self->priv->song_checksum = (_tmp2_ = NULL, _g_free0 (self->priv->song_checksum), _tmp2_);
		}
	}
	if (gmpc_plugin_base_get_name ((GmpcPluginBase*) self) != NULL) {
		cfg_set_single_value_as_int (config, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), "enabled", (gint) state);
	}
}


static void gmpc_plugin_mockup_real_save_yourself (GmpcPluginBase* base) {
	GmpcPluginMockup * self;
	self = (GmpcPluginMockup*) base;
	if (self->priv->np_ref != NULL) {
		GtkTreePath* path;
		path = gtk_tree_row_reference_get_path (self->priv->np_ref);
		if (path != NULL) {
			gint* _tmp0_;
			gint indices_size;
			gint indices_length1;
			gint* indices;
			indices = (_tmp0_ = gtk_tree_path_get_indices (path), indices_length1 = -1, indices_size = indices_length1, _tmp0_);
			cfg_set_single_value_as_int (config, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), "position", indices[0]);
		}
		_gtk_tree_path_free0 (path);
	}
}


static void gmpc_plugin_mockup_status_changed (GmpcPluginMockup* self, GmpcConnection* conn, MpdObj* server, ChangedStatusType what) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (server != NULL);
	if (!gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self)) {
		return;
	}
	if (!self->priv->selected) {
		return;
	}
	if ((what & MPD_CST_STATE) == MPD_CST_STATE) {
		gmpc_plugin_mockup_update (self);
	} else {
		if ((what & (MPD_CST_SONGID | MPD_CST_PLAYLIST)) > 0) {
			gmpc_plugin_mockup_update (self);
		}
	}
	if ((what & (MPD_CST_BITRATE | MPD_CST_AUDIOFORMAT)) > 0) {
		if (self->priv->bitrate_label != NULL) {
			gint bitrate;
			char* _tmp0_;
			g_debug ("gmpc-nowplaying2.vala:137: bitrate changed");
			bitrate = mpd_status_get_bitrate (connection);
			gtk_label_set_markup (self->priv->bitrate_label, _tmp0_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %i %s, %.1f %s, %i %s", self->priv->item_color, _ ("Format"), mpd_status_get_channels (connection), _ ("Channel"), mpd_status_get_samplerate (connection) / 1000.0, _ ("kHz"), bitrate, _ ("kbps")));
			_g_free0 (_tmp0_);
		}
	}
}


static void gmpc_plugin_mockup_real_browser_add (GmpcPluginBrowserIface* base, GtkWidget* category_tree) {
	GmpcPluginMockup * self;
	GtkTreeView* tree;
	GtkListStore* store;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeRowReference* _tmp1_;
	GtkTreePath* _tmp0_;
	self = (GmpcPluginMockup*) base;
	g_return_if_fail (category_tree != NULL);
	tree = _g_object_ref0 (GTK_TREE_VIEW (category_tree));
	store = _g_object_ref0 (GTK_LIST_STORE (gtk_tree_view_get_model (tree)));
	model = _g_object_ref0 (gtk_tree_view_get_model (tree));
	playlist3_insert_browser (&iter, cfg_get_single_value_as_int_with_default (config, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), "position", 0));
	gtk_list_store_set (store, &iter, 0, ((GmpcPluginBase*) self)->id, 1, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), 3, "media-audiofile", -1);
	self->priv->np_ref = (_tmp1_ = gtk_tree_row_reference_new (model, _tmp0_ = gtk_tree_model_get_path (model, &iter)), _gtk_tree_row_reference_free0 (self->priv->np_ref), _tmp1_);
	_gtk_tree_path_free0 (_tmp0_);
	_g_object_unref0 (tree);
	_g_object_unref0 (store);
	_g_object_unref0 (model);
}


static void gmpc_plugin_mockup_real_browser_selected (GmpcPluginBrowserIface* base, GtkContainer* container) {
	GmpcPluginMockup * self;
	self = (GmpcPluginMockup*) base;
	g_return_if_fail (container != NULL);
	self->priv->selected = TRUE;
	gmpc_plugin_mockup_browser_init (self);
	gtk_container_add (container, (GtkWidget*) self->priv->paned);
	gtk_widget_show_all ((GtkWidget*) container);
	gtk_widget_ensure_style ((GtkWidget*) container);
	if (self->priv->theme_colors) {
		char* _tmp1_;
		GdkColor _tmp0_;
		char* _tmp3_;
		GdkColor _tmp2_;
		self->priv->title_color = (_tmp1_ = gdk_color_to_string ((_tmp0_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned)->text[GTK_STATE_PRELIGHT], &_tmp0_)), _g_free0 (self->priv->title_color), _tmp1_);
		self->priv->item_color = (_tmp3_ = gdk_color_to_string ((_tmp2_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned)->text[GTK_STATE_PRELIGHT], &_tmp2_)), _g_free0 (self->priv->item_color), _tmp3_);
	}
	gmpc_plugin_mockup_update (self);
}


static void gmpc_plugin_mockup_real_browser_unselected (GmpcPluginBrowserIface* base, GtkContainer* container) {
	GmpcPluginMockup * self;
	self = (GmpcPluginMockup*) base;
	g_return_if_fail (container != NULL);
	self->priv->selected = FALSE;
	gtk_container_remove (container, (GtkWidget*) self->priv->paned);
}


static void gmpc_plugin_mockup_browser_bg_style_changed (GmpcPluginMockup* self, GtkContainer* bg, GtkStyle* style) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (bg != NULL);
	g_debug ("gmpc-nowplaying2.vala:199: Change style signal");
	if (self->priv->theme_colors) {
		char* _tmp1_;
		GdkColor _tmp0_;
		char* _tmp3_;
		GdkColor _tmp2_;
		self->priv->title_color = (_tmp1_ = gdk_color_to_string ((_tmp0_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned)->text[GTK_STATE_PRELIGHT], &_tmp0_)), _g_free0 (self->priv->title_color), _tmp1_);
		self->priv->item_color = (_tmp3_ = gdk_color_to_string ((_tmp2_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned)->text[GTK_STATE_PRELIGHT], &_tmp2_)), _g_free0 (self->priv->item_color), _tmp3_);
	}
	gmpc_plugin_mockup_change_color_style (self, (GtkWidget*) self->priv->container);
}


static void gmpc_plugin_mockup_change_color_style (GmpcPluginMockup* self, GtkWidget* bg) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bg != NULL);
	g_debug ("gmpc-nowplaying2.vala:211: change style");
	if (GTK_IS_SEPARATOR (bg)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = GTK_IS_NOTEBOOK (bg);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = GTK_IS_CHECK_BUTTON (bg);
	}
	if (_tmp0_) {
	} else {
		if (self->priv->theme_colors) {
			GdkColor _tmp2_;
			gtk_widget_modify_bg (bg, GTK_STATE_NORMAL, (_tmp2_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned)->base[GTK_STATE_NORMAL], &_tmp2_));
		} else {
			gtk_widget_modify_bg (bg, GTK_STATE_NORMAL, &self->priv->background);
			gtk_widget_modify_base (bg, GTK_STATE_NORMAL, &self->priv->background);
			gtk_widget_modify_text (bg, GTK_STATE_NORMAL, &self->priv->foreground);
			gtk_widget_modify_fg (bg, GTK_STATE_NORMAL, &self->priv->foreground);
			gtk_widget_modify_text (bg, GTK_STATE_ACTIVE, &self->priv->foreground);
			gtk_widget_modify_fg (bg, GTK_STATE_ACTIVE, &self->priv->foreground);
		}
	}
	if (GTK_IS_CONTAINER (bg)) {
		{
			GList* child_collection;
			GList* child_it;
			child_collection = gtk_container_get_children (GTK_CONTAINER (bg));
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* child;
				child = _g_object_ref0 ((GtkWidget*) child_it->data);
				{
					gmpc_plugin_mockup_change_color_style (self, child);
					_g_object_unref0 (child);
				}
			}
			_g_list_free0 (child_collection);
		}
	}
}


static void _gmpc_plugin_mockup_browser_bg_style_changed_gtk_widget_style_set (GtkScrolledWindow* _sender, GtkStyle* previous_style, gpointer self) {
	gmpc_plugin_mockup_browser_bg_style_changed (self, _sender, previous_style);
}


static void gmpc_plugin_mockup_browser_init (GmpcPluginMockup* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->paned == NULL) {
		GtkScrolledWindow* _tmp0_;
		GtkEventBox* _tmp1_;
		self->priv->paned = (_tmp0_ = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL)), _g_object_unref0 (self->priv->paned), _tmp0_);
		gtk_scrolled_window_set_policy (self->priv->paned, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_scrolled_window_set_shadow_type (self->priv->paned, GTK_SHADOW_NONE);
		self->priv->container = (_tmp1_ = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ()), _g_object_unref0 (self->priv->container), _tmp1_);
		gtk_event_box_set_visible_window (self->priv->container, TRUE);
		g_signal_connect_object ((GtkWidget*) self->priv->paned, "style-set", (GCallback) _gmpc_plugin_mockup_browser_bg_style_changed_gtk_widget_style_set, self, 0);
		gtk_scrolled_window_add_with_viewport (self->priv->paned, (GtkWidget*) self->priv->container);
		g_object_set ((GObject*) gtk_scrolled_window_get_vadjustment (self->priv->paned), "step-increment", 20.0, NULL);
		gtk_widget_show_all ((GtkWidget*) self->priv->paned);
	}
}


static void gmpc_plugin_mockup_clear (GmpcPluginMockup* self) {
	GList* list;
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	list = gtk_container_get_children ((GtkContainer*) self->priv->container);
	{
		GList* child_collection;
		GList* child_it;
		child_collection = list;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child;
			child = _g_object_ref0 ((GtkWidget*) child_it->data);
			{
				gtk_object_destroy ((GtkObject*) child);
				_g_object_unref0 (child);
			}
		}
	}
	self->priv->bitrate_label = (_tmp0_ = NULL, _g_object_unref0 (self->priv->bitrate_label), _tmp0_);
	_g_list_free0 (list);
}


static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


static void _lambda0_ (GtkButton* source, Block2Data* _data2_) {
	Block1Data* _data1_;
	GmpcPluginMockup * self;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-nowplaying2.vala:496: notebook page %i clicked", _data2_->j);
	gtk_notebook_set_current_page (_data1_->notebook, _data2_->j);
}


static void __lambda0__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda0_ (_sender, self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	++_data2_->_ref_count_;
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if ((--_data2_->_ref_count_) == 0) {
		block1_data_unref (_data2_->_data1_);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda1_ (GtkButton* source, Block3Data* _data3_) {
	Block1Data* _data1_;
	GmpcPluginMockup * self;
	_data1_ = _data3_->_data1_;
	self = _data1_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-nowplaying2.vala:522: notebook page %i clicked", _data3_->j);
	gtk_notebook_set_current_page (_data1_->notebook, _data3_->j);
	if (!_data3_->text_view_queried) {
		gmpc_meta_text_view_query_text_from_song (_data3_->text_view, _data1_->song);
		_data3_->text_view_queried = TRUE;
		gmpc_plugin_mockup_change_color_style (self, (GtkWidget*) _data3_->text_view);
	}
}


static void __lambda1__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	++_data3_->_ref_count_;
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if ((--_data3_->_ref_count_) == 0) {
		block1_data_unref (_data3_->_data1_);
		_g_object_unref0 (_data3_->text_view);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _lambda2_ (GtkButton* source, Block4Data* _data4_) {
	Block1Data* _data1_;
	GmpcPluginMockup * self;
	_data1_ = _data4_->_data1_;
	self = _data1_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-nowplaying2.vala:553: notebook page %i clicked", _data4_->j);
	gtk_notebook_set_current_page (_data1_->notebook, _data4_->j);
	if (!_data4_->similar_songs_queried) {
		GmpcWidgetSimilarSongs* similar_songs;
		similar_songs = g_object_ref_sink (gmpc_widget_similar_songs_new (_data1_->song));
		gmpc_widget_similar_songs_update (similar_songs);
		_data4_->similar_songs_queried = TRUE;
		gtk_container_add ((GtkContainer*) _data4_->similar_songs_box, (GtkWidget*) similar_songs);
		gmpc_plugin_mockup_change_color_style (self, (GtkWidget*) _data4_->similar_songs_box);
		gtk_widget_show_all ((GtkWidget*) _data4_->similar_songs_box);
		_g_object_unref0 (similar_songs);
	}
}


static void __lambda2__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda2_ (_sender, self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	++_data4_->_ref_count_;
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if ((--_data4_->_ref_count_) == 0) {
		block1_data_unref (_data4_->_data1_);
		_g_object_unref0 (_data4_->similar_songs_box);
		g_slice_free (Block4Data, _data4_);
	}
}


static void _lambda3_ (GtkButton* source, Block5Data* _data5_) {
	Block1Data* _data1_;
	GmpcPluginMockup * self;
	_data1_ = _data5_->_data1_;
	self = _data1_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-nowplaying2.vala:587: notebook page %i clicked", _data5_->j);
	gtk_notebook_set_current_page (_data1_->notebook, _data5_->j);
}


static void __lambda3__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda3_ (_sender, self);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	++_data5_->_ref_count_;
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if ((--_data5_->_ref_count_) == 0) {
		block1_data_unref (_data5_->_data1_);
		g_slice_free (Block5Data, _data5_);
	}
}


static void _lambda4_ (GtkButton* source, Block6Data* _data6_) {
	Block1Data* _data1_;
	GmpcPluginMockup * self;
	_data1_ = _data6_->_data1_;
	self = _data1_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-nowplaying2.vala:602: notebook page %i clicked", _data6_->j);
	gtk_notebook_set_current_page (_data1_->notebook, _data6_->j);
}


static void __lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	++_data6_->_ref_count_;
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if ((--_data6_->_ref_count_) == 0) {
		block1_data_unref (_data6_->_data1_);
		g_slice_free (Block6Data, _data6_);
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static void _lambda5_ (GtkButton* source, Block7Data* _data7_) {
	Block1Data* _data1_;
	GmpcPluginMockup * self;
	_data1_ = _data7_->_data1_;
	self = _data1_->self;
	g_return_if_fail (source != NULL);
	info2_fill_album_view (_data1_->song->artist, _data7_->but_song->album);
}


static void __lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda5_ (_sender, self);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	++_data7_->_ref_count_;
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if ((--_data7_->_ref_count_) == 0) {
		block1_data_unref (_data7_->_data1_);
		_mpd_freeSong0 (_data7_->but_song);
		g_slice_free (Block7Data, _data7_);
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	++_data1_->_ref_count_;
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if ((--_data1_->_ref_count_) == 0) {
		_g_object_unref0 (_data1_->self);
		_mpd_freeSong0 (_data1_->song);
		_g_object_unref0 (_data1_->notebook);
		g_slice_free (Block1Data, _data1_);
	}
}


static void gmpc_plugin_mockup_update_playing (GmpcPluginMockup* self) {
	GError * _inner_error_;
	Block1Data* _data1_;
	char* checksum;
	char* _tmp0_;
	GtkVBox* vbox;
	GtkHBox* hbox;
	GtkAlignment* ali;
	GmpcMetaImage* album_image;
	GtkAlignment* _tmp1_;
	GmpcMetaImage* artist_image;
	GtkVBox* info_vbox;
	GtkHSeparator* sep;
	GtkHBox* hboxje;
	gint i;
	GSList* group;
	gboolean _tmp25_ = FALSE;
	GtkAlignment* _tmp28_;
	GtkHBox* bottom_hbox;
	GtkVBox* metadata_vbox;
	GtkHSeparator* _tmp29_;
	gboolean _tmp30_ = FALSE;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->song = _mpd_songDup0 (mpd_playlist_get_current_song (connection));
	if (_data1_->song == NULL) {
		g_debug ("gmpc-nowplaying2.vala:277: GMPC Is playing, cannot get this");
		gmpc_plugin_mockup_update_not_playing (self);
		block1_data_unref (_data1_);
		return;
	}
	checksum = mpd_song_checksum (_data1_->song);
	if (_vala_strcmp0 (checksum, self->priv->song_checksum) == 0) {
		_g_free0 (checksum);
		block1_data_unref (_data1_);
		return;
	}
	gmpc_plugin_mockup_clear (self);
	self->priv->song_checksum = (_tmp0_ = g_strdup (checksum), _g_free0 (self->priv->song_checksum), _tmp0_);
	vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 8);
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	ali = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f));
	album_image = g_object_ref_sink (gmpc_metaimage_new_size (META_ALBUM_ART, 200));
	gmpc_metaimage_set_scale_up (album_image, TRUE);
	gmpc_metaimage_set_squared (album_image, FALSE);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) album_image);
	gmpc_metaimage_update_cover_from_song (album_image, _data1_->song);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	ali = (_tmp1_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (1.f, 0.f, 0.f, 0.f)), _g_object_unref0 (ali), _tmp1_);
	artist_image = g_object_ref_sink (gmpc_metaimage_new_size (META_ARTIST_ART, 200));
	gmpc_metaimage_set_scale_up (artist_image, TRUE);
	gmpc_metaimage_set_squared (artist_image, FALSE);
	gmpc_metaimage_update_cover_from_song (artist_image, _data1_->song);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) artist_image);
	gtk_box_pack_end ((GtkBox*) hbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	info_vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	if (_data1_->song->title != NULL) {
		GtkHBox* box;
		GmpcFavoritesButton* fav_button;
		GtkAlignment* _tmp2_;
		GtkLabel* label;
		char* _tmp3_;
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		fav_button = g_object_ref_sink (gmpc_favorites_button_new ());
		gmpc_favorites_button_set_song (fav_button, _data1_->song);
		ali = (_tmp2_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f)), _g_object_unref0 (ali), _tmp2_);
		gtk_container_add ((GtkContainer*) ali, (GtkWidget*) fav_button);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data1_->song->title));
		gtk_label_set_markup (label, _tmp3_ = g_markup_printf_escaped ("<span color='%s' size='%i' weight='bold'>%s</span>", self->priv->title_color, PANGO_SCALE * 20, _data1_->song->title));
		_g_free0 (_tmp3_);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		if (mpd_sticker_supported (connection)) {
			GmpcRating* rating_button;
			GtkAlignment* _tmp4_;
			rating_button = g_object_ref_sink (gmpc_rating_new (connection, _data1_->song));
			ali = (_tmp4_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f)), _g_object_unref0 (ali), _tmp4_);
			gtk_container_add ((GtkContainer*) ali, (GtkWidget*) rating_button);
			gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
			_g_object_unref0 (rating_button);
		}
		_g_object_unref0 (box);
		_g_object_unref0 (fav_button);
		_g_object_unref0 (label);
	} else {
		if (_data1_->song->name != NULL) {
			GtkLabel* label;
			char* _tmp5_;
			label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data1_->song->name));
			gtk_label_set_markup (label, _tmp5_ = g_markup_printf_escaped ("<span color='%s' size='%i' weight='bold'>%s</span>", self->priv->title_color, PANGO_SCALE * 20, _data1_->song->name));
			_g_free0 (_tmp5_);
			gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
			gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
			gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
			_g_object_unref0 (label);
		} else {
			if (_data1_->song->file != NULL) {
				char* filename;
				GtkLabel* label;
				char* _tmp10_;
				filename = g_path_get_basename (_data1_->song->file);
				label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data1_->song->name));
				{
					GRegex* regex;
					char* _tmp6_;
					char* _tmp7_;
					regex = g_regex_new ("\\.[0-9a-zA-Z]*$", 0, 0, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch0_g_regex_error;
						}
						goto __finally0;
					}
					_tmp6_ = g_regex_replace_literal (regex, filename, (glong) (-1), 0, "", 0, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_regex_unref0 (regex);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch0_g_regex_error;
						}
						goto __finally0;
					}
					filename = (_tmp7_ = _tmp6_, _g_free0 (filename), _tmp7_);
					_g_regex_unref0 (regex);
				}
				goto __finally0;
				__catch0_g_regex_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						fprintf (stdout, "%s", e->message);
						g_assert_not_reached ();
						_g_error_free0 (e);
					}
				}
				__finally0:
				if (_inner_error_ != NULL) {
					_g_free0 (filename);
					_g_object_unref0 (label);
					_g_free0 (checksum);
					_g_object_unref0 (vbox);
					_g_object_unref0 (hbox);
					_g_object_unref0 (ali);
					_g_object_unref0 (album_image);
					_g_object_unref0 (artist_image);
					_g_object_unref0 (info_vbox);
					block1_data_unref (_data1_);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
				{
					GRegex* regex;
					char* _tmp8_;
					char* _tmp9_;
					regex = g_regex_new ("_", 0, 0, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch1_g_regex_error;
						}
						goto __finally1;
					}
					_tmp8_ = g_regex_replace_literal (regex, filename, (glong) (-1), 0, " ", 0, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_regex_unref0 (regex);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch1_g_regex_error;
						}
						goto __finally1;
					}
					filename = (_tmp9_ = _tmp8_, _g_free0 (filename), _tmp9_);
					_g_regex_unref0 (regex);
				}
				goto __finally1;
				__catch1_g_regex_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						fprintf (stdout, "%s", e->message);
						g_assert_not_reached ();
						_g_error_free0 (e);
					}
				}
				__finally1:
				if (_inner_error_ != NULL) {
					_g_free0 (filename);
					_g_object_unref0 (label);
					_g_free0 (checksum);
					_g_object_unref0 (vbox);
					_g_object_unref0 (hbox);
					_g_object_unref0 (ali);
					_g_object_unref0 (album_image);
					_g_object_unref0 (artist_image);
					_g_object_unref0 (info_vbox);
					block1_data_unref (_data1_);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
				gtk_label_set_markup (label, _tmp10_ = g_markup_printf_escaped ("<span color='%s' size='%i' weight='bold'>%s</span>", self->priv->title_color, PANGO_SCALE * 20, filename));
				_g_free0 (_tmp10_);
				gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
				gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
				gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
				_g_free0 (filename);
				_g_object_unref0 (label);
			}
		}
	}
	if (_data1_->song->artist != NULL) {
		GtkHBox* box;
		GtkLabel* label;
		GtkImage* image;
		char* _tmp11_;
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data1_->song->artist));
		image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-artist", GTK_ICON_SIZE_BUTTON));
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		gtk_label_set_markup (label, _tmp11_ = g_markup_printf_escaped ("<span size='xx-large' weight='bold'>%s</span>", _data1_->song->artist));
		_g_free0 (_tmp11_);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (box);
		_g_object_unref0 (label);
		_g_object_unref0 (image);
	}
	if (_data1_->song->album != NULL) {
		GtkHBox* box;
		GtkLabel* label;
		GtkImage* image;
		char* _tmp12_;
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data1_->song->album));
		image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-album", GTK_ICON_SIZE_BUTTON));
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		gtk_label_set_markup (label, _tmp12_ = g_markup_printf_escaped ("<span size='x-large' weight='bold'>%s</span>", _data1_->song->album));
		_g_free0 (_tmp12_);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (box);
		_g_object_unref0 (label);
		_g_object_unref0 (image);
	}
	if (_data1_->song->genre != NULL) {
		GtkHBox* box;
		GtkLabel* label;
		GtkImage* image;
		char* _tmp13_;
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data1_->song->title));
		image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-genre", GTK_ICON_SIZE_MENU));
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		gtk_label_set_markup (label, _tmp13_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %s", self->priv->item_color, _ ("Genre"), _data1_->song->genre));
		_g_free0 (_tmp13_);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (box);
		_g_object_unref0 (label);
		_g_object_unref0 (image);
	}
	{
		GtkHBox* box;
		GtkImage* image;
		GtkLabel* _tmp14_;
		gint bitrate;
		char* _tmp15_;
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-format", GTK_ICON_SIZE_MENU));
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		self->priv->bitrate_label = (_tmp14_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data1_->song->title)), _g_object_unref0 (self->priv->bitrate_label), _tmp14_);
		gtk_label_set_ellipsize (self->priv->bitrate_label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) self->priv->bitrate_label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->bitrate_label, TRUE, TRUE, (guint) 0);
		bitrate = mpd_status_get_bitrate (connection);
		gtk_label_set_markup (self->priv->bitrate_label, _tmp15_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %i %s, %.1f %s, %i %s", self->priv->item_color, _ ("Format"), mpd_status_get_channels (connection), _ ("Channel"), mpd_status_get_samplerate (connection) / 1000.0, _ ("kHz"), bitrate, _ ("kbps")));
		_g_free0 (_tmp15_);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (box);
		_g_object_unref0 (image);
	}
	if (_data1_->song->time > 0) {
		GtkHBox* box;
		GtkImage* image;
		GtkLabel* label;
		char* _tmp17_;
		char* _tmp16_;
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-track-length", GTK_ICON_SIZE_MENU));
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (""));
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_label_set_markup (label, _tmp17_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %s", self->priv->item_color, _ ("Length"), _tmp16_ = format_time_real ((gulong) _data1_->song->time, "")));
		_g_free0 (_tmp17_);
		_g_free0 (_tmp16_);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (box);
		_g_object_unref0 (image);
		_g_object_unref0 (label);
	}
	if (_data1_->song->track != NULL) {
		GtkHBox* box;
		GtkImage* image;
		GtkLabel* label;
		char* _tmp18_;
		char* _tmp21_;
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-num-tracks", GTK_ICON_SIZE_MENU));
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (""));
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		_tmp18_ = NULL;
		if (_data1_->song->disc != NULL) {
			char* _tmp19_;
			_tmp18_ = (_tmp19_ = g_strdup_printf ("[%s]", _data1_->song->disc), _g_free0 (_tmp18_), _tmp19_);
		} else {
			char* _tmp20_;
			_tmp18_ = (_tmp20_ = g_strdup (""), _g_free0 (_tmp18_), _tmp20_);
		}
		gtk_label_set_markup (label, _tmp21_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %s %s", self->priv->item_color, _ ("Track number"), _data1_->song->track, _tmp18_));
		_g_free0 (_tmp21_);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (box);
		_g_object_unref0 (image);
		_g_object_unref0 (label);
		_g_free0 (_tmp18_);
	}
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) info_vbox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	sep = g_object_ref_sink ((GtkHSeparator*) gtk_hseparator_new ());
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 4);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) sep, FALSE, FALSE, (guint) 0);
	hboxje = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	_data1_->notebook = g_object_ref_sink ((GtkNotebook*) gtk_notebook_new ());
	gtk_notebook_set_show_border (_data1_->notebook, FALSE);
	gtk_notebook_set_show_tabs (_data1_->notebook, FALSE);
	i = 0;
	group = NULL;
	if (cfg_get_single_value_as_int_with_default (config, "MetaData", "show-lyrics", 1) == 1) {
		Block2Data* _data2_;
		GtkAlignment* alib;
		GmpcMetaTextView* text_view;
		GtkLabel* _tmp22_;
		GtkRadioButton* button;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->_data1_ = block1_data_ref (_data1_);
		alib = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.f, 0.f, 1.f, 0.f));
		text_view = g_object_ref_sink (gmpc_meta_text_view_new (META_SONG_TXT));
		text_view->force_ro = TRUE;
		gtk_text_view_set_left_margin ((GtkTextView*) text_view, 8);
		gmpc_meta_text_view_query_text_from_song (text_view, _data1_->song);
		gtk_container_add ((GtkContainer*) alib, (GtkWidget*) text_view);
		gtk_notebook_append_page (_data1_->notebook, (GtkWidget*) alib, (GtkWidget*) (_tmp22_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("Lyrics"))));
		_g_object_unref0 (_tmp22_);
		button = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_label (group, "Lyrics"));
		group = gtk_radio_button_get_group (button);
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data2_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda0__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		i++;
		gtk_widget_show ((GtkWidget*) alib);
		_g_object_unref0 (alib);
		_g_object_unref0 (text_view);
		_g_object_unref0 (button);
		block2_data_unref (_data2_);
	}
	if (cfg_get_single_value_as_int_with_default (config, "MetaData", "show-guitar-tabs", 1) == 1) {
		Block3Data* _data3_;
		GtkAlignment* alib;
		GtkLabel* _tmp23_;
		GtkRadioButton* button;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_data3_->_data1_ = block1_data_ref (_data1_);
		alib = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.f, 0.f, 1.f, 0.f));
		_data3_->text_view = g_object_ref_sink (gmpc_meta_text_view_new (META_SONG_GUITAR_TAB));
		_data3_->text_view->force_ro = TRUE;
		_data3_->text_view->use_monospace = TRUE;
		gtk_text_view_set_left_margin ((GtkTextView*) _data3_->text_view, 8);
		_data3_->text_view_queried = FALSE;
		gtk_container_add ((GtkContainer*) alib, (GtkWidget*) _data3_->text_view);
		gtk_notebook_append_page (_data1_->notebook, (GtkWidget*) alib, (GtkWidget*) (_tmp23_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Guitar Tabs")))));
		_g_object_unref0 (_tmp23_);
		button = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_label (group, _ ("Guitar Tabs")));
		group = gtk_radio_button_get_group (button);
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data3_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda1__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
		if (i == 0) {
			gmpc_meta_text_view_query_text_from_song (_data3_->text_view, _data1_->song);
			_data3_->text_view_queried = TRUE;
		}
		gtk_widget_show ((GtkWidget*) alib);
		i++;
		_g_object_unref0 (alib);
		_g_object_unref0 (button);
		block3_data_unref (_data3_);
	}
	if (cfg_get_single_value_as_int_with_default (config, "MetaData", "show-similar-songs", 1) == 1) {
		Block4Data* _data4_;
		GtkLabel* _tmp24_;
		GtkRadioButton* button;
		_data4_ = g_slice_new0 (Block4Data);
		_data4_->_ref_count_ = 1;
		_data4_->_data1_ = block1_data_ref (_data1_);
		_data4_->similar_songs_queried = FALSE;
		_data4_->similar_songs_box = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f));
		gtk_notebook_append_page (_data1_->notebook, (GtkWidget*) _data4_->similar_songs_box, (GtkWidget*) (_tmp24_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Similar Songs")))));
		_g_object_unref0 (_tmp24_);
		button = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_label (group, _ ("Similar Songs")));
		group = gtk_radio_button_get_group (button);
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data4_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda2__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
		if (i == 0) {
			GmpcWidgetSimilarSongs* similar_songs;
			similar_songs = g_object_ref_sink (gmpc_widget_similar_songs_new (_data1_->song));
			gmpc_widget_similar_songs_update (similar_songs);
			_data4_->similar_songs_queried = TRUE;
			gtk_container_add ((GtkContainer*) _data4_->similar_songs_box, (GtkWidget*) similar_songs);
			gtk_widget_show_all ((GtkWidget*) _data4_->similar_songs_box);
			_g_object_unref0 (similar_songs);
		}
		gtk_widget_show ((GtkWidget*) _data4_->similar_songs_box);
		i++;
		_g_object_unref0 (button);
		block4_data_unref (_data4_);
	}
	if (cfg_get_single_value_as_int_with_default (config, "MetaData", "show-similar-artist", 1) == 1) {
		_tmp25_ = _data1_->song->artist != NULL;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		Block5Data* _data5_;
		GmpcWidgetSimilarArtist* similar_artist;
		GtkLabel* _tmp26_;
		GtkRadioButton* button;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->_data1_ = block1_data_ref (_data1_);
		similar_artist = g_object_ref_sink (gmpc_widget_similar_artist_new (connection, _data1_->song));
		gtk_notebook_append_page (_data1_->notebook, (GtkWidget*) similar_artist, (GtkWidget*) (_tmp26_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Similar Artist")))));
		_g_object_unref0 (_tmp26_);
		button = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_label (group, _ ("Similar Artist")));
		group = gtk_radio_button_get_group (button);
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data5_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda3__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
		gtk_widget_show ((GtkWidget*) similar_artist);
		i++;
		_g_object_unref0 (similar_artist);
		_g_object_unref0 (button);
		block5_data_unref (_data5_);
	}
	if (cfg_get_single_value_as_int_with_default (config, "MetaData", "show-show-links", 1) == 1) {
		Block6Data* _data6_;
		GmpcSongLinks* song_links;
		GtkLabel* _tmp27_;
		GtkRadioButton* button;
		_data6_ = g_slice_new0 (Block6Data);
		_data6_->_ref_count_ = 1;
		_data6_->_data1_ = block1_data_ref (_data1_);
		song_links = g_object_ref_sink (gmpc_song_links_new (GMPC_SONG_LINKS_TYPE_SONG, _data1_->song));
		gtk_notebook_append_page (_data1_->notebook, (GtkWidget*) song_links, (GtkWidget*) (_tmp27_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Web Links")))));
		_g_object_unref0 (_tmp27_);
		button = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_label (group, _ ("Web Links")));
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data6_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda4__gtk_button_clicked, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
		gtk_widget_show ((GtkWidget*) song_links);
		i++;
		_g_object_unref0 (song_links);
		_g_object_unref0 (button);
		block6_data_unref (_data6_);
	}
	if (i > 0) {
		gtk_notebook_set_current_page (_data1_->notebook, 0);
	}
	ali = (_tmp28_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f)), _g_object_unref0 (ali), _tmp28_);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) hboxje);
	bottom_hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	metadata_vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	sep = (_tmp29_ = g_object_ref_sink ((GtkHSeparator*) gtk_hseparator_new ()), _g_object_unref0 (sep), _tmp29_);
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 1);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) sep, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) _data1_->notebook, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) bottom_hbox, (GtkWidget*) metadata_vbox, TRUE, TRUE, (guint) 0);
	if (_data1_->song->album != NULL) {
		_tmp30_ = _data1_->song->artist != NULL;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		GtkVSeparator* sep2;
		gint albums;
		GtkAlignment* _tmp31_;
		GtkVBox* album_hbox;
		GtkLabel* label;
		char* _tmp32_;
		MpdData* list;
		MpdData* data;
		sep2 = g_object_ref_sink ((GtkVSeparator*) gtk_vseparator_new ());
		gtk_widget_set_size_request ((GtkWidget*) sep2, -1, 4);
		gtk_box_pack_start ((GtkBox*) bottom_hbox, (GtkWidget*) sep2, FALSE, FALSE, (guint) 0);
		albums = 0;
		ali = (_tmp31_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.0f, 0.0f, 0.0f, 0.0f)), _g_object_unref0 (ali), _tmp31_);
		album_hbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
		gtk_widget_set_size_request ((GtkWidget*) album_hbox, 250, -1);
		gtk_container_add ((GtkContainer*) ali, (GtkWidget*) album_hbox);
		gtk_box_pack_start ((GtkBox*) bottom_hbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data1_->song->artist));
		gtk_widget_set_size_request ((GtkWidget*) label, 240, -1);
		gtk_label_set_markup (label, _tmp32_ = g_markup_printf_escaped ("<span size='x-large' weight='bold' color='%s'>%s</span><span size='x-large' weight='bold'> %s</span>", self->priv->item_color, _ ("Other albums by"), _data1_->song->artist));
		_g_free0 (_tmp32_);
		gtk_label_set_line_wrap_mode (label, PANGO_WRAP_WORD_CHAR);
		gtk_label_set_line_wrap (label, TRUE);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) album_hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
		mpd_database_search_field_start (connection, MPD_TAG_ITEM_ALBUM);
		mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, _data1_->song->artist);
		list = NULL;
		data = mpd_database_search_commit (connection);
		if (data != NULL) {
			const MpdData* iter;
			iter = mpd_data_get_first (data);
			{
				gboolean _tmp33_;
				_tmp33_ = TRUE;
				while (TRUE) {
					mpd_Song* _tmp34_;
					char* _tmp35_;
					char* _tmp36_;
					MpdData* ydata;
					if (!_tmp33_) {
						if (!(iter != NULL)) {
							break;
						}
					}
					_tmp33_ = FALSE;
					if (_vala_strcmp0 (iter->tag, _data1_->song->album) == 0) {
						iter = mpd_data_get_next_real (iter, FALSE);
						continue;
					}
					list = mpd_new_data_struct_append (list);
					list->type = MPD_DATA_TYPE_SONG;
					list->song = (_tmp34_ = mpd_newSong (), _mpd_freeSong0 (list->song), _tmp34_);
					list->song->artist = (_tmp35_ = g_strdup (_data1_->song->artist), _g_free0 (list->song->artist), _tmp35_);
					list->song->album = (_tmp36_ = g_strdup (iter->tag), _g_free0 (list->song->album), _tmp36_);
					mpd_database_search_field_start (connection, MPD_TAG_ITEM_DATE);
					mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, _data1_->song->artist);
					mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM, iter->tag);
					ydata = mpd_database_search_commit (connection);
					if (ydata != NULL) {
						char* _tmp37_;
						list->song->date = (_tmp37_ = g_strdup (ydata->tag), _g_free0 (list->song->date), _tmp37_);
					}
					iter = mpd_data_get_next_real (iter, FALSE);
					_mpd_data_free0 (ydata);
				}
			}
		}
		list = misc_sort_mpddata_by_album_disc_track (list);
		if (list != NULL) {
			const MpdData* iter;
			iter = mpd_data_get_first (list);
			{
				gboolean _tmp38_;
				_tmp38_ = TRUE;
				while (TRUE) {
					Block7Data* _data7_;
					GtkButton* button;
					GtkHBox* but_hbox;
					GmpcMetaImage* image;
					GtkLabel* but_label;
					char* strlabel;
					gboolean _tmp39_ = FALSE;
					char* _tmp44_;
					_data7_ = g_slice_new0 (Block7Data);
					_data7_->_ref_count_ = 1;
					_data7_->_data1_ = block1_data_ref (_data1_);
					if (!_tmp38_) {
						if (!(iter != NULL)) {
							block7_data_unref (_data7_);
							break;
						}
					}
					_tmp38_ = FALSE;
					button = g_object_ref_sink ((GtkButton*) gtk_button_new ());
					gtk_button_set_relief (button, GTK_RELIEF_NONE);
					but_hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
					gtk_container_add ((GtkContainer*) button, (GtkWidget*) but_hbox);
					image = g_object_ref_sink (gmpc_metaimage_new_size (META_ALBUM_ART, 48));
					_data7_->but_song = _mpd_songDup0 (iter->song);
					gmpc_metaimage_set_squared (image, TRUE);
					gmpc_metaimage_update_cover_from_song_delayed (image, _data7_->but_song);
					gtk_box_pack_start ((GtkBox*) but_hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
					but_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (iter->song->album));
					gtk_misc_set_alignment ((GtkMisc*) but_label, 0.0f, 0.5f);
					strlabel = g_strdup ("");
					if (iter->song->date != NULL) {
						_tmp39_ = string_get_length (iter->song->date) > 0;
					} else {
						_tmp39_ = FALSE;
					}
					if (_tmp39_) {
						char* _tmp41_;
						char* _tmp40_;
						strlabel = (_tmp41_ = g_strconcat (strlabel, _tmp40_ = g_strdup_printf ("%s: ", iter->song->date), NULL), _g_free0 (strlabel), _tmp41_);
						_g_free0 (_tmp40_);
					}
					if (iter->song->album != NULL) {
						char* _tmp42_;
						strlabel = (_tmp42_ = g_strconcat (strlabel, iter->song->album, NULL), _g_free0 (strlabel), _tmp42_);
					} else {
						char* _tmp43_;
						strlabel = (_tmp43_ = g_strconcat (strlabel, _ ("No Album"), NULL), _g_free0 (strlabel), _tmp43_);
					}
					gtk_label_set_markup (but_label, _tmp44_ = g_markup_printf_escaped ("<b>%s</b>", strlabel));
					_g_free0 (_tmp44_);
					gtk_label_set_ellipsize (but_label, PANGO_ELLIPSIZE_END);
					gtk_box_pack_start ((GtkBox*) but_hbox, (GtkWidget*) but_label, TRUE, TRUE, (guint) 0);
					gtk_box_pack_start ((GtkBox*) album_hbox, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
					g_signal_connect_data (button, "clicked", (GCallback) __lambda5__gtk_button_clicked, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
					albums++;
					iter = mpd_data_get_next_real (iter, FALSE);
					_g_object_unref0 (button);
					_g_object_unref0 (but_hbox);
					_g_object_unref0 (image);
					_g_object_unref0 (but_label);
					_g_free0 (strlabel);
					block7_data_unref (_data7_);
				}
			}
		}
		if (albums == 0) {
			gtk_object_destroy ((GtkObject*) album_hbox);
			gtk_object_destroy ((GtkObject*) sep2);
		}
		_g_object_unref0 (sep2);
		_g_object_unref0 (album_hbox);
		_g_object_unref0 (label);
		_mpd_data_free0 (list);
		_mpd_data_free0 (data);
	}
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) bottom_hbox, TRUE, TRUE, (guint) 0);
	gtk_container_add ((GtkContainer*) self->priv->container, (GtkWidget*) vbox);
	gmpc_plugin_mockup_change_color_style (self, (GtkWidget*) self->priv->container);
	gtk_widget_show_all ((GtkWidget*) self->priv->container);
	_g_free0 (checksum);
	_g_object_unref0 (vbox);
	_g_object_unref0 (hbox);
	_g_object_unref0 (ali);
	_g_object_unref0 (album_image);
	_g_object_unref0 (artist_image);
	_g_object_unref0 (info_vbox);
	_g_object_unref0 (sep);
	_g_object_unref0 (hboxje);
	_g_object_unref0 (bottom_hbox);
	_g_object_unref0 (metadata_vbox);
	block1_data_unref (_data1_);
}


static void gmpc_plugin_mockup_update_not_playing (GmpcPluginMockup* self) {
	GError * _inner_error_;
	char* _tmp0_;
	GtkIconTheme* it;
	GtkIconInfo* info;
	char* path;
	GtkImage* image;
	GtkHBox* hbox;
	GtkLabel* label;
	char* _tmp3_;
	GtkAlignment* ali;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	gmpc_plugin_mockup_clear (self);
	self->priv->song_checksum = (_tmp0_ = NULL, _g_free0 (self->priv->song_checksum), _tmp0_);
	it = _g_object_ref0 (gtk_icon_theme_get_default ());
	info = gtk_icon_theme_lookup_icon (it, "gmpc", 150, 0);
	path = g_strdup (gtk_icon_info_get_filename (info));
	image = NULL;
	if (path != NULL) {
		{
			GdkPixbuf* pb;
			GtkImage* _tmp1_;
			pb = gdk_pixbuf_new_from_file_at_scale (path, 150, 150, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
				goto __finally2;
			}
			image = (_tmp1_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_pixbuf (pb)), _g_object_unref0 (image), _tmp1_);
			_g_object_unref0 (pb);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("gmpc-nowplaying2.vala:745: Failed to load the gmpc logo: %s", e->message);
				_g_error_free0 (e);
				_g_object_unref0 (it);
				_gtk_icon_info_free0 (info);
				_g_free0 (path);
				_g_object_unref0 (image);
				return;
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (it);
			_gtk_icon_info_free0 (info);
			_g_free0 (path);
			_g_object_unref0 (image);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (image == NULL) {
		GtkImage* _tmp2_;
		image = (_tmp2_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("gmpc", GTK_ICON_SIZE_DIALOG)), _g_object_unref0 (image), _tmp2_);
	}
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Gnome Music Player Client")));
	gtk_label_set_selectable (label, TRUE);
	gtk_label_set_markup (label, _tmp3_ = g_strdup_printf ("<span size='%i' weight='bold'>%s</span>", 28 * PANGO_SCALE, _ ("Gnome Music Player Client")));
	_g_free0 (_tmp3_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	ali = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f));
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) hbox);
	gtk_container_add ((GtkContainer*) self->priv->container, (GtkWidget*) ali);
	gmpc_plugin_mockup_change_color_style (self, (GtkWidget*) self->priv->container);
	gtk_widget_show_all ((GtkWidget*) self->priv->container);
	_g_object_unref0 (it);
	_gtk_icon_info_free0 (info);
	_g_free0 (path);
	_g_object_unref0 (image);
	_g_object_unref0 (hbox);
	_g_object_unref0 (label);
	_g_object_unref0 (ali);
}


static void gmpc_plugin_mockup_update (GmpcPluginMockup* self) {
	g_return_if_fail (self != NULL);
	switch (mpd_player_get_state (connection)) {
		case MPD_STATUS_STATE_PLAY:
		case MPD_STATUS_STATE_PAUSE:
		{
			g_debug ("gmpc-nowplaying2.vala:777: Update playing");
			gmpc_plugin_mockup_update_playing (self);
			break;
		}
		default:
		{
			g_debug ("gmpc-nowplaying2.vala:781: update not playing");
			gmpc_plugin_mockup_update_not_playing (self);
			break;
		}
	}
}


static void gmpc_plugin_mockup_select_now_playing_browser (GmpcPluginMockup* self, GtkImageMenuItem* item) {
	GtkTreeView* tree;
	GtkTreeSelection* sel;
	GtkTreePath* path;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	tree = playlist3_get_category_tree_view ();
	sel = _g_object_ref0 (gtk_tree_view_get_selection (tree));
	path = gtk_tree_row_reference_get_path (self->priv->np_ref);
	if (path != NULL) {
		gtk_tree_selection_select_path (sel, path);
	}
	_g_object_unref0 (sel);
	_gtk_tree_path_free0 (path);
}


static void _gmpc_plugin_mockup_select_now_playing_browser_gtk_menu_item_activate (GtkImageMenuItem* _sender, gpointer self) {
	gmpc_plugin_mockup_select_now_playing_browser (self, _sender);
}


static gint gmpc_plugin_mockup_real_browser_add_go_menu (GmpcPluginBrowserIface* base, GtkMenu* menu) {
	GmpcPluginMockup * self;
	gint result;
	self = (GmpcPluginMockup*) base;
	g_return_val_if_fail (menu != NULL, 0);
	if (gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self)) {
		GtkImageMenuItem* item;
		GtkImage* _tmp0_;
		item = g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_ ("Now Playing")));
		gtk_image_menu_item_set_image (item, (GtkWidget*) (_tmp0_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-audiofile", GTK_ICON_SIZE_MENU))));
		_g_object_unref0 (_tmp0_);
		g_signal_connect_object ((GtkMenuItem*) item, "activate", (GCallback) _gmpc_plugin_mockup_select_now_playing_browser_gtk_menu_item_activate, self, 0);
		gtk_widget_add_accelerator ((GtkWidget*) item, "activate", gtk_menu_get_accel_group (menu), (guint) 0x069, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
		gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
		result = 1;
		_g_object_unref0 (item);
		return result;
	}
	result = 0;
	return result;
}


GmpcPluginMockup* gmpc_plugin_mockup_construct (GType object_type) {
	GmpcPluginMockup * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GmpcPluginMockup* gmpc_plugin_mockup_new (void) {
	return gmpc_plugin_mockup_construct (GMPC_PLUGIN_TYPE_MOCKUP);
}


static void _gmpc_plugin_mockup_status_changed_gmpc_connection_status_changed (GmpcConnection* _sender, MpdObj* server, ChangedStatusType what, gpointer self) {
	gmpc_plugin_mockup_status_changed (self, _sender, server, what);
}


static void _lambda6_ (MpdObj* source, gint connect, GmpcPluginMockup* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (source != NULL);
	if (connect == 0) {
		_tmp0_ = self->priv->paned != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gmpc_plugin_mockup_update_not_playing (self);
	}
}


static void __lambda6__gmpc_connection_connection_changed (GmpcConnection* _sender, MpdObj* server, gint connect, gpointer self) {
	_lambda6_ (server, connect, self);
}


static GObject * gmpc_plugin_mockup_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcPluginMockup * self;
	parent_class = G_OBJECT_CLASS (gmpc_plugin_mockup_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_PLUGIN_MOCKUP (obj);
	{
		char* background;
		char* foreground;
		((GmpcPluginBase*) self)->plugin_type = 2 | 8;
		g_signal_connect_object (gmpcconn, "status-changed", (GCallback) _gmpc_plugin_mockup_status_changed_gmpc_connection_status_changed, self, 0);
		g_signal_connect_object (gmpcconn, "connection-changed", (GCallback) __lambda6__gmpc_connection_connection_changed, self, 0);
		background = cfg_get_single_value_as_string_with_default (config, "Now Playing", "background-color", "#000");
		foreground = cfg_get_single_value_as_string_with_default (config, "Now Playing", "foreground-color", "#FFF");
		gdk_color_parse (background, &self->priv->background);
		gdk_color_parse (foreground, &self->priv->foreground);
		_g_free0 (background);
		_g_free0 (foreground);
	}
	return obj;
}


static void gmpc_plugin_mockup_class_init (GmpcPluginMockupClass * klass) {
	gmpc_plugin_mockup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcPluginMockupPrivate));
	GMPC_PLUGIN_BASE_CLASS (klass)->get_version = gmpc_plugin_mockup_real_get_version;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_name = gmpc_plugin_mockup_real_get_name;
	GMPC_PLUGIN_BASE_CLASS (klass)->set_enabled = gmpc_plugin_mockup_real_set_enabled;
	GMPC_PLUGIN_BASE_CLASS (klass)->save_yourself = gmpc_plugin_mockup_real_save_yourself;
	G_OBJECT_CLASS (klass)->constructor = gmpc_plugin_mockup_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_plugin_mockup_finalize;
}


static void gmpc_plugin_mockup_gmpc_plugin_browser_iface_interface_init (GmpcPluginBrowserIfaceIface * iface) {
	gmpc_plugin_mockup_gmpc_plugin_browser_iface_parent_iface = g_type_interface_peek_parent (iface);
	iface->browser_add = gmpc_plugin_mockup_real_browser_add;
	iface->browser_selected = gmpc_plugin_mockup_real_browser_selected;
	iface->browser_unselected = gmpc_plugin_mockup_real_browser_unselected;
	iface->browser_add_go_menu = gmpc_plugin_mockup_real_browser_add_go_menu;
}


static void gmpc_plugin_mockup_instance_init (GmpcPluginMockup * self) {
	self->priv = GMPC_PLUGIN_MOCKUP_GET_PRIVATE (self);
	self->priv->theme_colors = (gboolean) cfg_get_single_value_as_int_with_default (config, "Now Playing", "use-theme-color", 1);
	self->priv->title_color = cfg_get_single_value_as_string_with_default (config, "Now Playing", "title-color", "#4d90dd");
	self->priv->item_color = cfg_get_single_value_as_string_with_default (config, "Now Playing", "item-color", "#304ab8");
	self->priv->bitrate_label = NULL;
	self->priv->np_ref = NULL;
	self->priv->paned = NULL;
	self->priv->container = NULL;
	self->priv->selected = FALSE;
	self->priv->song_checksum = NULL;
}


static void gmpc_plugin_mockup_finalize (GObject* obj) {
	GmpcPluginMockup * self;
	self = GMPC_PLUGIN_MOCKUP (obj);
	_g_free0 (self->priv->title_color);
	_g_free0 (self->priv->item_color);
	_g_object_unref0 (self->priv->bitrate_label);
	_gtk_tree_row_reference_free0 (self->priv->np_ref);
	_g_object_unref0 (self->priv->paned);
	_g_object_unref0 (self->priv->container);
	_g_free0 (self->priv->song_checksum);
	G_OBJECT_CLASS (gmpc_plugin_mockup_parent_class)->finalize (obj);
}


GType gmpc_plugin_mockup_get_type (void) {
	static GType gmpc_plugin_mockup_type_id = 0;
	if (gmpc_plugin_mockup_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcPluginMockupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_plugin_mockup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcPluginMockup), 0, (GInstanceInitFunc) gmpc_plugin_mockup_instance_init, NULL };
		static const GInterfaceInfo gmpc_plugin_browser_iface_info = { (GInterfaceInitFunc) gmpc_plugin_mockup_gmpc_plugin_browser_iface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gmpc_plugin_mockup_type_id = g_type_register_static (GMPC_PLUGIN_TYPE_BASE, "GmpcPluginMockup", &g_define_type_info, 0);
		g_type_add_interface_static (gmpc_plugin_mockup_type_id, GMPC_PLUGIN_TYPE_BROWSER_IFACE, &gmpc_plugin_browser_iface_info);
	}
	return gmpc_plugin_mockup_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




