/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gmpc-profiles.h"

#include "gmpc-profiles-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
/* self casting macros */
#define SELF(x) GMPC_PROFILES(x)
#define SELF_CONST(x) GMPC_PROFILES_CONST(x)
#define IS_SELF(x) GMPC_IS_PROFILES(x)
#define TYPE_SELF GMPC_TYPE_PROFILES
#define SELF_CLASS(x) GMPC_PROFILES_CLASS(x)

#define SELF_GET_CLASS(x) GMPC_PROFILES_GET_CLASS(x)

/* self typedefs */
typedef GmpcProfiles Self;
typedef GmpcProfilesClass SelfClass;

/* here are local prototypes */
static void gmpc_profiles_class_init (GmpcProfilesClass * c) G_GNUC_UNUSED;
static void ___real_gmpc_profiles_changed (GmpcProfiles * self, const int changed, const int col, const char * id);
static void gmpc_profiles_init (GmpcProfiles * self) G_GNUC_UNUSED;
static void gmpc_profiles_add_default (GmpcProfiles * self) G_GNUC_UNUSED;
static void gmpc_profiles_load_from_config (GmpcProfiles * self) G_GNUC_UNUSED;
static Profile * gmpc_profiles_get_profile (GmpcProfiles * self, const gchar * id) G_GNUC_UNUSED;
static void ___real_gmpc_profiles_set_current (GmpcProfiles * self, const gchar * id);
static void ___1b_gmpc_profiles_finalize (GObject * obj) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__changed(object,func,data)	gmpc_profiles_connect__changed((object),(func),(data))
#define self_connect_after__changed(object,func,data)	gmpc_profiles_connect_after__changed((object),(func),(data))
#define self_connect_data__changed(object,func,data,destroy_data,flags)	gmpc_profiles_connect_data__changed((object),(func),(data),(destroy_data),(flags))
#define self_connect__set_current(object,func,data)	gmpc_profiles_connect__set_current((object),(func),(data))
#define self_connect_after__set_current(object,func,data)	gmpc_profiles_connect_after__set_current((object),(func),(data))
#define self_connect_data__set_current(object,func,data,destroy_data,flags)	gmpc_profiles_connect_data__set_current((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (GmpcProfiles *, gint , gint , gchar *, gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 4);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((GmpcProfiles *)data1,
		(gint ) g_value_get_int (param_values + 1),
		(gint ) g_value_get_int (param_values + 2),
		(gchar *) g_value_get_string (param_values + 3),
		data2);
}


typedef void  (*___Sig2) (GmpcProfiles *, gchar *, gpointer);

static void
___marshal_Sig2 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig2 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig2) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((GmpcProfiles *)data1,
		(gchar *) g_value_get_string (param_values + 1),
		data2);
}


enum {
	CHANGED_SIGNAL,
	SET_CURRENT_SIGNAL,
	LAST_SIGNAL
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_changed gmpc_profiles_changed
#define self_new gmpc_profiles_new
#define self_add_default gmpc_profiles_add_default
#define self_free_profile gmpc_profiles_free_profile
#define self_new_profile gmpc_profiles_new_profile
#define self_load_from_config gmpc_profiles_load_from_config
#define self_get_profile gmpc_profiles_get_profile
#define self_get_hostname gmpc_profiles_get_hostname
#define self_get_name gmpc_profiles_get_name
#define self_get_id gmpc_profiles_get_id
#define self_get_password gmpc_profiles_get_password
#define self_get_port gmpc_profiles_get_port
#define self_get_do_auth gmpc_profiles_get_do_auth
#define self_create_new_item gmpc_profiles_create_new_item
#define self_create_new_item_with_name gmpc_profiles_create_new_item_with_name
#define self_remove_item gmpc_profiles_remove_item
#define self_get_current gmpc_profiles_get_current
#define self_set_current gmpc_profiles_set_current
#define self_get_profiles_ids gmpc_profiles_get_profiles_ids
#define self_set_name gmpc_profiles_set_name
#define self_set_hostname gmpc_profiles_set_hostname
#define self_set_password gmpc_profiles_set_password
#define self_set_port gmpc_profiles_set_port
#define self_set_do_auth gmpc_profiles_set_do_auth
#define self_has_profile gmpc_profiles_has_profile
GType
gmpc_profiles_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GmpcProfilesClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gmpc_profiles_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GmpcProfiles),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gmpc_profiles_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "GmpcProfiles", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GmpcProfiles *)g_object_new(gmpc_profiles_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GmpcProfiles * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GmpcProfiles *
GET_NEW_VARG (const char *first, ...)
{
	GmpcProfiles *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GmpcProfiles *)g_object_new_valist (gmpc_profiles_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::finalize"
	GmpcProfiles *self G_GNUC_UNUSED = GMPC_PROFILES (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 500 "gmpc-profiles.gob"
	___1b_gmpc_profiles_finalize(obj_self);
#line 212 "gmpc-profiles.c"
}
#undef __GOB_FUNCTION__

static void 
gmpc_profiles_class_init (GmpcProfilesClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(GmpcProfilesPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	object_signals[CHANGED_SIGNAL] =
		g_signal_new ("changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (GmpcProfilesClass, changed),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 3,
			G_TYPE_INT,
			G_TYPE_INT,
			G_TYPE_STRING);
	if ___GOB_UNLIKELY(sizeof(const int ) != sizeof(gint ) || sizeof(const int ) != sizeof(gint ) || sizeof(const char * ) != sizeof(gchar *) || parent_class == NULL /* avoid warning */) {
		g_error("gmpc-profiles.gob line 47: Type mismatch of \"changed\" signal signature");
	}
	object_signals[SET_CURRENT_SIGNAL] =
		g_signal_new ("set_current",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (GmpcProfilesClass, set_current),
			NULL, NULL,
			___marshal_Sig2,
			G_TYPE_NONE, 1,
			G_TYPE_STRING);
	if ___GOB_UNLIKELY(sizeof(const gchar * ) != sizeof(gchar *) || parent_class == NULL /* avoid warning */) {
		g_error("gmpc-profiles.gob line 386: Type mismatch of \"set_current\" signal signature");
	}

#line 47 "gmpc-profiles.gob"
	c->changed = ___real_gmpc_profiles_changed;
#line 386 "gmpc-profiles.gob"
	c->set_current = ___real_gmpc_profiles_set_current;
#line 500 "gmpc-profiles.gob"
	g_object_class->finalize = ___finalize;
#line 259 "gmpc-profiles.c"
}
#undef __GOB_FUNCTION__
#line 93 "gmpc-profiles.gob"
static void 
gmpc_profiles_init (GmpcProfiles * self G_GNUC_UNUSED)
#line 265 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,GMPC_TYPE_PROFILES,GmpcProfilesPrivate);
#line 42 "gmpc-profiles.gob"
	self->_priv->profiles = NULL;
#line 271 "gmpc-profiles.c"
#line 43 "gmpc-profiles.gob"
	self->_priv->list = NULL;
#line 274 "gmpc-profiles.c"
#line 44 "gmpc-profiles.gob"
	self->_priv->num_profiles = 0;
#line 277 "gmpc-profiles.c"
 {
#line 94 "gmpc-profiles.gob"

    /**
     * Get Profile
     */
    gchar *url = cfg_get_single_value_as_string(config, "connection", "profile-file");
    if(!url)
    {
	  url = gmpc_get_user_path("profiles.cfg");
      cfg_set_single_value_as_string(config, "connection", "profile-file",url);
    }
    self->_priv->profiles = cfg_open(url);
    if(self->_priv->profiles == NULL)
    {
      /**
       * Show gtk error message and quit 
       */
      debug_printf(DEBUG_ERROR,"Failed to save/load Profile file:\n%s\n",url);
      abort();
    }
    g_free(url);
    self_load_from_config(self);
    if(self->_priv->num_profiles == 0)
    {
      self_add_default(self);
      self_load_from_config(self);
    }
  
#line 307 "gmpc-profiles.c"
 }
}
#undef __GOB_FUNCTION__


#line 47 "gmpc-profiles.gob"
void 
gmpc_profiles_changed (GmpcProfiles * self, const int changed, const int col, const char * id)
#line 316 "gmpc-profiles.c"
{
	GValue ___param_values[4];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 47 "gmpc-profiles.gob"
	g_return_if_fail (self != NULL);
#line 47 "gmpc-profiles.gob"
	g_return_if_fail (GMPC_IS_PROFILES (self));
#line 328 "gmpc-profiles.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_INT);
	g_value_set_int (&___param_values[1], (gint ) changed);

	___param_values[2].g_type = 0;
	g_value_init (&___param_values[2], G_TYPE_INT);
	g_value_set_int (&___param_values[2], (gint ) col);

	___param_values[3].g_type = 0;
	g_value_init (&___param_values[3], G_TYPE_STRING);
	g_value_set_static_string (&___param_values[3], (gchar *) id);

	g_signal_emitv (___param_values,
		object_signals[CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
	g_value_unset (&___param_values[2]);
	g_value_unset (&___param_values[3]);
}
#line 47 "gmpc-profiles.gob"
static void 
___real_gmpc_profiles_changed (GmpcProfiles * self G_GNUC_UNUSED, const int changed, const int col, const char * id)
#line 359 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::changed"
{
#line 50 "gmpc-profiles.gob"
	
	if(changed == PROFILE_ADDED)
    {
        gchar *message = g_markup_printf_escaped("<b>%s:</b> '%s'", _("Added profile"),self_get_name(self,id));
        playlist3_show_error_message(message, ERROR_INFO);
        q_free(message);

        debug_printf(DEBUG_INFO,"Item %s added\n", id);
    }
    else if(changed == PROFILE_REMOVED)
    {
        gchar *message = g_markup_printf_escaped("<b>%s:</b> '%s'", _("Removed profile"),self_get_name(self,id));
        playlist3_show_error_message(message, ERROR_INFO);
        q_free(message);
		debug_printf(DEBUG_INFO,"Item %s removed\n", id);
    }
	else if(changed == PROFILE_COL_CHANGED)
	{
        /* Disabled because of grand spamming charges */
    /*    
        gchar *message = g_markup_printf_escaped("<b>%s:</b> '%s'", _("Changed profile"),self_get_name(self,id));
        playlist3_show_error_message(message, ERROR_INFO);
        q_free(message);
        */
        debug_printf(DEBUG_INFO,"Item %s changed col: %i\n", id, col);
    }
  }}
#line 391 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 82 "gmpc-profiles.gob"
GmpcProfiles * 
gmpc_profiles_new (void)
#line 397 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::new"
{
#line 85 "gmpc-profiles.gob"
	
    return (GmpcProfiles *)GET_NEW;
  }}
#line 405 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

/**
 * gmpc_profiles_init:
 * 
 **/

#line 124 "gmpc-profiles.gob"
static void 
gmpc_profiles_add_default (GmpcProfiles * self)
#line 416 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::add_default"
#line 124 "gmpc-profiles.gob"
	g_return_if_fail (self != NULL);
#line 124 "gmpc-profiles.gob"
	g_return_if_fail (GMPC_IS_PROFILES (self));
#line 423 "gmpc-profiles.c"
{
#line 127 "gmpc-profiles.gob"
	
    cfg_set_single_value_as_string(config, "connection", "currentprofile", "Default"); 
    cfg_set_single_value_as_string(self->_priv->profiles, "Default", "hostname", "localhost");
    cfg_set_single_value_as_string(self->_priv->profiles, "Default", "name", "Default");
    cfg_set_single_value_as_string(self->_priv->profiles, "Default", "password","");
    cfg_set_single_value_as_int(self->_priv->profiles, "Default", "portnumber",6600);
    cfg_set_single_value_as_int(self->_priv->profiles, "Default", "useauth",FALSE);
  }}
#line 434 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 140 "gmpc-profiles.gob"
void 
gmpc_profiles_free_profile (Profile * profile)
#line 440 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::free_profile"
{
#line 143 "gmpc-profiles.gob"
	
    if(profile->name)
      g_free(profile->name);
    if(profile->id)
      g_free(profile->id);
    if(profile->hostname)
      g_free(profile->hostname);
    if(profile->password)
      g_free(profile->password); 
    g_free(profile);
  }}
#line 456 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 155 "gmpc-profiles.gob"
Profile * 
gmpc_profiles_new_profile (void)
#line 462 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::new_profile"
{
#line 158 "gmpc-profiles.gob"
	
    Profile *retv = g_malloc0(sizeof(*retv));
    /* Init values */
    retv->name      = NULL;
    retv->id        = NULL;
    retv->password  = NULL;
    retv->hostname  = NULL;
    retv->port      = 6600;
    retv->do_auth   = FALSE; 

    return retv;
  }}
#line 479 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 171 "gmpc-profiles.gob"
static void 
gmpc_profiles_load_from_config (GmpcProfiles * self)
#line 485 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::load_from_config"
#line 171 "gmpc-profiles.gob"
	g_return_if_fail (self != NULL);
#line 171 "gmpc-profiles.gob"
	g_return_if_fail (GMPC_IS_PROFILES (self));
#line 492 "gmpc-profiles.c"
{
#line 174 "gmpc-profiles.gob"
	
    conf_mult_obj *iter,*mult = cfg_get_class_list(self->_priv->profiles);
    /* free the old list */
    for(iter = mult;iter;iter = iter->next)
    {
      Profile *prof = self_new_profile();

      self->_priv->num_profiles++;
      self->_priv->list = g_realloc(self->_priv->list, (self->_priv->num_profiles+1)*sizeof(Profile *)); 
      self->_priv->list[self->_priv->num_profiles] = NULL;
      self->_priv->list[self->_priv->num_profiles-1] = prof;

      prof->id = g_strdup(iter->key);
      prof->name = cfg_get_single_value_as_string(self->_priv->profiles, prof->id, "name");
      prof->hostname = cfg_get_single_value_as_string(self->_priv->profiles, prof->id, "hostname");
      prof->password = cfg_get_single_value_as_string(self->_priv->profiles, prof->id, "password");
      prof->port = cfg_get_single_value_as_int(self->_priv->profiles, prof->id, "portnumber");
      prof->do_auth = cfg_get_single_value_as_int(self->_priv->profiles, prof->id, "useauth");
    }
    cfg_free_multiple(mult);
  }}
#line 516 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 199 "gmpc-profiles.gob"
static Profile * 
gmpc_profiles_get_profile (GmpcProfiles * self, const gchar * id)
#line 522 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::get_profile"
#line 199 "gmpc-profiles.gob"
	g_return_val_if_fail (self != NULL, (Profile * )0);
#line 199 "gmpc-profiles.gob"
	g_return_val_if_fail (GMPC_IS_PROFILES (self), (Profile * )0);
#line 199 "gmpc-profiles.gob"
	g_return_val_if_fail (id != NULL, (Profile * )0);
#line 531 "gmpc-profiles.c"
{
#line 202 "gmpc-profiles.gob"
	
    int i = 0;
    if(self->_priv->list)
    {
      for(i=0;self->_priv->list[i]; i++)
      {
        if(!strcmp(self->_priv->list[i]->id, id))
          return self->_priv->list[i];
      }
    } 
    return NULL;
  }}
#line 546 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 218 "gmpc-profiles.gob"
gchar * 
gmpc_profiles_get_hostname (GmpcProfiles * self, const gchar * id)
#line 552 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::get_hostname"
#line 218 "gmpc-profiles.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 218 "gmpc-profiles.gob"
	g_return_val_if_fail (GMPC_IS_PROFILES (self), (gchar * )0);
#line 218 "gmpc-profiles.gob"
	g_return_val_if_fail (id != NULL, (gchar * )0);
#line 561 "gmpc-profiles.c"
{
#line 221 "gmpc-profiles.gob"
	
    Profile *prof = self_get_profile(self, id);
    if(!prof)
      return NULL;
    return prof->hostname;
  }}
#line 570 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 230 "gmpc-profiles.gob"
gchar * 
gmpc_profiles_get_name (GmpcProfiles * self, const gchar * id)
#line 576 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::get_name"
#line 230 "gmpc-profiles.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 230 "gmpc-profiles.gob"
	g_return_val_if_fail (GMPC_IS_PROFILES (self), (gchar * )0);
#line 230 "gmpc-profiles.gob"
	g_return_val_if_fail (id != NULL, (gchar * )0);
#line 585 "gmpc-profiles.c"
{
#line 233 "gmpc-profiles.gob"
	
    Profile *prof = self_get_profile(self, id);
    if(!prof)
      return NULL;
    return prof->name;
  }}
#line 594 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 242 "gmpc-profiles.gob"
gchar * 
gmpc_profiles_get_id (GmpcProfiles * self, const gchar * id)
#line 600 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::get_id"
#line 242 "gmpc-profiles.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 242 "gmpc-profiles.gob"
	g_return_val_if_fail (GMPC_IS_PROFILES (self), (gchar * )0);
#line 242 "gmpc-profiles.gob"
	g_return_val_if_fail (id != NULL, (gchar * )0);
#line 609 "gmpc-profiles.c"
{
#line 245 "gmpc-profiles.gob"
	
    Profile *prof = self_get_profile(self, id);
    if(!prof)
      return NULL;
    return prof->id;
  }}
#line 618 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 254 "gmpc-profiles.gob"
gchar * 
gmpc_profiles_get_password (GmpcProfiles * self, const gchar * id)
#line 624 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::get_password"
#line 254 "gmpc-profiles.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 254 "gmpc-profiles.gob"
	g_return_val_if_fail (GMPC_IS_PROFILES (self), (gchar * )0);
#line 254 "gmpc-profiles.gob"
	g_return_val_if_fail (id != NULL, (gchar * )0);
#line 633 "gmpc-profiles.c"
{
#line 257 "gmpc-profiles.gob"
	
    Profile *prof = self_get_profile(self, id);
    if(!prof)
      return NULL;
    return prof->password;
  }}
#line 642 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 267 "gmpc-profiles.gob"
int 
gmpc_profiles_get_port (GmpcProfiles * self, const gchar * id)
#line 648 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::get_port"
#line 267 "gmpc-profiles.gob"
	g_return_val_if_fail (self != NULL, (int )0);
#line 267 "gmpc-profiles.gob"
	g_return_val_if_fail (GMPC_IS_PROFILES (self), (int )0);
#line 267 "gmpc-profiles.gob"
	g_return_val_if_fail (id != NULL, (int )0);
#line 657 "gmpc-profiles.c"
{
#line 270 "gmpc-profiles.gob"
	
    Profile *prof = self_get_profile(self, id);
    if(!prof)
      return -1;
    return prof->port;
  }}
#line 666 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 280 "gmpc-profiles.gob"
gboolean 
gmpc_profiles_get_do_auth (GmpcProfiles * self, const gchar * id)
#line 672 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::get_do_auth"
#line 280 "gmpc-profiles.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 280 "gmpc-profiles.gob"
	g_return_val_if_fail (GMPC_IS_PROFILES (self), (gboolean )0);
#line 280 "gmpc-profiles.gob"
	g_return_val_if_fail (id != NULL, (gboolean )0);
#line 681 "gmpc-profiles.c"
{
#line 283 "gmpc-profiles.gob"
	
    Profile *prof = self_get_profile(self, id);
    if(!prof)
      return FALSE;
    return prof->do_auth;
  }}
#line 690 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 293 "gmpc-profiles.gob"
gchar * 
gmpc_profiles_create_new_item (GmpcProfiles * self, const gchar * id)
#line 696 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::create_new_item"
#line 293 "gmpc-profiles.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 293 "gmpc-profiles.gob"
	g_return_val_if_fail (GMPC_IS_PROFILES (self), (gchar * )0);
#line 703 "gmpc-profiles.c"
{
#line 296 "gmpc-profiles.gob"
	
        return self_create_new_item_with_name(self, id, "New Profile");
  }}
#line 709 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 299 "gmpc-profiles.gob"
gchar * 
gmpc_profiles_create_new_item_with_name (GmpcProfiles * self, const gchar * id, const gchar * name)
#line 715 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::create_new_item_with_name"
#line 299 "gmpc-profiles.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 299 "gmpc-profiles.gob"
	g_return_val_if_fail (GMPC_IS_PROFILES (self), (gchar * )0);
#line 722 "gmpc-profiles.c"
{
#line 302 "gmpc-profiles.gob"
	
    Profile *prof = g_malloc0(sizeof(*prof));
    if(!id)
      prof->id = g_strdup_printf("%u",g_random_int());
    else
      prof->id = g_strdup(id);
    if(!name)
        prof->name = g_strdup("New Profile");
    else
        prof->name = g_strdup(name);
    prof->hostname = g_strdup("localhost");
    prof->password= g_strdup("");
    prof->port = 6600;
    prof->do_auth = 0;
   
	/* safe this to the config file */ 
    cfg_set_single_value_as_string(self->_priv->profiles, prof->id, "name", prof->name);
    cfg_set_single_value_as_string(self->_priv->profiles, prof->id, "hostname", prof->hostname);
    cfg_set_single_value_as_string(self->_priv->profiles, prof->id, "password", prof->password);
    cfg_set_single_value_as_int(self->_priv->profiles, prof->id, "portnumber", prof->port);
    cfg_set_single_value_as_int(self->_priv->profiles, prof->id, "useauth", prof->do_auth);

    self->_priv->num_profiles++;
    self->_priv->list = g_realloc(self->_priv->list, (self->_priv->num_profiles+1)*sizeof(Profile *));     
    self->_priv->list[self->_priv->num_profiles] = NULL;
    self->_priv->list[self->_priv->num_profiles-1] = prof;
    /* propagate */
    self_changed(self,PROFILE_ADDED,-1, prof->id);
    return prof->id;
  }}
#line 755 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 332 "gmpc-profiles.gob"
void 
gmpc_profiles_remove_item (GmpcProfiles * self, const gchar * id)
#line 761 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::remove_item"
#line 332 "gmpc-profiles.gob"
	g_return_if_fail (self != NULL);
#line 332 "gmpc-profiles.gob"
	g_return_if_fail (GMPC_IS_PROFILES (self));
#line 768 "gmpc-profiles.c"
{
#line 335 "gmpc-profiles.gob"
	
    int i=0;
    Profile *prof =  self_get_profile(self, id);
    if(!prof)
    {
        debug_printf(DEBUG_WARNING, "Trying to remove not-existing profile: %i\n", id);
      return;
    }
    self_changed(self,PROFILE_REMOVED,-1, id);
    for(i=0; self->_priv->list[i] && self->_priv->list[i] != prof;i++);
    if(self->_priv->list[i] == prof)
    {
      for(; self->_priv->list[i] ;i++)
      {
        self->_priv->list[i] = self->_priv->list[i+1];
      }
      self->_priv->num_profiles--;
      self->_priv->list = g_realloc(self->_priv->list, (self->_priv->num_profiles+1)*sizeof(Profile *));     
      
      cfg_remove_class(self->_priv->profiles, (char *)id);
      self_free_profile(prof);
    }

  }}
#line 795 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 363 "gmpc-profiles.gob"
gchar * 
gmpc_profiles_get_current (GmpcProfiles * self)
#line 801 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::get_current"
#line 363 "gmpc-profiles.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 363 "gmpc-profiles.gob"
	g_return_val_if_fail (GMPC_IS_PROFILES (self), (gchar * )0);
#line 808 "gmpc-profiles.c"
{
#line 366 "gmpc-profiles.gob"
	
		gchar *id = cfg_get_single_value_as_string_with_default(config, "connection", "currentprofile", "Default");
		Profile *prof = self_get_profile(self, id);
		/* if not available get the first one */
		if(!prof)
		{
			g_free(id);
            if(self->_priv->list != NULL && self->_priv->list[0])
            {
			    self_set_current(self, self->_priv->list[0]->id);
            } else {
                self_add_default(self);    
                self_load_from_config(self);
                self_changed(self, PROFILE_ADDED, -1,"Default");
            }
			id = cfg_get_single_value_as_string_with_default(config, "connection", "currentprofile", "Default");
		}
		return id; 
  }}
#line 830 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 386 "gmpc-profiles.gob"
void 
gmpc_profiles_set_current (GmpcProfiles * self, const gchar * id)
#line 836 "gmpc-profiles.c"
{
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 386 "gmpc-profiles.gob"
	g_return_if_fail (self != NULL);
#line 386 "gmpc-profiles.gob"
	g_return_if_fail (GMPC_IS_PROFILES (self));
#line 386 "gmpc-profiles.gob"
	g_return_if_fail (id != NULL);
#line 850 "gmpc-profiles.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_STRING);
	g_value_set_static_string (&___param_values[1], (gchar *) id);

	g_signal_emitv (___param_values,
		object_signals[SET_CURRENT_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 386 "gmpc-profiles.gob"
static void 
___real_gmpc_profiles_set_current (GmpcProfiles * self G_GNUC_UNUSED, const gchar * id)
#line 871 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::set_current"
{
#line 389 "gmpc-profiles.gob"
	
    Profile *prof = self_get_profile(self, id);
    if(prof)
      cfg_set_single_value_as_string(config, "connection", "currentprofile", (char *)id);
  }}
#line 881 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 394 "gmpc-profiles.gob"
GList * 
gmpc_profiles_get_profiles_ids (GmpcProfiles * self)
#line 887 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::get_profiles_ids"
#line 394 "gmpc-profiles.gob"
	g_return_val_if_fail (self != NULL, (GList * )0);
#line 394 "gmpc-profiles.gob"
	g_return_val_if_fail (GMPC_IS_PROFILES (self), (GList * )0);
#line 894 "gmpc-profiles.c"
{
#line 397 "gmpc-profiles.gob"
	
    GList *list = NULL;
    int i=0;
    for(i=0; self->_priv->list[i] ; i++)
    {
      list = g_list_append(list,g_strdup(self->_priv->list[i]->id));
    }
    return list;
  }}
#line 906 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 410 "gmpc-profiles.gob"
void 
gmpc_profiles_set_name (GmpcProfiles * self, const gchar * id, const gchar * value)
#line 912 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::set_name"
#line 410 "gmpc-profiles.gob"
	g_return_if_fail (self != NULL);
#line 410 "gmpc-profiles.gob"
	g_return_if_fail (GMPC_IS_PROFILES (self));
#line 410 "gmpc-profiles.gob"
	g_return_if_fail (id != NULL);
#line 410 "gmpc-profiles.gob"
	g_return_if_fail (value != NULL);
#line 923 "gmpc-profiles.c"
{
#line 413 "gmpc-profiles.gob"
	
    Profile *prof = self_get_profile(self, id);
    if(!prof)
      return ;                              
    if(prof->name)
      g_free(prof->name);

    prof->name = g_strdup(value);
    cfg_set_single_value_as_string(self->_priv->profiles, (char *)id, "name",prof->name);
    self_changed(self,PROFILE_COL_CHANGED, PROFILE_COL_NAME,id);
  }}
#line 937 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 425 "gmpc-profiles.gob"
void 
gmpc_profiles_set_hostname (GmpcProfiles * self, const gchar * id, const gchar * value)
#line 943 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::set_hostname"
#line 425 "gmpc-profiles.gob"
	g_return_if_fail (self != NULL);
#line 425 "gmpc-profiles.gob"
	g_return_if_fail (GMPC_IS_PROFILES (self));
#line 425 "gmpc-profiles.gob"
	g_return_if_fail (id != NULL);
#line 425 "gmpc-profiles.gob"
	g_return_if_fail (value != NULL);
#line 954 "gmpc-profiles.c"
{
#line 428 "gmpc-profiles.gob"
	
    Profile *prof = self_get_profile(self, id);
    if(!prof)
      return ;                              
    if(prof->hostname)
      g_free(prof->hostname);
    prof->hostname = g_strdup(value);
    cfg_set_single_value_as_string(self->_priv->profiles, (char *)id, "hostname",prof->hostname);
    self_changed(self,PROFILE_COL_CHANGED, PROFILE_COL_HOSTNAME,id);
  }}
#line 967 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 441 "gmpc-profiles.gob"
void 
gmpc_profiles_set_password (GmpcProfiles * self, const gchar * id, gchar * value)
#line 973 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::set_password"
#line 441 "gmpc-profiles.gob"
	g_return_if_fail (self != NULL);
#line 441 "gmpc-profiles.gob"
	g_return_if_fail (GMPC_IS_PROFILES (self));
#line 441 "gmpc-profiles.gob"
	g_return_if_fail (id != NULL);
#line 982 "gmpc-profiles.c"
{
#line 444 "gmpc-profiles.gob"
	
    Profile *prof = self_get_profile(self, id);
    if(!prof)
      return ;                              
    if(prof->password)
      g_free(prof->password);
    if(value)
      prof->password = g_strdup(value);
    else
      prof->password = g_strdup("");
    cfg_set_single_value_as_string(self->_priv->profiles, (char *)id, "password",prof->password);
    self_changed(self,PROFILE_COL_CHANGED, PROFILE_COL_PASSWORD,id);
  }}
#line 998 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 461 "gmpc-profiles.gob"
void 
gmpc_profiles_set_port (GmpcProfiles * self, const gchar * id, int value)
#line 1004 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::set_port"
#line 461 "gmpc-profiles.gob"
	g_return_if_fail (self != NULL);
#line 461 "gmpc-profiles.gob"
	g_return_if_fail (GMPC_IS_PROFILES (self));
#line 461 "gmpc-profiles.gob"
	g_return_if_fail (id != NULL);
#line 1013 "gmpc-profiles.c"
{
#line 464 "gmpc-profiles.gob"
	
    Profile *prof = self_get_profile(self, id);
    if(!prof)
      return ;                              
    prof->port = value;
    cfg_set_single_value_as_int(self->_priv->profiles, (char *)id, "portnumber",prof->port);
    self_changed(self,PROFILE_COL_CHANGED, PROFILE_COL_PORT,id);
  }}
#line 1024 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 475 "gmpc-profiles.gob"
void 
gmpc_profiles_set_do_auth (GmpcProfiles * self, const gchar * id, int value)
#line 1030 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::set_do_auth"
#line 475 "gmpc-profiles.gob"
	g_return_if_fail (self != NULL);
#line 475 "gmpc-profiles.gob"
	g_return_if_fail (GMPC_IS_PROFILES (self));
#line 475 "gmpc-profiles.gob"
	g_return_if_fail (id != NULL);
#line 1039 "gmpc-profiles.c"
{
#line 478 "gmpc-profiles.gob"
	
    Profile *prof = self_get_profile(self, id);
    if(!prof)
      return ;                              
    prof->do_auth = value;
    cfg_set_single_value_as_int(self->_priv->profiles,(char *)id, "useauth",prof->do_auth);
    self_changed(self,PROFILE_COL_CHANGED, PROFILE_COL_DO_AUTH,id);
  }}
#line 1050 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 489 "gmpc-profiles.gob"
gboolean 
gmpc_profiles_has_profile (GmpcProfiles * self, const gchar * id)
#line 1056 "gmpc-profiles.c"
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::has_profile"
#line 489 "gmpc-profiles.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 489 "gmpc-profiles.gob"
	g_return_val_if_fail (GMPC_IS_PROFILES (self), (gboolean )0);
#line 489 "gmpc-profiles.gob"
	g_return_val_if_fail (id != NULL, (gboolean )0);
#line 1065 "gmpc-profiles.c"
{
#line 492 "gmpc-profiles.gob"
	
		Profile *prof = self_get_profile(self, id);
		if(!prof)
			return FALSE;
		else 
			return TRUE;                                 	

	}}
#line 1076 "gmpc-profiles.c"
#undef __GOB_FUNCTION__

#line 500 "gmpc-profiles.gob"
static void 
___1b_gmpc_profiles_finalize (GObject * obj G_GNUC_UNUSED)
#line 1082 "gmpc-profiles.c"
#define PARENT_HANDLER(___obj) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___obj); }
{
#define __GOB_FUNCTION__ "Gmpc:Profiles::finalize"
{
#line 503 "gmpc-profiles.gob"
	
		Self *self = GMPC_PROFILES(obj);
		if(self->_priv->list)
		{
			int i = 0;
			do{
				Profile * prof = self->_priv->list[i];
				self_free_profile(prof);
				self->_priv->list[i] = NULL;
				i++;
			}while(self->_priv->list[i]);
			g_free(self->_priv->list);
			self->_priv->list = NULL;
		}
		if(self->_priv->profiles)
		{
			cfg_close(self->_priv->profiles);
			self->_priv->profiles=  NULL;
		}
		PARENT_HANDLER(obj);
	}}
#line 1111 "gmpc-profiles.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER
