#! /bin/sh
# This script is designed to be run after checkout from CVS.
# It will download a number of files into the source tree.

set -e

dir_acarchive="/usr/share/autoconf-archive"
url_acarchive="http://ac-archive.sourceforge.net/Miscellaneous"
url_gnulicenses="http://gnu.org/licenses"
url_e2fsprogs="http://kent.dl.sourceforge.net/sourceforge/e2fsprogs/e2fsprogs-1.39-WIP-1231.tar.gz"
patch_e2fsprogs="uuid/e2fsprogs-1.38+1.39-WIP-2005.12.31.diff"
dir_gettext="/usr/share/gettext"

function bumpfile () {
  if [ -L "$1" -o -e "$1" ]; then
    echo "$1: file exists, renaming to $1.v0"
    rm -f "$1.v0"
    mv "$1" "$1.v0"
  fi
}

for dir in m4 doc; do
  if [ ! -d "$dir" ]; then
    echo "$dir: directory not found, aborting"
    exit 1
  fi
done

for prog in autoreconf wget patch gnulib-tool; do
  if ! type "$prog" >/dev/null 2>&1; then
    echo "$prog: missing program, aborting"
    exit 1
  fi
done

# Make empty directories
for dir in lib build-aux; do
  if [ ! -d "$dir" ]; then
    echo mkdir "$dir"
    mkdir "$dir"
  fi
done

# Make empty files
for file in ChangeLog; do
  if [ ! -f "$file" ]; then
    echo touch "$file"
    touch "$file"
  fi
done

for m4 in ac_define_dir.m4; do
  bumpfile "m4/$m4"
  if [ -d "$dir_acarchive" -a -f "$dir_acarchive/$m4" ]; then
    echo ln -s "$dir_acarchive/$m4" "m4/"
    ln -s "$dir_acarchive/$m4" "m4/$m4"
  else
    wget --no-verbose "$url_acarchive/$m4" -O "m4/$m4"
  fi
done


for texi in fdl.texi gpl.texi; do
  bumpfile "doc/$texi"
  echo wget "$url_gnulicenses/$texi" -O "doc/$texi"
  wget --no-verbose "$url_gnulicenses/$texi" -O "doc/$texi"
done

bumpfile "e2fsprogs.tar.gz"
echo wget "$url_e2fsprogs" -O e2fsprogs.tar.gz
wget --no-verbose "$url_e2fsprogs" -O e2fsprogs.tar.gz
bumpfile e2fsprogs
echo mkdir e2fsprogs
mkdir e2fsprogs
echo tar xfz e2fsprogs.tar.gz -C e2fsprogs 
tar xfz e2fsprogs.tar.gz -C e2fsprogs
for file in ChangeLog COPYING clear.c compare.c copy.c gen_uuid.c isnull.c \
            pack.c parse.c unpack.c unparse.c uuid_time.c; do
  bumpfile "uuid/$file"
  echo cp e2fsprogs/\*/lib/uuid/$file uuid/
  cp e2fsprogs/*/lib/uuid/$file uuid/$file
done
rm -f e2fsprogs.tar.gz
rm -rf e2fsprogs
echo patch -d uuid -p1 \< "$patch_e2fsprogs"
patch -d uuid -p1 < "$patch_e2fsprogs"

# Install gettext files manually. This is necessary due to limitations
# (and/or bugs) in gettext's autopoint.
for file in ABOUT-NLS po/Makefile.in.in po/Rules-quot po/boldquot.sed \
            po/en@boldquot.header po/en@quot.header po/insert-header.sin \
            po/quot.sed po/remove-potcdate.sin; do
  bumpfile "$file"
  echo ln -s "$dir_gettext/$file" "$file"
  ln -s "$dir_gettext/$file" "$file"
done
bumpfile "build-aux/mkinstalldirs"
echo ln -s "$dir_gettext/mkinstalldirs" "build-aux/"
ln -s "$dir_gettext/mkinstalldirs" "build-aux/mkinstalldirs"

echo gnulib-tool --import --symlink
gnulib-tool --import --symlink
echo autoreconf --install --symlink
autoreconf --install --symlink

./configure --enable-maintainer-mode
