#include "includes.h"

GladeXML *guixml = NULL, *configxml = NULL, *plxml = NULL, *addxml = NULL,
	    *streamxml = NULL;

GlurpState *glurp = NULL;

int main (int argc, char *argv[])
{
  gint c;

  static struct option long_options[] = {
    { "version", 0, 0, 0 },
    { "help", 0, 0, 0 },
    { 0, 0, 0, 0 }
  };
  while (1) {
    int option_index = 0;
    c = getopt_long(argc, argv, "vh", long_options, &option_index);

    if( c == -1) {
      break;
    }

    switch(c) {
      case 0:
      case 'v':
        if( option_index == 0 ) { /* version */
	  printf("%s v%s\n", argv[0], GLURP_VERSION);
	  return 0;
	}
        break;
      case 1:
      case 'h':
        if( option_index == 1 ) { /* help */
          printf("Usage: %s [-v|--version] [-h|--help]\n", argv[0]);
	  return 0;
	}
	break;
      default:
        printf("Usage: %s [-v|--version] [-h|--help]\n", argv[0]);
	return -1;
    }
  }
	

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  glurp = malloc(sizeof(GlurpState));

  glurp->progress_dragging = FALSE;
  glurp->refresh_rate_status = 0;

  glurp->conn = NULL;
  glurp->playlist = NULL;
  glurp->playlist_version = 0;

  glurp->current_song = NULL;

  glurp->gui_playlist = NULL;
  glurp->gui_playlist_list = NULL;
  glurp->gui_stream_list = NULL;
  glurp->gui_addtree = NULL;

  glurp->playlists = NULL;
  
  glurp->statusbar_status = 0;
  glurp->conn_state = GLURP_CONN_STATE_DISCONNECTED;
  glurp->play_state = MPD_STATUS_STATE_STOP;
  glurp->prev_song_num = -1;
  glurp->scroll = 0;

  glurp->num_add_dirs = 0;

  glurp->updating_db = FALSE;

  glurp->stream_history = NULL;

  if( !config_load()) {
    debug("Couldn't read config file, aborting. Goodnight!");
    return 0;
  }

  if( !(glurp_init_gui()) ) g_error("Can't initialize GUI, exiting...\n");

  if(glurp->config->autoconnect) glurp_connect();
  else statusbar_print("Glurp v%s loaded...", GLURP_VERSION);

  gtk_main();

  config_save();

  return 0;
}
