# SIMPLE WAREHOUSE PROBLEM
#
# A warehouse can store limited units of a commodity. Given an
# initial stock, the manager has to decide when to buy or sell in
# order to minimize total cost.
#
#  References:
#              Dantzig G B, "Linear Programming and Extensions."
#              Princeton University Press, Princeton, New Jersey, 1963,
#              Chapter 3-6.

set T;
/* time in quaters */

param price{T};
/* selling price ($ per unit) */

param istock{T}, default 0;
/* initial stock (units) */

param storecost;
/* storage cost ($ per quater per unit) */

param storecap;
/* stocking capacity of warehouse (units) */

var stock{t in T} >= 0, <= storecap;
/* stock stored at time t (units) */

var sell{t in T} >= 0;
/* stock sold at time t (units) */

var buy{t in T} >= 0;
/* stock bought at time t (units) */

s.t. sb{t in T}:
   stock[t] = (if t > 1 then stock[t-1]) + buy[t] - sell[t] + istock[t];
/* stock balance at time t (units) */

minimize cost:
   sum{t in T} (price[t] * (buy[t] - sell[t]) + storecost * stock[t]);
/* total cost ($) */

data;

param : T : price istock :=
        1     10    50
        2     12     .
        3      8     .
        4      9     .  ;

param storecost := 1;

param storecap := 100;

end;
