#ifndef FILES_LIST_H
#define FILES_LIST_H

#include "gliv.h"
#include "timestamp.h"

gint get_list_length(void);
GList *get_list_head(void);
GList *get_list_end(void);
gint add_file_to_list(const gchar * filename);
void remove_from_list(GList * node);
gboolean reorder_files(gboolean shuffle);
gchar **get_sorted_files_array(void);
void init_list(gchar ** names, gint num, gboolean recursive,
               gboolean shuffle, gboolean sort);
void read_null_filenames(gboolean recursive, gboolean shuffle, gboolean sort);
void place_next(const gchar * filename);
gint insert_after_current(gchar ** names, gint nb, gboolean recursive,
                          gboolean shuffle, gboolean sort, gboolean do_stat);
gboolean confirm_remove_current(void);
void delete_selected_image(void);
timestamp_t get_list_timestamp(void);

#endif
