/* Even the GPL header does not want to be associated with "that". */

#include "gliv.h"
#include "dirty_gtk.h"

/*
 * This is the only way I found to build a menu with N items in O(N)
 * time instead of O(N²).
 */

DirtyGtkMenu *dirty_gtk_menu_new(void)
{
    DirtyGtkMenu *menu = g_new(DirtyGtkMenu, 1);

    menu->gtk_menu_shell = GTK_MENU_SHELL(gtk_menu_new());
    menu->last_child = NULL;

    return menu;
}

void dirty_gtk_menu_append(DirtyGtkMenu * menu, GtkWidget * item)
{
    GList *children = menu->gtk_menu_shell->children;

    menu->last_child = g_list_last(menu->gtk_menu_shell->children);
    menu->gtk_menu_shell->children = menu->last_child;

    gtk_menu_shell_append(menu->gtk_menu_shell, item);
    if (children != NULL)
        menu->gtk_menu_shell->children = children;
}

void dirty_gtk_menu_release(DirtyGtkMenu * menu)
{
    g_free(menu);
}
