/*
  File autogenerated by gengetopt version 2.11
  generated with the following command:
  gengetopt --input=../tools/gliv.ggo --unamed-opts --no-handle-error 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "getopt.h"

#include "cmdline.h"

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  Image Viewer using OpenGL\n"
  "\n"
  "Usage: %s [OPTIONS]... [FILES]...\n", CMDLINE_PARSER_PACKAGE);
  printf("\n");
  printf("  -h, --help                 Print help and exit\n");
  printf("  -V, --version              Print version and exit\n");
  printf("  -a, --duration=delay       Delay between each image\n");
  printf("  -b, --menu=on|off          Hide the menu bar\n");
  printf("  -C, --client=on|off        Connect to an already running gliv\n");
  printf("  -c, --alpha-checks=on|off  No alpha checks in the background\n");
  printf("  -d, --delay=hide-delay     Delay before hiding the cursor\n");
  printf("  -E, --no-center=on|off     No automatic image centering\n");
  printf("  -e, --build-menus=on|off   No images menu at startup\n");
  printf("  -F, --force-load=on|off    Try to load every file\n");
  printf("  -f, --full-screen=on|off   Start in full screen mode\n");
  printf("  -g, --glivrc=on|off        Ignore ~/.glivrc\n");
  printf("  -i, --info=on|off          Hide the status bar\n");
  printf("  -L, --loop=on|off          Make the slide show loop at the end\n");
  printf("  -l, --scale-down=on|off    Reduce the image to the window\n");
  printf("  -M, --maximize=on|off      Maximize the image to the window\n");
  printf("  -m, --make-fit=on|off      Make the image fit the window\n");
  printf("  -n, --mnemonics=on|off     No mnemonics in images menus\n");
  printf("  -o, --scrollbars=on|off    Hide the scrollbars\n");
  printf("  -P, --fps=fps              Maximum framerate\n");
  printf("  -p, --mipmap=on|off        Build Mipmaps\n");
  printf("  -R, --recursive=on|off     Process directories recursively\n");
  printf("  -S, --sort=on|off          Show images in sorted order\n");
  printf("  -s, --shuffle=on|off       Show images in random order\n");
  printf("  -T, --thumbnails=on|off    No thumbnails in images menus\n");
  printf("  -t, --dither=on|off        Enable dithering\n");
  printf("  -u, --history=length       Length of history\n");
  printf("  -W, --resize-win=on|off    No automatic window resizing\n");
  printf("  -w, --slide-show=on|off    Start the slide show immediately\n");
  printf("  -z, --zoom-pointer=on|off  Zoom centered on pointer\n");
  printf("  -0, --null=on|off          Read null-terminated filenames\n");
  printf("  -1, --one-image=on|off     Keep only one image in memory\n");
}


static char *gengetopt_strdup (const char *s);

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result;

  if (s == (char*)0)
    return (char*)0;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->duration_given = 0 ;
  args_info->menu_given = 0 ;
  args_info->client_given = 0 ;
  args_info->alpha_checks_given = 0 ;
  args_info->delay_given = 0 ;
  args_info->no_center_given = 0 ;
  args_info->build_menus_given = 0 ;
  args_info->force_load_given = 0 ;
  args_info->full_screen_given = 0 ;
  args_info->glivrc_given = 0 ;
  args_info->info_given = 0 ;
  args_info->loop_given = 0 ;
  args_info->scale_down_given = 0 ;
  args_info->maximize_given = 0 ;
  args_info->make_fit_given = 0 ;
  args_info->mnemonics_given = 0 ;
  args_info->scrollbars_given = 0 ;
  args_info->fps_given = 0 ;
  args_info->mipmap_given = 0 ;
  args_info->recursive_given = 0 ;
  args_info->sort_given = 0 ;
  args_info->shuffle_given = 0 ;
  args_info->thumbnails_given = 0 ;
  args_info->dither_given = 0 ;
  args_info->history_given = 0 ;
  args_info->resize_win_given = 0 ;
  args_info->slide_show_given = 0 ;
  args_info->zoom_pointer_given = 0 ;
  args_info->null_given = 0 ;
  args_info->one_image_given = 0 ;
#define clear_args() { \
  args_info->menu_arg = NULL; \
  args_info->client_arg = NULL; \
  args_info->alpha_checks_arg = NULL; \
  args_info->no_center_arg = NULL; \
  args_info->build_menus_arg = NULL; \
  args_info->force_load_arg = NULL; \
  args_info->full_screen_arg = NULL; \
  args_info->glivrc_arg = NULL; \
  args_info->info_arg = NULL; \
  args_info->loop_arg = NULL; \
  args_info->scale_down_arg = NULL; \
  args_info->maximize_arg = NULL; \
  args_info->make_fit_arg = NULL; \
  args_info->mnemonics_arg = NULL; \
  args_info->scrollbars_arg = NULL; \
  args_info->mipmap_arg = NULL; \
  args_info->recursive_arg = NULL; \
  args_info->sort_arg = NULL; \
  args_info->shuffle_arg = NULL; \
  args_info->thumbnails_arg = NULL; \
  args_info->dither_arg = NULL; \
  args_info->resize_win_arg = NULL; \
  args_info->slide_show_arg = NULL; \
  args_info->zoom_pointer_arg = NULL; \
  args_info->null_arg = NULL; \
  args_info->one_image_arg = NULL; \
}

  clear_args();

  args_info->inputs = NULL;
  args_info->inputs_num = 0;

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "duration",	1, NULL, 'a' },
        { "menu",	2, NULL, 'b' },
        { "client",	2, NULL, 'C' },
        { "alpha-checks",	2, NULL, 'c' },
        { "delay",	1, NULL, 'd' },
        { "no-center",	2, NULL, 'E' },
        { "build-menus",	2, NULL, 'e' },
        { "force-load",	2, NULL, 'F' },
        { "full-screen",	2, NULL, 'f' },
        { "glivrc",	2, NULL, 'g' },
        { "info",	2, NULL, 'i' },
        { "loop",	2, NULL, 'L' },
        { "scale-down",	2, NULL, 'l' },
        { "maximize",	2, NULL, 'M' },
        { "make-fit",	2, NULL, 'm' },
        { "mnemonics",	2, NULL, 'n' },
        { "scrollbars",	2, NULL, 'o' },
        { "fps",	1, NULL, 'P' },
        { "mipmap",	2, NULL, 'p' },
        { "recursive",	2, NULL, 'R' },
        { "sort",	2, NULL, 'S' },
        { "shuffle",	2, NULL, 's' },
        { "thumbnails",	2, NULL, 'T' },
        { "dither",	2, NULL, 't' },
        { "history",	1, NULL, 'u' },
        { "resize-win",	2, NULL, 'W' },
        { "slide-show",	2, NULL, 'w' },
        { "zoom-pointer",	2, NULL, 'z' },
        { "null",	2, NULL, '0' },
        { "one-image",	2, NULL, '1' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVa:b::C::c::d:E::e::F::f::g::i::L::l::M::m::n::o::P:p::R::S::s::T::t::u:W::w::z::0::1::", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'a':	/* Delay between each image.  */
          if (args_info->duration_given)
            {
              fprintf (stderr, "%s: `--duration' (`-a') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->duration_given = 1;
          args_info->duration_arg = strtol (optarg,&stop_char,0);
          break;

        case 'b':	/* Hide the menu bar.  */
          if (args_info->menu_given)
            {
              fprintf (stderr, "%s: `--menu' (`-b') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->menu_given = 1;
          args_info->menu_arg = gengetopt_strdup (optarg);
          break;

        case 'C':	/* Connect to an already running gliv.  */
          if (args_info->client_given)
            {
              fprintf (stderr, "%s: `--client' (`-C') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->client_given = 1;
          args_info->client_arg = gengetopt_strdup (optarg);
          break;

        case 'c':	/* No alpha checks in the background.  */
          if (args_info->alpha_checks_given)
            {
              fprintf (stderr, "%s: `--alpha-checks' (`-c') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->alpha_checks_given = 1;
          args_info->alpha_checks_arg = gengetopt_strdup (optarg);
          break;

        case 'd':	/* Delay before hiding the cursor.  */
          if (args_info->delay_given)
            {
              fprintf (stderr, "%s: `--delay' (`-d') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->delay_given = 1;
          args_info->delay_arg = strtol (optarg,&stop_char,0);
          break;

        case 'E':	/* No automatic image centering.  */
          if (args_info->no_center_given)
            {
              fprintf (stderr, "%s: `--no-center' (`-E') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->no_center_given = 1;
          args_info->no_center_arg = gengetopt_strdup (optarg);
          break;

        case 'e':	/* No images menu at startup.  */
          if (args_info->build_menus_given)
            {
              fprintf (stderr, "%s: `--build-menus' (`-e') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->build_menus_given = 1;
          args_info->build_menus_arg = gengetopt_strdup (optarg);
          break;

        case 'F':	/* Try to load every file.  */
          if (args_info->force_load_given)
            {
              fprintf (stderr, "%s: `--force-load' (`-F') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->force_load_given = 1;
          args_info->force_load_arg = gengetopt_strdup (optarg);
          break;

        case 'f':	/* Start in full screen mode.  */
          if (args_info->full_screen_given)
            {
              fprintf (stderr, "%s: `--full-screen' (`-f') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->full_screen_given = 1;
          args_info->full_screen_arg = gengetopt_strdup (optarg);
          break;

        case 'g':	/* Ignore ~/.glivrc.  */
          if (args_info->glivrc_given)
            {
              fprintf (stderr, "%s: `--glivrc' (`-g') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->glivrc_given = 1;
          args_info->glivrc_arg = gengetopt_strdup (optarg);
          break;

        case 'i':	/* Hide the status bar.  */
          if (args_info->info_given)
            {
              fprintf (stderr, "%s: `--info' (`-i') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->info_given = 1;
          args_info->info_arg = gengetopt_strdup (optarg);
          break;

        case 'L':	/* Make the slide show loop at the end.  */
          if (args_info->loop_given)
            {
              fprintf (stderr, "%s: `--loop' (`-L') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->loop_given = 1;
          args_info->loop_arg = gengetopt_strdup (optarg);
          break;

        case 'l':	/* Reduce the image to the window.  */
          if (args_info->scale_down_given)
            {
              fprintf (stderr, "%s: `--scale-down' (`-l') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->scale_down_given = 1;
          args_info->scale_down_arg = gengetopt_strdup (optarg);
          break;

        case 'M':	/* Maximize the image to the window.  */
          if (args_info->maximize_given)
            {
              fprintf (stderr, "%s: `--maximize' (`-M') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->maximize_given = 1;
          args_info->maximize_arg = gengetopt_strdup (optarg);
          break;

        case 'm':	/* Make the image fit the window.  */
          if (args_info->make_fit_given)
            {
              fprintf (stderr, "%s: `--make-fit' (`-m') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->make_fit_given = 1;
          args_info->make_fit_arg = gengetopt_strdup (optarg);
          break;

        case 'n':	/* No mnemonics in images menus.  */
          if (args_info->mnemonics_given)
            {
              fprintf (stderr, "%s: `--mnemonics' (`-n') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->mnemonics_given = 1;
          args_info->mnemonics_arg = gengetopt_strdup (optarg);
          break;

        case 'o':	/* Hide the scrollbars.  */
          if (args_info->scrollbars_given)
            {
              fprintf (stderr, "%s: `--scrollbars' (`-o') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->scrollbars_given = 1;
          args_info->scrollbars_arg = gengetopt_strdup (optarg);
          break;

        case 'P':	/* Maximum framerate.  */
          if (args_info->fps_given)
            {
              fprintf (stderr, "%s: `--fps' (`-P') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->fps_given = 1;
          args_info->fps_arg = strtol (optarg,&stop_char,0);
          break;

        case 'p':	/* Build Mipmaps.  */
          if (args_info->mipmap_given)
            {
              fprintf (stderr, "%s: `--mipmap' (`-p') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->mipmap_given = 1;
          args_info->mipmap_arg = gengetopt_strdup (optarg);
          break;

        case 'R':	/* Process directories recursively.  */
          if (args_info->recursive_given)
            {
              fprintf (stderr, "%s: `--recursive' (`-R') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->recursive_given = 1;
          args_info->recursive_arg = gengetopt_strdup (optarg);
          break;

        case 'S':	/* Show images in sorted order.  */
          if (args_info->sort_given)
            {
              fprintf (stderr, "%s: `--sort' (`-S') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->sort_given = 1;
          args_info->sort_arg = gengetopt_strdup (optarg);
          break;

        case 's':	/* Show images in random order.  */
          if (args_info->shuffle_given)
            {
              fprintf (stderr, "%s: `--shuffle' (`-s') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->shuffle_given = 1;
          args_info->shuffle_arg = gengetopt_strdup (optarg);
          break;

        case 'T':	/* No thumbnails in images menus.  */
          if (args_info->thumbnails_given)
            {
              fprintf (stderr, "%s: `--thumbnails' (`-T') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->thumbnails_given = 1;
          args_info->thumbnails_arg = gengetopt_strdup (optarg);
          break;

        case 't':	/* Enable dithering.  */
          if (args_info->dither_given)
            {
              fprintf (stderr, "%s: `--dither' (`-t') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->dither_given = 1;
          args_info->dither_arg = gengetopt_strdup (optarg);
          break;

        case 'u':	/* Length of history.  */
          if (args_info->history_given)
            {
              fprintf (stderr, "%s: `--history' (`-u') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->history_given = 1;
          args_info->history_arg = strtol (optarg,&stop_char,0);
          break;

        case 'W':	/* No automatic window resizing.  */
          if (args_info->resize_win_given)
            {
              fprintf (stderr, "%s: `--resize-win' (`-W') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->resize_win_given = 1;
          args_info->resize_win_arg = gengetopt_strdup (optarg);
          break;

        case 'w':	/* Start the slide show immediately.  */
          if (args_info->slide_show_given)
            {
              fprintf (stderr, "%s: `--slide-show' (`-w') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->slide_show_given = 1;
          args_info->slide_show_arg = gengetopt_strdup (optarg);
          break;

        case 'z':	/* Zoom centered on pointer.  */
          if (args_info->zoom_pointer_given)
            {
              fprintf (stderr, "%s: `--zoom-pointer' (`-z') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->zoom_pointer_given = 1;
          args_info->zoom_pointer_arg = gengetopt_strdup (optarg);
          break;

        case '0':	/* Read null-terminated filenames.  */
          if (args_info->null_given)
            {
              fprintf (stderr, "%s: `--null' (`-0') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->null_given = 1;
          args_info->null_arg = gengetopt_strdup (optarg);
          break;

        case '1':	/* Keep only one image in memory.  */
          if (args_info->one_image_given)
            {
              fprintf (stderr, "%s: `--one-image' (`-1') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->one_image_given = 1;
          args_info->one_image_arg = gengetopt_strdup (optarg);
          break;


        case 0:	/* Long option with no short option */

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          return (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", CMDLINE_PARSER_PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */


  if ( missing_required_options )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
  
      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ; 
    }
  
  return 0;
}
