
import OpenGL.GLUT as glut

glut.glutInit()

from glitch.camera import Camera

class GLUTCamera(Camera):
    def __init__(self, title="glitch", fullscreen=False, **kw):
        Camera.__init__(self, **kw)
        self.window = glut.glutCreateWindow(title)
        self.width = 0
        self.height = 0

        if fullscreen:
            glut.glutFullScreen()

        glut.glutDisplayFunc(lambda: self.render(None))
        glut.glutReshapeFunc(self._reshape)

    def _reshape(self, width, height):
        self.width = width
        self.height = height
        self.refresh()

    def render(self, parent_ctx):
        self.context['w'] = self.width
        self.context['h'] = self.height
        Camera.render(self, parent_ctx)
        glut.glutSwapBuffers()

    def refresh(self):
        glut.glutSetWindow(self.window)
        glut.glutPostRedisplay()

    def run(self):
        glut.glutMainLoop()

