/*  Glimmer - menus.h
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MENUS_H
#define MENUS_H

#ifdef __cplusplus
extern "C" {
#endif

#include "declarations.h"

void make_menus(void);

void setup_recent_files_list(gint max_files);
void build_recent_files_menu(GList *file_strings);
void recent_files_callback(GtkWidget *widget, gpointer data);
void add_file_to_recent_list(gchar *filename);
void kill_old_recent_menu(void);

extern GtkWidget *filemenu;
extern GtkWidget *recentmenu;
extern GtkWidget *editmenu;
extern GtkWidget *searchmenu;
extern GtkWidget *insertmenu;
extern GtkWidget *insertmenutitle;
extern GtkWidget *buildmenu;
extern GtkWidget *buildmenutitle;
extern GtkWidget *docsmenu;
#ifdef WITH_PYTHON
extern GtkWidget *scriptsmenu;
#endif
extern GtkWidget *viewmenu;
extern GtkWidget *settingsmenu;
extern GtkWidget *windowmenu;
extern GtkWidget *helpmenu;
extern GtkWidget *file_menu_new;
extern GtkWidget *file_menu_open;
extern GtkWidget *file_menu_revert;
extern GtkWidget *file_menu_save;
extern GtkWidget *file_menu_saveas;
extern GtkWidget *file_menu_save_all;
extern GtkWidget *file_menu_close;
extern GtkWidget *file_menu_close_all;
extern GtkWidget *file_menu_print;
extern GtkWidget *file_menu_print_preview;
extern GtkWidget *edit_menu_undo;
extern GtkWidget *edit_menu_redo;
extern GtkWidget *search_menu_match;
extern GtkWidget *search_menu_select;
extern GtkWidget *build_menu_compile;
extern GtkWidget *build_menu_kill_compile;
extern GtkWidget *build_menu_debug;
extern GtkWidget *build_menu_kill_debug;
extern GtkWidget *build_menu_execute;
extern GtkWidget *build_menu_kill_exec;
extern GtkWidget *view_file;
extern GtkWidget *view_edit;
extern GtkWidget *view_build;
extern GtkWidget *view_highlight;
extern GtkWidget *view_find;
extern GtkWidget *view_line;
#ifdef WITH_PYTHON
extern GtkWidget *view_custom;
extern GtkWidget *view_command;
#endif
extern GtkWidget *view_status;
extern GtkWidget *windows_menu_prev;
extern GtkWidget *windows_menu_next;
extern GtkWidget *windows_menu_moveprev;
extern GtkWidget *windows_menu_movenext;
#ifdef WITH_PYTHON
extern GtkWidget *windows_paned_left;
extern GtkWidget *windows_paned_right;
extern GtkWidget *windows_focus_paned;
#endif
extern GtkWidget *windows_focus_file;
extern GtkWidget *edit_popup_menu;

#ifdef __cplusplus
}
#endif

#endif
