/* gLife - An Artificial Life implementation using GNOME
 * 
 * Copyright (C) 1999 Ali Abdin <aliabdin@aucegypt.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#define height 376
#define width 376
#define INTERVAL 15
/* Use the first rowstride for aligned data - use second for debugging */
#define ROWSTRIDE ((width * 3 + 3) & -4)
/* #define ROWSTRIDE (3 * width) */

/* macros and defines for radius size of terrain */
#define FOOD1 250.0
#define FOOD2 200.0
#define FOOD3 150.0
#define FOOD4 100.0
#define FOOD5 50.0
#define FOOD6 10.0
#define RADSIZE(x) ((x>=FOOD1) ? 6.75 : (x>=FOOD2 ? 6.25 : (x>=FOOD3 ? 5.75 : (x>=FOOD4 ? 5.25 : (x>=FOOD5 ? 4.75 : (x>=FOOD6 ? 4.25 : 3.75))))))

guchar drawbuf[height * ROWSTRIDE];

extern void render (void);
extern gboolean on_darea_expose (GtkWidget *widget,
				 GdkEventExpose *event,
				 gpointer user_data);
