/* gLife - An Artificial Life implementation using GNOME
 *
 * Copyright (C) 1999 Ali Abdin <aliabdin@aucegypt.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#define MAXCOL 24
#define MAXROW 24


typedef struct animal_t AnimalType;
struct animal_t {
		gchar sex;
		gint age;
		guint vision;
		guint metafood;
		guint speed;
		guint storefood;

		guint posx;
		guint posy;

		guint maxage;
};

typedef struct {
	gint foodamt;
	gint foodrep;

	gboolean occupied;
	AnimalType *anim;
} TerrainType;

extern GList *animal;
extern TerrainType terrain[MAXCOL+1][MAXROW+1];
extern void terrain_setup();
extern void animal_setup();
extern void add_animal (gchar, gint, guint, guint, guint, guint, guint, gint, gint);
extern void del_animal (gint, gint);
extern AnimalType *animal_at (gint, gint);
extern void erase_animals ();
extern void init_terrain_data();
