/*
  Glaurung, a UCI chess playing engine.
  Copyright (C) 2004-2007 Tord Romstad

  Glaurung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  Glaurung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#if !defined(PLY_H_INCLUDED)
#define PLY_H_INCLUDED

////
//// Types
////

enum Ply {
  PLY_MIN = 0,
  PLY_MAX = 100,
  PLY_MAX_PLUS_2 = 102  // Necessary because some compilers apparently don't
                        // accept PLY_MAX+2 as an array size.
};


////
//// Inline functions
////

inline Ply operator+ (Ply p, int i) { return Ply(int(p) + i); }
inline void operator++ (Ply& p, int) { p = Ply(int(p) + 1); }
inline Ply operator- (Ply p, int i) { return Ply(int(p) - i); }
inline void operator-- (Ply& p, int) { p = Ply(int(p) - 1); }

#endif // !defined(PLY_H_INCLUDED)
