// $Id: image.cc,v 1.31 2003/04/23 12:34:41 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "misc.hh"
#include <fstream>

static const UniqueValue::value_t v_Image=CxxFile::element_types.get();
static const UniqueValue::value_t v_FuncDecl=CxxFile::element_types.get();

class Gtk_Image : public Gtk_Misc
{public:
	typedef Gtk_Misc Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Image();
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const;
	virtual void GCInclude(const Widget &w,CxxFile &f) const;
	virtual bool CantMemberConstruct(const Widget &w) const
	{  return true; } // huh? then a delete?
	virtual void CreatePointer(const Widget &w,CxxFile &f) const;
	virtual void ApplyPreferences(Tag &t) const;
private:
	void EmbedImage(CxxFile &f,const std::string &pixbuf) const;
};

static Gtk_Image Gtk_Image;

const std::string Gtk_Image::TypeName(const Widget &w) const
{  return GtkPrefix()+"Image";
}

const std::string Gtk_Image::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"image.h";
}

Gtk_Image::Gtk_Image()
{  Writer["GtkImage"]=this;
}

void Gtk_Image::GCInclude(const Widget &w,CxxFile &f) const
{  Parent::GCInclude(w,f);
   const std::string pixbuf=w.getProperty("pixbuf");
   if (pixbuf.empty()) return;
   if (GTKMM1) f.Include(Configuration.GtkmmIncludePath()+"imageloader.h");
   if (!Configuration.image_provider.empty())
   {  if (!f.ElementAlreadyThere(CxxFile::element_t(v_FuncDecl,Configuration.image_provider)))
      {  f.Declaration() << "extern Glib::RefPtr<Gdk::Pixbuf> "
      		<< Configuration.image_provider << "(const std::string &name)";
      	 f.AddElement(CxxFile::element_t(v_FuncDecl,Configuration.image_provider));
      }
   }
   else if (Configuration.embed_images)
   {  if (!xpmname(pixbuf).empty())
         f.Include(Configuration.CString(Configuration.pixmap_dir_relative_to_src+"/"+pixbuf),true);
      else if (GTKMM2)
      {  f.Include("gdkmm/pixbufloader.h");
         if (!f.ElementAlreadyThere(CxxFile::element_t(v_Image,pixbuf)))
         {  EmbedImage(f,pixbuf);
            f.AddElement(CxxFile::element_t(v_Image,pixbuf));
         }
      }
   }      
}

// Glib::RefPtr<Pixmap> (Glib::RefPtr<Colormap>&,Glib::RefPtr<Bitmap>& mask,data)
// Pixmap: Gdk::Window,

// Variants: Pixmap/Image,Bitmap (image+mask)
// : Pixbuf
// : ustring (file)
void Gtk_Image::ConstructionArgs(Widget const &w, CxxFile &f) const
{  std::string pixbuf=w.getProperty("pixbuf");
   std::string xpm_ident=xpmname(pixbuf);
   std::string stock=w.getProperty("stock");
   if (GTKMM2)
   {  if (!stock.empty())
      {  // perhaps ... we should transform to IDs during translation 
      	 // if possible to save running time
         f.FunctionArg() << "Gtk::StockID(" << 
         	Configuration.CString_WithQuotes(stock) << ')';
         f.FunctionArg() << "Gtk::IconSize(" 
         	<< w.getIntProperty("icon_size") << ')';
      }
      else if (!Configuration.image_provider.empty())
      {  f.FunctionArg() << Configuration.image_provider
      		<< '(' << Configuration.CString_WithQuotes(pixbuf) << ')';
      }
      else if (Configuration.embed_images && !xpm_ident.empty())
      {	 f.FunctionArg() << '_' << Configuration.InstanceName(w.Name()) 
	   << "_pixmap";
         f.FunctionArg() << '_' << Configuration.InstanceName(w.Name()) 
	   << "_mask";
      }
      else if (Configuration.embed_images)
      {  f.FunctionArg() << '_' << Configuration.InstanceName(w.Name()) 
	   << "_loader->get_pixbuf()";
      }
      else
      {  f.FunctionArg();
         if (pixbuf[0]!='/' && pixbuf.substr(0,2)!="./" 
         	&& !Configuration.pixmap_dir_relative_to_src.empty())
            pixbuf=Configuration.pixmap_dir_relative_to_src+"/"+pixbuf;
         if (!pixbuf.empty()) f << Configuration.CString_WithQuotes(pixbuf);
      }
   }
   else
   {  f.FunctionArg() << '_' << Configuration.InstanceName(w.Name()) 
	<< "_imageloader->pix()";
      f.FunctionArg() << '_' << Configuration.InstanceName(w.Name()) 
	<< "_imageloader->mask()";
   }
}

void Gtk_Image::CreatePointer(const Widget &w,CxxFile &f) const
{  std::string pixbuf=w.getProperty("pixbuf");
   if (pixbuf.empty() && !w.getProperty("stock").empty())
   {  Parent::CreatePointer(w,f);
      return;
   }
   std::string xpm_ident=xpmname(pixbuf);
   std::string instname=Configuration.InstanceName(w.Name());
   if (GTKMM2)
   { if (!Configuration.image_provider.empty()) 
   	; // nothing needed
     else if (Configuration.embed_images)
     {if (!xpm_ident.empty())
      {  f.Declaration() << "Glib::RefPtr<Gdk::Bitmap> _"
   		<< instname <<"_mask";
         f.Declaration() << "Glib::RefPtr<Gdk::Pixmap> _"
      		<< instname <<"_pixmap "
      		"= Gdk::Pixmap::create_from_xpm(get_default_colormap(), _"
		<< instname <<"_mask, "
		<< xpm_ident << ')';
      }
      else
      {  f.Declaration() << "Glib::RefPtr<Gdk::PixbufLoader> _" << instname
      		<< "_loader=Gdk::PixbufLoader::create()";
         if (Configuration.gtkmm_version<Pkg_Version(2,0,0))
      	    f.Declaration() << "GError *_" << instname << "_err=0";
      	 f.Statement() << "_" << instname << "_loader->write(" 
      	 	<< Configuration.CName(pixbuf) << "_data, sizeof " 
      	 	<< Configuration.CName(pixbuf) << "_data";
      	 if (Configuration.gtkmm_version<Pkg_Version(2,0,0))
      	    f << ", _" << instname << "_err";
      	 f << ')';
      	 f.Statement() << "_" << instname << "_loader->close()";
      }
     }
      Parent::CreatePointer(w,f);
   }
   else // can not work with 1.2 ???
   {  f.Declaration() << GtkPrefix()+"ImageLoaderData *_"<<
	instname<<"_imageloader = new "
	<< GtkPrefix()+"ImageLoaderData("
	<< Naming::ToCIdentifier(pixbuf)
	<< ")";
      Parent::CreatePointer(w,f);
      f.Statement() << "delete _" <<
	instname<<"_imageloader";
   }
}

void Gtk_Image::ApplyPreferences(Tag &t) const
{  // I gave up for 1.2, Image seems to not like xpm data
   if (GTKMM1)
   {  static_cast<GladeTag*>(&t)->setWidgetType("GtkPixmap");
      Widget w(&t);
      w.setProperty("filename",w.getProperty("pixbuf"));
      LookupWriter(w).ApplyPreferences(t);
   }
   else
      Parent::ApplyPreferences(t);
}

void Gtk_Image::EmbedImage(CxxFile &f,const std::string &pixbuf) const
{  f.Declaration("static const unsigned char ");
   f << Configuration.CName(pixbuf) << "_data[]";
   f.Assignment().StartBlock().EndLine();
   {  std::ifstream is((Configuration.pixmap_dir+"/"+pixbuf).c_str());
      while (is.good())
      {  /* unsigned ... hmmm g++3.1 does not like this ... */ char buf[16];
         is.read(buf,sizeof buf);
         size_t read=is.gcount();
         f << '\t';
         for (size_t x=0;x<read;++x) f << (unsigned int)(unsigned char)buf[x] << ',';
         f << '\n';
      }
   }
   f.EndBlock();
}
