/* gksu-environment.c generated by valac, the Vala compiler
 * generated from gksu-environment.vala, do not modify */

/*
 * Copyright (C) 2008 Gustavo Noronha Silva
 *
 * This file is part of the Gksu PolicyKit library.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.  You should have received
 * a copy of the GNU General Public License along with this program;
 * if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define GKSU_TYPE_VARIABLE (gksu_variable_get_type ())
#define GKSU_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GKSU_TYPE_VARIABLE, GksuVariable))
#define GKSU_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GKSU_TYPE_VARIABLE, GksuVariableClass))
#define GKSU_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GKSU_TYPE_VARIABLE))
#define GKSU_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GKSU_TYPE_VARIABLE))
#define GKSU_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GKSU_TYPE_VARIABLE, GksuVariableClass))

typedef struct _GksuVariable GksuVariable;
typedef struct _GksuVariableClass GksuVariableClass;
typedef struct _GksuVariablePrivate GksuVariablePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GKSU_TYPE_ENVIRONMENT (gksu_environment_get_type ())
#define GKSU_ENVIRONMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GKSU_TYPE_ENVIRONMENT, GksuEnvironment))
#define GKSU_ENVIRONMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GKSU_TYPE_ENVIRONMENT, GksuEnvironmentClass))
#define GKSU_IS_ENVIRONMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GKSU_TYPE_ENVIRONMENT))
#define GKSU_IS_ENVIRONMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GKSU_TYPE_ENVIRONMENT))
#define GKSU_ENVIRONMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GKSU_TYPE_ENVIRONMENT, GksuEnvironmentClass))

typedef struct _GksuEnvironment GksuEnvironment;
typedef struct _GksuEnvironmentClass GksuEnvironmentClass;
typedef struct _GksuEnvironmentPrivate GksuEnvironmentPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))

struct _GksuVariable {
	GObject parent_instance;
	GksuVariablePrivate * priv;
	char* name;
	char* regex;
};

struct _GksuVariableClass {
	GObjectClass parent_class;
};

struct _GksuEnvironment {
	GObject parent_instance;
	GksuEnvironmentPrivate * priv;
};

struct _GksuEnvironmentClass {
	GObjectClass parent_class;
};

struct _GksuEnvironmentPrivate {
	GeeHashMap* variables;
};


static gpointer gksu_variable_parent_class = NULL;
static gpointer gksu_environment_parent_class = NULL;

GType gksu_variable_get_type (void);
enum  {
	GKSU_VARIABLE_DUMMY_PROPERTY
};
GksuVariable* gksu_variable_new (void);
GksuVariable* gksu_variable_construct (GType object_type);
static void gksu_variable_finalize (GObject* obj);
GType gksu_environment_get_type (void);
#define GKSU_ENVIRONMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GKSU_TYPE_ENVIRONMENT, GksuEnvironmentPrivate))
enum  {
	GKSU_ENVIRONMENT_DUMMY_PROPERTY
};
GHashTable* gksu_environment_get_variables (GksuEnvironment* self);
gboolean gksu_environment_is_variable_valid (GksuEnvironment* self, const char* name, const char* value);
gboolean gksu_environment_validate_hash_table (GksuEnvironment* self, GHashTable* hash_table);
static void gksu_environment_read_variables_from_file (GksuEnvironment* self, const char* path);
static void gksu_environment_read_variables_from_path (GksuEnvironment* self, const char* path);
GksuEnvironment* gksu_environment_new (void);
GksuEnvironment* gksu_environment_construct (GType object_type);
static GObject * gksu_environment_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gksu_environment_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



GksuVariable* gksu_variable_construct (GType object_type) {
	GksuVariable * self;
	self = (GksuVariable*) g_object_new (object_type, NULL);
	return self;
}


GksuVariable* gksu_variable_new (void) {
	return gksu_variable_construct (GKSU_TYPE_VARIABLE);
}


static void gksu_variable_class_init (GksuVariableClass * klass) {
	gksu_variable_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = gksu_variable_finalize;
}


static void gksu_variable_instance_init (GksuVariable * self) {
}


static void gksu_variable_finalize (GObject* obj) {
	GksuVariable * self;
	self = GKSU_VARIABLE (obj);
	_g_free0 (self->name);
	_g_free0 (self->regex);
	G_OBJECT_CLASS (gksu_variable_parent_class)->finalize (obj);
}


GType gksu_variable_get_type (void) {
	static GType gksu_variable_type_id = 0;
	if (gksu_variable_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GksuVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gksu_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GksuVariable), 0, (GInstanceInitFunc) gksu_variable_instance_init, NULL };
		gksu_variable_type_id = g_type_register_static (G_TYPE_OBJECT, "GksuVariable", &g_define_type_info, 0);
	}
	return gksu_variable_type_id;
}


GHashTable* gksu_environment_get_variables (GksuEnvironment* self) {
	GHashTable* result;
	GeeSet* keysset;
	GHashTable* envpairs;
	g_return_val_if_fail (self != NULL, NULL);
	keysset = gee_map_get_keys ((GeeMap*) self->priv->variables);
	envpairs = g_hash_table_new (g_str_hash, g_str_equal);
	{
		GeeIterator* _variable_it;
		_variable_it = gee_iterable_iterator ((GeeIterable*) keysset);
		while (TRUE) {
			char* variable;
			char* value;
			if (!gee_iterator_next (_variable_it)) {
				break;
			}
			variable = (char*) gee_iterator_get (_variable_it);
			value = g_strdup (g_getenv (variable));
			g_hash_table_insert (envpairs, g_strdup (variable), g_strdup (value));
			_g_free0 (variable);
			_g_free0 (value);
		}
		_g_object_unref0 (_variable_it);
	}
	result = envpairs;
	_g_object_unref0 (keysset);
	return result;
}


gboolean gksu_environment_validate_hash_table (GksuEnvironment* self, GHashTable* hash_table) {
	gboolean result;
	GList* varnames;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hash_table != NULL, FALSE);
	varnames = g_hash_table_get_keys (hash_table);
	{
		GList* name_collection;
		GList* name_it;
		name_collection = varnames;
		for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
			char* name;
			name = g_strdup ((const char*) name_it->data);
			{
				const char* value;
				value = (const char*) g_hash_table_lookup (hash_table, name);
				if (!gksu_environment_is_variable_valid (self, name, value)) {
					result = FALSE;
					_g_free0 (name);
					_g_list_free0 (varnames);
					return result;
				}
				_g_free0 (name);
			}
		}
	}
	result = TRUE;
	_g_list_free0 (varnames);
	return result;
}


gboolean gksu_environment_is_variable_valid (GksuEnvironment* self, const char* name, const char* value) {
	gboolean result;
	GError * _inner_error_;
	GksuVariable* _tmp0_;
	gboolean _tmp1_;
	GksuVariable* variable;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_inner_error_ = NULL;
	if ((_tmp1_ = (_tmp0_ = (GksuVariable*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->variables, name)) == NULL, _g_object_unref0 (_tmp0_), _tmp1_)) {
		result = FALSE;
		return result;
	}
	variable = (GksuVariable*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->variables, name);
	if (variable->regex != NULL) {
		_tmp2_ = _vala_strcmp0 (variable->regex, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		{
			GRegex* regex;
			regex = g_regex_new (variable->regex, 0, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				goto __finally0;
			}
			result = g_regex_match (regex, value, 0, NULL);
			_g_regex_unref0 (regex);
			_g_object_unref0 (variable);
			return result;
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("gksu-environment.vala:81: bad regular expression for variable %s", name);
				result = FALSE;
				_g_error_free0 (_error_);
				_g_object_unref0 (variable);
				return result;
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (variable);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_object_unref0 (variable);
	return result;
}


static void gksu_environment_read_variables_from_path (GksuEnvironment* self, const char* path) {
	GError * _inner_error_;
	GDir* directory;
	const char* entry;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_inner_error_ = NULL;
	directory = NULL;
	{
		GDir* _tmp0_;
		GDir* _tmp1_;
		_tmp0_ = g_dir_open (path, (guint) 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			goto __finally1;
		}
		directory = (_tmp1_ = _tmp0_, _g_dir_close0 (directory), _tmp1_);
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (_error_);
			_g_dir_close0 (directory);
			return;
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_dir_close0 (directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	entry = NULL;
	while (TRUE) {
		if (!((entry = g_dir_read_name (directory)) != NULL)) {
			break;
		}
		if (g_str_has_suffix (entry, ".variables")) {
			char* full_path;
			full_path = g_strconcat (path, entry, NULL);
			gksu_environment_read_variables_from_file (self, full_path);
			_g_free0 (full_path);
		}
	}
	_g_dir_close0 (directory);
}


static void gksu_environment_read_variables_from_file (GksuEnvironment* self, const char* path) {
	GError * _inner_error_;
	GKeyFile* file;
	gint variable_names_size;
	gint variable_names_length1;
	char** variable_names;
	char** _tmp1_;
	gsize _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_inner_error_ = NULL;
	file = g_key_file_new ();
	variable_names = (variable_names_length1 = 0, NULL);
	{
		g_key_file_load_from_file (file, path, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch2_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			goto __finally2;
		}
	}
	goto __finally2;
	__catch2_g_key_file_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("gksu-environment.vala:115: %s", _error_->message);
			_g_error_free0 (_error_);
			_g_key_file_free0 (file);
			variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
			return;
		}
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("gksu-environment.vala:118: %s", _error_->message);
			_g_error_free0 (_error_);
			_g_key_file_free0 (file);
			variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
			return;
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (file);
		variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	variable_names = (_tmp1_ = g_key_file_get_groups (file, &_tmp0_), variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL), variable_names_length1 = _tmp0_, variable_names_size = variable_names_length1, _tmp1_);
	{
		char** name_collection;
		int name_collection_length1;
		int name_it;
		name_collection = variable_names;
		name_collection_length1 = variable_names_length1;
		for (name_it = 0; name_it < variable_names_length1; name_it = name_it + 1) {
			char* name;
			name = g_strdup (name_collection[name_it]);
			{
				char* policy;
				GksuVariable* variable;
				char* _tmp5_;
				policy = NULL;
				{
					char* _tmp2_;
					char* _tmp3_;
					_tmp2_ = g_key_file_get_value (file, name, "Policy", &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch3_g_key_file_error;
						}
						goto __finally3;
					}
					policy = (_tmp3_ = _tmp2_, _g_free0 (policy), _tmp3_);
				}
				goto __finally3;
				__catch3_g_key_file_error:
				{
					GError * _error_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					{
						char* _tmp4_;
						policy = (_tmp4_ = NULL, _g_free0 (policy), _tmp4_);
						_g_error_free0 (_error_);
					}
				}
				__finally3:
				if (_inner_error_ != NULL) {
					_g_free0 (name);
					_g_free0 (policy);
					_g_key_file_free0 (file);
					variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				if (_vala_strcmp0 (policy, "send") != 0) {
					_g_free0 (name);
					_g_free0 (policy);
					continue;
				}
				variable = gksu_variable_new ();
				variable->name = (_tmp5_ = g_strdup (name), _g_free0 (variable->name), _tmp5_);
				{
					char* _tmp6_;
					char* _tmp7_;
					_tmp6_ = g_key_file_get_value (file, name, "Regex", &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch4_g_key_file_error;
						}
						goto __finally4;
					}
					variable->regex = (_tmp7_ = _tmp6_, _g_free0 (variable->regex), _tmp7_);
				}
				goto __finally4;
				__catch4_g_key_file_error:
				{
					GError * _error_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					{
						_g_error_free0 (_error_);
					}
				}
				__finally4:
				if (_inner_error_ != NULL) {
					_g_free0 (name);
					_g_free0 (policy);
					_g_object_unref0 (variable);
					_g_key_file_free0 (file);
					variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				gee_abstract_map_set ((GeeAbstractMap*) self->priv->variables, name, variable);
				_g_free0 (name);
				_g_free0 (policy);
				_g_object_unref0 (variable);
			}
		}
	}
	_g_key_file_free0 (file);
	variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
}


GksuEnvironment* gksu_environment_construct (GType object_type) {
	GksuEnvironment * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GksuEnvironment* gksu_environment_new (void) {
	return gksu_environment_construct (GKSU_TYPE_ENVIRONMENT);
}


static GObject * gksu_environment_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GksuEnvironment * self;
	parent_class = G_OBJECT_CLASS (gksu_environment_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GKSU_ENVIRONMENT (obj);
	{
		char** _tmp1_;
		gint search_path_size;
		gint search_path_length1;
		char** _tmp0_;
		char** search_path;
		GeeHashMap* _tmp2_;
		search_path = (_tmp1_ = _tmp0_ = g_get_system_data_dirs (), search_path_length1 = _vala_array_length (_tmp0_), search_path_size = search_path_length1, _tmp1_);
		self->priv->variables = (_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GKSU_TYPE_VARIABLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_str_hash, g_str_equal, NULL), _g_object_unref0 (self->priv->variables), _tmp2_);
		{
			char** path_collection;
			int path_collection_length1;
			int path_it;
			path_collection = search_path;
			path_collection_length1 = search_path_length1;
			for (path_it = 0; path_it < search_path_length1; path_it = path_it + 1) {
				char* path;
				path = g_strdup (path_collection[path_it]);
				{
					char* full_path;
					full_path = g_strconcat (path, "gksu-polkit-1/environment/", NULL);
					gksu_environment_read_variables_from_path (self, full_path);
					_g_free0 (path);
					_g_free0 (full_path);
				}
			}
		}
	}
	return obj;
}


static void gksu_environment_class_init (GksuEnvironmentClass * klass) {
	gksu_environment_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GksuEnvironmentPrivate));
	G_OBJECT_CLASS (klass)->constructor = gksu_environment_constructor;
	G_OBJECT_CLASS (klass)->finalize = gksu_environment_finalize;
}


static void gksu_environment_instance_init (GksuEnvironment * self) {
	self->priv = GKSU_ENVIRONMENT_GET_PRIVATE (self);
}


static void gksu_environment_finalize (GObject* obj) {
	GksuEnvironment * self;
	self = GKSU_ENVIRONMENT (obj);
	_g_object_unref0 (self->priv->variables);
	G_OBJECT_CLASS (gksu_environment_parent_class)->finalize (obj);
}


GType gksu_environment_get_type (void) {
	static GType gksu_environment_type_id = 0;
	if (gksu_environment_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GksuEnvironmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gksu_environment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GksuEnvironment), 0, (GInstanceInitFunc) gksu_environment_instance_init, NULL };
		gksu_environment_type_id = g_type_register_static (G_TYPE_OBJECT, "GksuEnvironment", &g_define_type_info, 0);
	}
	return gksu_environment_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




