# Releasing GitLabracadabra

## Requirements

Ensure last pipeline for `main` passed.

Ensure required dependencies are installed:

```shell
sudo apt-get install -y devscripts dh-python git-buildpackage
npm install \
  semantic-release \
  semantic-release/changelog \
  semantic-release/exec \
  semantic-release/git \
  google/semantic-release-replace-plugin
```

Ensure you can push to `main` branch.

## Pre-release tests

Test the build:

```shell
tox

python3 -m pip install --user -r requirements.txt -r test-requirements.txt --upgrade
python3 setup.py build
python3 setup.py install --user
python3 setup.py test
```

Re-generate the doc:

```shell
for t in project group user application_settings; do
  ~/.local/bin/gitlabracadabra --doc-markdown $t > doc/$t.md
done
```

## Release

Ensure you're up to date:

```shell
git checkout main
git pull --rebase
git status
```

Run `semantic-release`:

```shell
npx semantic-release --no-ci
```

Build the pip package:

```shell
python3 -m pip install --user --upgrade setuptools wheel
python3 setup.py sdist bdist_wheel
```

Build the Debian package:

```shell
gbp buildpackage -S -d
```

<!--
Upload to test.pypi.org

```shell
python3 -m pip install --user --upgrade twine
python3 -m twine upload --repository-url https://test.pypi.org/legacy/ "dist/gitlabracadabra-$target"*
```
-->

Upload artifacts to PyPI and Debian:

```shell
version="$(grep __version__ gitlabracadabra/__init__.py  | awk -F "'" '{print $2}')"
python3 -m twine upload "dist/gitlabracadabra-$version"*

dput "../gitlabracadabra_${version}_source.changes"
```
