#! /bin/sh

set -e

# Read debian specific configuration
. /etc/gitlab/gitlab-debian.conf
export DB RAILS_ENV

cd /usr/share/gitlab

# Check if the db is already present
if [ "$(LANG=C runuser -u postgres -- sh -c "psql gitlab_production -c \"\d\"")" = \
"No relations found." ]; then
  echo "Initializing database..."
  test -f ${gitlab_home}/db/schema.rb || \
  runuser -u ${gitlab_user} -- sh -c \
  "cp ${gitlab_data_dir}/db/schema.rb.template ${gitlab_data_dir}/db/schema.rb"
  runuser -u ${gitlab_user} -- sh -c 'bundle exec rake db:schema:load'
  runuser -u ${gitlab_user} -- sh -c 'bundle exec rake db:seed_fu'
else
  echo "gitlab_production database is not empty, skipping gitlab setup"
  runuser -u ${gitlab_user} -- sh -c 'bundle exec rake db:migrate'
fi

# Restrict permissions for secret files
chmod 0700 ${gitlab_data_dir}/.gitlab_shell_secret

echo "Precompiling assets..."
runuser -u ${gitlab_user} -- sh -c 'bundle exec rake tmp:cache:clear assets:precompile'
