/*
 *  
 *  $Id: selecciontexto.cpp $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <cmath>
#include <wx/icon.h>
#include "selecciontexto.h"
#include <api/iwidgetsmanager.h>
#include <resources/ginkgoresourcesmanager.h>
#include <wx/xml/xml.h>

GNC::GCS::Widgets::Dialogos::SeleccionTexto::SeleccionTexto(wxWindow* parent, TWidget* pWidget, TManager* pManager) : SeleccionTextoBase(parent)
{
	wxIcon icono;
	icono.CopyFromBitmap(GinkgoResourcesManager::MenuIcons::GetIcoEditar());
	this->SetIcon(icono);

	m_pWidget = pWidget;
	m_pManager = pManager;
	m_pControlTexto->SetValue(wxString::FromUTF8(m_pWidget->m_Texto.c_str()));
	m_pControlTexto->SetSelection(-1,-1);
	m_pColorPicker->SetColour( wxColour( (unsigned char) (pWidget->m_Color.B8()), (unsigned char) (pWidget->m_Color.G8()), (unsigned char) (pWidget->m_Color.R8()) ) );
	IniciarColores();

}

GNC::GCS::Widgets::Dialogos::SeleccionTexto::~SeleccionTexto()
{
	if (m_pWidget != NULL && m_pWidget->m_pWidgetSeleccion == this) {
		m_pWidget->m_pWidgetSeleccion= NULL;
	}
}

void GNC::GCS::Widgets::Dialogos::SeleccionTexto::OnClickEnMenu(wxCommandEvent& /*event*/){
	Center();
	ShowModal();
}

void GNC::GCS::Widgets::Dialogos::SeleccionTexto::OnDialogoKeyDown( wxKeyEvent& event )
{
	if (event.GetKeyCode() == WXK_ESCAPE) {
		Close();
	}
	else if (event.GetKeyCode() == WXK_RETURN) {
		Actualizar();
		Close();
	}
	else {
		event.Skip();
	}
}

void GNC::GCS::Widgets::Dialogos::SeleccionTexto::OnControlTextoKeyDown( wxKeyEvent& event )
{
	if (event.GetKeyCode() == WXK_ESCAPE) {
		Close();
	}
	else {
		event.Skip();
	}
}

void GNC::GCS::Widgets::Dialogos::SeleccionTexto::OnControlTextoTextoActualizado( wxCommandEvent& event )
{
	event.Skip();
}

void GNC::GCS::Widgets::Dialogos::SeleccionTexto::OnBotonCancelarClick( wxCommandEvent& /*event*/ )
{
	Close();
}

void GNC::GCS::Widgets::Dialogos::SeleccionTexto::OnBotonAceptarClick( wxCommandEvent& /*event*/ )
{
	Actualizar();
	Close();
}

void GNC::GCS::Widgets::Dialogos::SeleccionTexto::OnColorCambiado(wxColourPickerEvent& /*event*/)
{
	Actualizar(false);
}

void GNC::GCS::Widgets::Dialogos::SeleccionTexto::OnActivar(wxActivateEvent &/*event*/)
{
	m_pControlTexto->SetFocus();
}

void GNC::GCS::Widgets::Dialogos::SeleccionTexto::IniciarColores()
{
	const GNC::GCS::Widgets::Color& colorWidget = m_pWidget->GetColor();
	const GNC::GCS::Widgets::Color colorFondo = colorWidget.Inverso();

	wxColour wColorFondo (colorFondo.R8(), colorFondo.G8(), colorFondo.B8());
	wxColour wColorTexto (colorWidget.B8(), colorWidget.G8(), colorWidget.R8());

	m_pColorPicker->SetColour(wColorTexto);

	m_pControlTexto->SetForegroundColour(wColorTexto);
	m_pControlTexto->SetBackgroundColour(wColorFondo);
}

void GNC::GCS::Widgets::Dialogos::SeleccionTexto::Actualizar(bool actualizarWidget)
{
	wxColour wColorFondo;
	wxColour wColorTexto = m_pColorPicker->GetColour();

	GNC::GCS::Widgets::Color colorTexto(wColorTexto.Blue(), wColorTexto.Green(), wColorTexto.Red());
	GNC::GCS::Widgets::Color ctmp = GNC::GCS::Widgets::Color(colorTexto).Invertir();

	wColorFondo.Set(ctmp.B8(), ctmp.G8(), ctmp.R8());

	m_pControlTexto->SetForegroundColour(wColorTexto);
	m_pControlTexto->SetBackgroundColour(wColorFondo);
	m_pControlTexto->Refresh();

	if (actualizarWidget) {

		bool modifica = false;

		if (colorTexto != m_pWidget->GetColor()) {
			m_pWidget->SetColor(colorTexto);
			modifica = true;
		}

		std::string textoControl(m_pControlTexto->GetValue().ToUTF8());

		if (m_pWidget->GetTexto() != textoControl) {
			m_pWidget->SetTexto(textoControl);
			modifica = true;
		}

		if (modifica) {
			m_pWidget->Invalidar();
			m_pWidget->PropagarModificacion();
		}
	}

}

