/*
 *  
 *  $Id: AnonymizePanel.cpp $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "anonymizepanel.h"
#include <api/dicom/idicommanager.h>
#include <api/dicom/dcmdictionary.h>
#include <main/entorno.h>
#include <api/ientorno.h>
#include <api/controllers/icontroladorlog.h>
#include <api/controllers/iconfigurationcontroller.h>
#include <api/controllers/ipacscontroller.h>
#include <main/controllers/commandcontroller.h>
#include <main/controllers/historycontroller.h>
#include <commands/comandoexportacion.h>

GNC::GUI::AnonymizePanel::AnonymizePanel(wxWindow* pParent): GNC::GUI::AnonymizePanelBase(pParent)
{
}

GNC::GUI::AnonymizePanel::AnonymizePanel(wxWindow* pParent, const std::list<long>& seriesPk): GNC::GUI::AnonymizePanelBase(pParent)
{
	if (seriesPk.empty()) {
		LOG_ERROR("AnonymizePanel", "you have to select at least one series to anonymize");
	} else {
		InitSeries(seriesPk.front());
	}
}

GNC::GUI::AnonymizePanel::~AnonymizePanel()
{
	m_pTagsList->Disconnect(wxEVT_PG_CHANGED,wxPropertyGridEventHandler(AnonymizePanel::OnPropertyChanged),NULL,this);
	m_pTagsList->Disconnect(wxEVT_PG_DOUBLE_CLICK,wxPropertyGridEventHandler(AnonymizePanel::OnPropertyDobleClick),NULL,this);
}

void GNC::GUI::AnonymizePanel::InitSeries(long pkSeries)
{
	GNC::GCS::HistoryController::LightFileModelList fileModels;
	GNC::GCS::HistoryController::Instance()->GetSeriesSortedFileModels(pkSeries, fileModels);

	GIL::DICOM::IDICOMManager*	pDICOMManager = GNC::GCS::IEntorno::Instance()->GetPACSController()->CrearInstanciaDeDICOMManager();
	pDICOMManager->CargarFichero(fileModels.front().real_path, m_base);
	SetTags(m_base, m_pTagsList->GetRoot(), pDICOMManager);
	GNC::Entorno::Instance()->GetPACSController()->LiberarInstanciaDeDICOMManager(pDICOMManager);

	MapOfCheck[GKDCM_PatientName] = m_pCheckNombrePaciente;
	MapOfCheck[GKDCM_PatientID] = m_pCheckIdPaciente;
	MapOfCheck[GKDCM_InstitutionName] = m_pCheckInstituciones;
	MapOfCheck[GKDCM_ReferringPhysicianName] = m_pReferringPhysician;
	MapOfCheck[GKDCM_StudyDescription] = m_pCheckComentarios;
	MapOfCheck[GKDCM_SeriesDescription] = m_pCheckComentarios;
	MapOfCheck[GKDCM_ImageComments] = m_pCheckComentarios;
	
	GNC::GCS::IConfigurationController::TListGroups groups;
	GNC::GCS::IConfigurationController::Instance()->readGroupUser("/Core/AnonymizationSelection", groups);
	for (GNC::GCS::IConfigurationController::TListGroups::iterator it = groups.begin(); it != groups.end(); ++it)
	{
		if ((*it).find("tag") != (*it).end() && (*it).find("value") != (*it).end()) {
			Anonymize((*it)["tag"], true, (*it)["value"]);
		}
	}

	m_pTagsList->Connect(wxEVT_PG_CHANGED,wxPropertyGridEventHandler(AnonymizePanel::OnPropertyChanged),NULL,this);
	m_pTagsList->Connect(wxEVT_PG_DOUBLE_CLICK,wxPropertyGridEventHandler(AnonymizePanel::OnPropertyDobleClick),NULL,this);
}

void GNC::GUI::AnonymizePanel::SetTags(GIL::DICOM::DicomDataset & base,wxPGPropArg idPadre,GIL::DICOM::IDICOMManager*	pDICOMManager) 
{
	for(GIL::DICOM::ListaTags::iterator it = base.tags.begin(); it!= base.tags.end(); ++it){
		wxString helpString = wxString::FromUTF8(pDICOMManager->GetDescription((*it).first).c_str());
		wxStringProperty* prop = NULL;
		wxString valor;
		if((*it).second.size()>100) {
			valor=wxT("Datos");
		} else {
			valor = wxString::FromUTF8((*it).second.c_str());
		}

		if(helpString.size()>0){
			helpString = wxT("(") + wxString::FromUTF8((*it).first.c_str()) + wxT(") ") + helpString;
			prop = new wxStringProperty(helpString,
				wxPG_LABEL,valor);
		}else{
			prop = new wxStringProperty(wxString::FromUTF8((*it).first.c_str()),
				wxPG_LABEL,valor);
		}
		prop->SetHelpString(wxString::FromUTF8((*it).first.c_str()));
		m_pTagsList->AppendIn(idPadre, prop);
	}

	for(GIL::DICOM::DicomDataset::DatasetList::iterator it = base.secuencias.begin(); it!=base.secuencias.end(); ++it){
		wxStringProperty* prop = NULL;
		wxString helpString = wxString::FromUTF8(pDICOMManager->GetDescription((*it).tagName).c_str());
		if(helpString.size()>0){
			helpString = wxT("(") + wxString::FromUTF8((*it).tagName.c_str()) + wxT(") ") + helpString;
			prop = new wxStringProperty(helpString,
				wxPG_LABEL,wxEmptyString);
		}else{
			prop = new wxStringProperty(wxString::FromUTF8((*it).tagName.c_str()),
				wxPG_LABEL,wxEmptyString);
		}
		prop->SetHelpString(wxString::FromUTF8((*it).tagName.c_str()));
		if(m_pTagsList->GetProperty(prop->GetName()) != NULL) {
			////////////////////////////////////std::cout<<"hasdfasdf";
		}
		wxPGId pIdSequencia = m_pTagsList->AppendIn(idPadre,prop);

		//recursion
		int i=0;
		for(GIL::DICOM::DicomDataset::DatasetList::iterator it2 = (*it).items.begin(); it2!= (*it).items.end(); ++it2, ++i) {
			wxPGPropArg pIdItem = m_pTagsList->AppendIn(pIdSequencia,new wxStringProperty(wxString::Format(wxT("Item %d"),i),wxPG_LABEL,wxEmptyString));
			SetTags((*it2),pIdItem,pDICOMManager);
		}
	}
}

void GNC::GUI::AnonymizePanel::OnCheckNombreApellidos( wxCommandEvent& /*event*/ )
{
	//se anonimiza 0010|0010 (nombre del paciente)
	std::string clave("0010|0010");
	Anonymize(clave,m_pCheckNombrePaciente->IsChecked());
}

void GNC::GUI::AnonymizePanel::OnCheckIdPaciente( wxCommandEvent& /*event*/ )
{
	//se anonimiza 0010|0020" (id del paciente)
	std::string clave("0010|0020");
	Anonymize(clave,m_pCheckIdPaciente->IsChecked());
}

void GNC::GUI::AnonymizePanel::OnCheckInstituciones( wxCommandEvent& /*event*/ )
{
	//se anonimiza (0008,0080) Institution Name
	std::string clave("0008|0080");
	Anonymize(clave,m_pCheckInstituciones->IsChecked());
}

void GNC::GUI::AnonymizePanel::OnCheckPhysician( wxCommandEvent& /*event*/ )
{
	//referring physician name
	std::string clave("0008|0090");
	Anonymize(clave,m_pReferringPhysician->IsChecked());
}

void GNC::GUI::AnonymizePanel::OnCheckComentarios( wxCommandEvent& /*event*/ )
{
	//descripcion del estudio, serie e imagenes
	//estudio
	{
		std::string clave("0008|1030");
		Anonymize(clave,m_pCheckComentarios->IsChecked());
	}
	//serie
	{
		std::string clave("0008|103e");
		Anonymize(clave,m_pCheckComentarios->IsChecked());
	}
	//imagen
	{
		std::string clave("0020|4000");
		Anonymize(clave,m_pCheckComentarios->IsChecked());
	}
}

void GNC::GUI::AnonymizePanel::Anonymize(const std::string& clave, bool anonimizar)
{
	wxString value = wxEmptyString;

	if(!anonimizar){
		std::string tmp;
		if(m_base.getTag(clave,tmp)){
			value = wxString::FromUTF8(tmp.c_str());
		}
	}

	Anonymize(clave, anonimizar, std::string(value.ToUTF8()));
}

void GNC::GUI::AnonymizePanel::Anonymize(const std::string& clave, bool anonimizar, const std::string& value)
{
	if (MapOfCheck.find(clave) != MapOfCheck.end()) {
		MapOfCheck[clave]->SetValue(anonimizar);
	}
	wxString valueWx = wxString::FromUTF8(value.c_str());
	for(wxPGProperty* it=m_pTagsList->GetFirst();it!=NULL;it=m_pTagsList->GetNextSiblingProperty(it)){
		if(it->GetHelpString() == wxString::FromUTF8(clave.c_str())){
			it->SetValueFromString(valueWx);
			if(anonimizar){
				m_pTagsList->SetPropertyCell(it->GetId(),0,it->GetLabel(),wxNullBitmap,*wxWHITE,*wxRED);
				m_pTagsList->SetPropertyCell(it->GetId(),1,it->GetValue(),wxNullBitmap,*wxWHITE,*wxRED);
			}else{
				m_pTagsList->SetPropertyCell(it->GetId(),0,it->GetLabel());
				m_pTagsList->SetPropertyCell(it->GetId(),1,it->GetValue());
			}
			it->ChangeFlag(wxPG_PROP_MODIFIED,anonimizar);
			m_pTagsList->RefreshProperty(it);
			return;
		}
	}
}


void GNC::GUI::AnonymizePanel::RemoveFromTable(const std::string& clave)
{
	for(wxPGProperty* it=m_pTagsList->GetFirst();it!=NULL;it=m_pTagsList->GetNextSiblingProperty(it)){
		if(it->GetHelpString() == wxString::FromUTF8(clave.c_str())){
			m_pTagsList->DeleteProperty(it->GetId());
			break;
		}
	}
}

void GNC::GUI::AnonymizePanel::GetTagsAnonymized(GIL::DICOM::DicomDataset & base)
{
	base.tags.clear();
	GNC::GCS::IConfigurationController::TListGroups configGroups;
	for(wxPGProperty* it=m_pTagsList->GetFirst();it!=NULL;it=m_pTagsList->GetNextSiblingProperty(it)){
		if(it->IsFlagSet(wxPG_PROP_MODIFIED)){
			std::string clave(it->GetHelpString().ToUTF8());
			std::string valor(it->GetValueAsString().ToUTF8());
			base.tags[clave] = valor;

			GNC::GCS::IConfigurationController::TMapValues group;
			group["tag"] = clave;
			group["value"] = valor;
			configGroups.push_back(group);
		}
	}
	GNC::GCS::IConfigurationController::Instance()->writeGroupUser("/Core/AnonymizationSelection", configGroups);
	
}

bool GNC::GUI::AnonymizePanel::AnonymizePrivateTags()
{
	return m_pCheckAtributosPrivadosGinkgo->IsChecked();
}

void GNC::GUI::AnonymizePanel::OnPropertyChanged(wxPropertyGridEvent& event)
{
	wxPGProperty* selected= event.GetProperty();
	m_pTagsList->SetPropertyCell(selected->GetId(),0,selected->GetLabel(),wxNullBitmap,*wxWHITE,*wxRED);
	m_pTagsList->SetPropertyCell(selected->GetId(),1,selected->GetValue(),wxNullBitmap,*wxWHITE,*wxRED);
}

void GNC::GUI::AnonymizePanel::OnPropertyDobleClick(wxPropertyGridEvent& event)
{
	std::string clave(event.GetProperty()->GetHelpString().ToUTF8());
	Anonymize(clave,!event.GetProperty()->IsFlagSet(wxPG_PROP_MODIFIED));
}


