/*
*  
*  $Id: dicomservers.h $
*  Ginkgo CADx Project
*
*  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#pragma once
#include <string>
#include <vector>

#include <api/api.h>
#include <api/internationalization/internationalization.h>
#include <api/iexception.h>


//estas constantes vienen dadas por dcmtk
#define DEFAULT_PDU_LENGTH 16384
#define MAX_PDU_LENGTH 131072
#define MIN_PDU_LENGTH 4096

namespace GNC {
	namespace GCS {
		class IEntorno;
	}
}

class GinkgoNoServerFoundException : public GNC::GCS::IException {
public:
	GinkgoNoServerFoundException() throw() : GNC::GCS::IException(_Std("Server not found"), "DICOM", false) {}
};

class DicomServer {
public:
	/* Constructor */
	inline DicomServer(const std::string& ID, const std::string& AET, const std::string& HostName, int port, int Lossy, bool isDefault, int PDU, bool useTLS, const std::string& pacsUser, const std::string& pacsPass, bool useMove, bool retrSeries, bool reuseConnection, bool verify, const std::string& cert, const std::string& key, const std::string& defaultCharset) {
		this->ID = ID;
		this->AET = AET;
		this->HostName = HostName;
		this->Port = port;
		this->Lossy = Lossy;
		this->isDefault = isDefault;
		this->PDU = PDU;

		this->reuseConnection = reuseConnection;
		retrieveSeries = retrSeries;
		retrieveWithMove = useMove;
		this->useTLS    = useTLS;
		this->pacsUser = pacsUser;
		this->pacsPass = pacsPass;
		this->verifyCredentials = verify;
		this->certificate = cert;
		this->privateKey  = key;
		this->defaultCharset = defaultCharset;
	}

	inline DicomServer( const DicomServer& o) {
		*this = o;
	}

	inline ~DicomServer() { }

	DicomServer& operator=(const DicomServer& o)
	{
		this->ID = o.ID;
		this->AET = o.AET;
		this->HostName = o.HostName;
		this->Port = o.Port;
		this->Lossy = o.Lossy;
		this->isDefault = o.isDefault;
		this->PDU = o.PDU;
		this->useTLS = o.useTLS;
		this->pacsUser = o.pacsUser;
		this->pacsPass = o.pacsPass;
		this->retrieveWithMove = o.retrieveWithMove;
		this->reuseConnection = o.reuseConnection;
		this->retrieveSeries = o.retrieveSeries;
		this->verifyCredentials = o.verifyCredentials;
		this->certificate = o.certificate;
		this->privateKey = o.privateKey;
		this->defaultCharset = o.defaultCharset;
		return *this;
	}

	const std::string& GetID()
	{
		return ID;
	}

	const std::string& GetAET()
	{
		return AET;
	}

	const std::string& GetHostName()
	{
		return HostName;
	}

	int GetPort()
	{
		return Port;
	}

	int GetLossy()
	{
		return Lossy;
	}

	bool GetIsDefault() 
	{
		return isDefault;
	}

	int GetPDU()
	{
		return PDU;
	}

	bool GetUseTLS()
	{
		return useTLS;
	}

	const std::string& GetPACSUser()
	{
		return pacsUser;
	}

	const std::string& GetPACSPass()
	{
		return pacsPass;
	}

	bool GetRetrieveWithMove()
	{
		return retrieveWithMove;
	}

	bool GetRetrieveSeries()
	{
		return retrieveSeries;
	}

	bool GetRetrieveWithGet()
	{
		return !retrieveWithMove;
	}

	bool GetReuseConnection()
	{
		return reuseConnection;
	}

	bool GetverifyCredentials()
	{
		return verifyCredentials;
	}

	const std::string& GetCertificate()
	{
		return certificate;
	}

	const std::string& GetPrivateKey()
	{
		return privateKey;
	}

	const std::string& GetDefaultCharset()
	{
		return defaultCharset;
	}

	std::string ID;
	std::string AET;
	std::string HostName;
	int  Port;
	int  PDU;
	int  Lossy;
	bool isDefault;

	bool retrieveWithMove;
	bool reuseConnection;
	bool retrieveSeries;
	bool useTLS;
	std::string pacsUser;
	std::string pacsPass;
	bool verifyCredentials;
	std::string certificate;
	std::string privateKey;
	std::string defaultCharset;
};

class EXTAPI DicomServerHolder {
public:
	DicomServer server;
	DicomServerHolder* next;

	DicomServerHolder(const std::string& ID, const std::string& AET, const std::string& HostName, int Port, int Lossy, bool isDefault, int PDU, bool useTLS, const std::string& pacsUser, const std::string& pacsPass, bool useMove, bool retrSeries, bool reuseConnection, bool verify, const std::string& cert, const std::string& key, const std::string& defaultCharset) : 
	 server(ID, AET, HostName, Port, Lossy, isDefault, PDU, useTLS, pacsUser, pacsPass, useMove, retrSeries, reuseConnection, verify, cert, key, defaultCharset) {
		next = NULL;
	}
	~DicomServerHolder() {}
};

class EXTAPI DicomServerList {
public:
	static DicomServerList* Instance();
	static void FreeInstance();

	void AddServer(const DicomServer& server, bool isDefault);
	bool TieneServer(const std::string& ID);
	DicomServer* GetLocalServer();
	DicomServer* GetServer(const std::string& ID);
	DicomServerHolder* GetList();
	DicomServer* GetDefaultServer();
	void SetDefaultServer(const std::string& ID);
	DicomServer* GetFirst();
	DicomServer* GetLast();
	void Reload();

protected:
	DicomServerList();
	~DicomServerList();
	DicomServerHolder* serverHolders;
	DicomServerHolder* lastInsertedHolder;
	DicomServer* localServer;

protected:
	static DicomServerList *m_pInstance;
};
