/*
*  
*  $Id: handledicom.h $
*  Ginkgo CADx Project
*
*  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once


#include <string>
#include <vector>
#include <api/api.h>
#include <api/autoptr.h>
#include <api/imodelointegracion.h>
#include <api/ievento.h>
#include "eventosginkgo.h"

namespace GNC {
	namespace GCS {
		namespace Events {

			//de momento se pasan uids de series, en un futuro podriamos tratar con open sopinstances uids o study instances
			class EXTAPI EvtHandleDicom: public GNC::GCS::Events::IEvent
			{
			public:
				typedef enum {
					Undefined,
					DeleteSeries,
					OpenSeries
				} TAction;

				typedef std::list<std::string> ListaUIDs;

				EvtHandleDicom():GNC::GCS::Events::IEvent(ginkgoEVT_Core_HandleDICOM)
				{
					m_Nombre = "EvtHandleDicom";
					m_action = Undefined;
				}

				EvtHandleDicom(ListaUIDs lista, TAction action = OpenSeries):GNC::GCS::Events::IEvent(ginkgoEVT_Core_HandleDICOM)
				{
					m_listaUIDs = lista;
					m_Nombre = "EvtHandleDicom";
					m_action = action;
				}

				~EvtHandleDicom()
				{
					m_listaUIDs.clear();
				}

				void SetListaUIDs(ListaUIDs lista)
				{
					m_listaUIDs=lista;
				}

				ListaUIDs &GetListaUIDs()
				{
					return m_listaUIDs;
				}

				TAction GetAction()
				{
					return m_action;
				}

				virtual void pushInfo(std::ostream& out) const {
					out <<"Rutas = [ ";
					int i = 0;
					for (ListaUIDs::const_iterator it = m_listaUIDs.begin(); it != m_listaUIDs.end(); ++it) {
						if (i != 0) {
							out << ", ";
						}
						out << (*it).c_str();
					}
					out << " ]";
				}

			protected:
				ListaUIDs          m_listaUIDs;
				TAction m_action;
			};
		}
	}
}
