/*
*  
*  $Id: comandoincluirhistorial.cpp $
*  Ginkgo CADx Project
*
*  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#include "dbmigrationcommand.h"

#include <api/globals.h>
#include <api/controllers/ieventscontroller.h>
#include <api/ientorno.h>
#include <main/controllers/controladorcomandos.h>
#include <api/internationalization/internationalization.h>
#include <eventos/progresocomando.h>
#include <eventos/mensajes.h>

#include "comandoincluirhistorial.h"

#include <wx/filename.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/msgdlg.h>
#include <wx/thread.h>

#define IDC_MIGRATION 120


GADAPI::DBMigrationCommandParams::DBMigrationCommandParams(const std::string& oldDicomDirPath,const std::string& newDicomDirPath, bool deleteAfterFinish)
{
	OldDicomDir = oldDicomDirPath;
	NewDicomDir = newDicomDirPath;
	DeleteAfterFinish = deleteAfterFinish;
	SemaphoreWaitIncludeFiles = new wxSemaphore();
}

GADAPI::DBMigrationCommandParams::~DBMigrationCommandParams()
{
	delete SemaphoreWaitIncludeFiles;
	SemaphoreWaitIncludeFiles = NULL;
}


GADAPI::DBMigrationCommand::DBMigrationCommand(DBMigrationCommandParams* pParams) : IComando(pParams)
{
	m_pMigrationParams = pParams;
	SetId(IDC_MIGRATION);
	GNC::GCS::IEventsController::Instance()->Registrar(this, GNC::GCS::Events::EventoProgresoComando());
}

void GADAPI::DBMigrationCommand::Execute()
{
	NotificarProgreso(0.0f,_Std("Migrating old DICOM Dir ..."));
	GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams* pParams = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams(m_pMigrationParams->OldDicomDir, true, GNC::GCS::IHistoryController::TAA_COPY);
	GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial* pCmd = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial(pParams);
	
	GNC::ControladorComandos::Instance()->ProcessAsync("Processing...",pCmd, m_pMigrationParams);
	NotificarProgreso(0.05f,_Std("Including files ..."));
	m_pMigrationParams->SemaphoreWaitIncludeFiles->Wait();
}

void GADAPI::DBMigrationCommand::Update()
{
	if (m_pMigrationParams->DeleteAfterFinish) 
	{
		if (wxMessageBox(_("Migration finished successfully, now Ginkgo CADx will delete folder:\n") + FROMPATH(m_pMigrationParams->OldDicomDir) + _T("\n") + _("and all it's sub folders\nDo you confirm deletion?"), _("Info"), wxICON_WARNING|wxOK|wxCANCEL, GNC::GCS::IEntorno::Instance()->GetVentanaRaiz()) == wxOK) 
		{
			GNC::GCS::IEntorno::Instance()->RemoveDirRecursive(m_pMigrationParams->OldDicomDir);
		}		
	} 
	else 
	{
		GNC::GCS::IEventsController::Instance()->ProcesarEvento(new GNC::GCS::Events::EventoMensajes(NULL, _Std("Migration finisthed successfully"), GNC::GCS::Events::EventoMensajes::PopUpMessage));
	}	
}

void GADAPI::DBMigrationCommand::ProcesarEvento(GNC::GCS::Events::IEvent *evt)
{
	GNC::GCS::Events::EventoProgresoComando* pEvt = dynamic_cast<GNC::GCS::Events::EventoProgresoComando*> (evt);
	if (pEvt == NULL  || pEvt->GetComando() == NULL || pEvt->GetComando()->GetOwner() != m_pMigrationParams) {
		return;
	}
	if (pEvt->GetTipo() == GNC::GCS::Events::EventoProgresoComando::TEP_Finalizado)
	{
		m_pMigrationParams->SemaphoreWaitIncludeFiles->Post();
	}
}

