/*
 *  
 *  $Id: clientesoapintegracion.cpp 3830 2011-05-06 13:30:18Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "clientesoapintegracion.h"

#include <string>
#include <sstream>

#include <wx/xml/xml.h>
#include <wx/sstream.h>

#include <api/api.h>
#include <api/globals.h>

#include "conexionopenssl.h"
#include "ginkgohttp.h"

namespace GIL {
	namespace GnkNetwork {
		namespace GnkSOAP {

			ClienteSOAPException::operator const std::string () const {
				return _Std("In connection openssl Exception:")  + GetCause();
			}

			ClienteSOAPIntegracion::ClienteSOAPIntegracion()
			{
			}

			ClienteSOAPIntegracion::~ClienteSOAPIntegracion()
			{
			}

			std::string ClienteSOAPIntegracion::GetXMLPeticion(const std::string& xmlTicket)
			{
				wxXmlDocument doc(FROMPATH(xmlTicket));
				if(!doc.IsOk()){
					throw ClienteSOAPException(_Std("The invocation XML is malformed"));
				}

				//si no es un ticket
				if(doc.GetRoot()->GetName() != wxT("ticketcontext")){
					//integration xml
					wxStringOutputStream outstr;
					doc.Save(outstr);
					std::string salida(outstr.GetString().ToUTF8());
					return salida;
				}

				wxXmlNode* raiz = doc.GetRoot();
				if(raiz == NULL || raiz->GetName() != wxT("ticketcontext")) {
					throw ClienteSOAPException(_Std("The invocation XML is malformed"));
				}
				
				wxString wxTicket;
				wxString wxUri;
				if(!raiz->GetPropVal(wxT("ticket"),&wxTicket) || !raiz->GetPropVal(wxT("url"),&wxUri)) {
					throw ClienteSOAPException(_Std("The invocation XML is malformed"));
				}

				std::string ticket(wxTicket.ToUTF8());
				std::string uriWebService(wxUri.ToUTF8());

				//partimos de que en la configuracion esta definido la direccion del web service, en principio siempre sera https://
				//se puede hacer para tratar el http:// que es mas sencillo, pero de momento pasamos...

				//lo primero es descomponer la uri y extraer servidor/puerto(por defecto 443)/y direccion del servicio
				std::string host("");
				std::string protocolo("");
				int puerto = 0;
				std::string path("");

				ParseURL(uriWebService,protocolo,host,puerto,path);

				//abrimos la conexion ssl
				GIL::GnkNetwork::GnkSSL::ConexionOpenSSL conexion;
				try {
					conexion.CrearConexionSSL(host,puerto);
				} catch (GIL::GnkNetwork::GnkSSL::ConexionOpenSSLException& ex) {
					if(ex.IsFatal()) {
						throw ClienteSOAPException(ex.GetCause());
					} else {
						////////////???????????????????????????????????
					}
				}


				//construimos la peticion http
				std::stringstream	ostrUrl;
				ostrUrl << host <<':'<<puerto;

				std::string	url = ostrUrl.str();

				GIL::GnkNetwork::GnkHTTP::GinkgoHTTP request;
				request.SetHeader("Host",url);
				request.SetHeader("Accept","text/xml");
				request.SetHeader("Accept-Encoding","deflate");
				request.SetHeader("Accept-Language","es");
				request.SetHeader("SOAPAction","");
				request.SetPostBuffer(ConstruirPeticionSOAP(ticket));
				
				std::string peticion = request.BuildPostRequest(path);
				std::string respuesta;
				try {
					conexion.HacerPeticion(peticion,respuesta);

					GIL::GnkNetwork::GnkHTTP::GinkgoHTTP response;
					response.ParseResponse(respuesta);
					if(response.GetContent() == "") {
						std::ostringstream ostr;
						ostr << _Std("Failed to perform the HTTP request, the server returned the error code ") << response.GetResponse();
						throw ClienteSOAPException(ostr.str());
					}
					else {
						std::string xmlIntegracion = ParsearSOAPRespuesta(response.GetContent());
						if(xmlIntegracion == "") {
							std::ostringstream ostr;
							ostr << _Std("Failed to perform the HTTP request, the server returned the error code ") << response.GetResponse();
							throw ClienteSOAPException(ostr.str());
						} else {
							return xmlIntegracion;
						}
					}
				} catch (GIL::GnkNetwork::GnkSSL::ConexionOpenSSLException& ex) {
					if(ex.IsFatal()) {
						throw ClienteSOAPException(ex.GetCause());
					} else {
						throw ClienteSOAPException(ex.GetCause());
					}
				}
			}

			void ClienteSOAPIntegracion::ParseURL(const std::string url,std::string& protocolo, std::string& host, int& puerto, std::string& path)
			{
				if(url.size() == 0) {
					//lanzar excepcion url no configurada
				}

				//primero buscamos los :
				int posicion = url.find_first_of("://");
				if(posicion == (int)std::string::npos) {
					throw ClienteSOAPException(_Std("Not specified the server protocol"));
				}

				protocolo = url.substr(0,posicion);
				if(protocolo != "https"){
					throw ClienteSOAPException(_Std("Unsupported Protocol"));
				}

				std::string hostPuerto;
				posicion=posicion+3;//nos saltamos el ://

				//pillamos el path
				int posicionPath = url.find('/',posicion);
				if(posicionPath == (int)std::string::npos) {
					path = "";
					hostPuerto = url.substr(posicion);
				} else {
					path = url.substr(posicionPath);
					hostPuerto = url.substr(posicion,posicionPath-posicion);
				}

				//por ultimo pillamos el host y el puerto
				int posicionPuntos = hostPuerto.find_first_of(':');
				if(posicionPuntos == (int)std::string::npos) {
					host = hostPuerto;
					//puerto igual al puerto por defecto
					if(protocolo == "https")
					{
						puerto = 443;
					}
				} else {
					host = hostPuerto.substr(0,posicionPuntos);
					puerto = atoi(hostPuerto.substr(posicionPuntos+1).c_str());
					if(puerto == 0){
						throw ClienteSOAPException(_Std("Invalid port"));
					}
				}
			}

			std::string ClienteSOAPIntegracion::ConstruirPeticionSOAP(const std::string& ticket)
			{
				//ostr <<"<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
				//ostr <<"<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" ";
				//ostr << "soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">";
				//ostr <<    "<soapenv:Body>";
				//ostr <<			"<getContext>";
				//ostr <<				"<ticket_id type=\"xsd:string\"></ticket>";
				//ostr <<			"</getContext>";
				//ostr <<		"</soapenv:Body>";
				//ostr <<	"</soapenv:Envelope>";

				wxXmlNode* raiz = new wxXmlNode(NULL,wxXML_ELEMENT_NODE,wxT("soapenv:Envelope"));
				raiz->AddProperty(wxT("xmlns:soapenv"),wxT("http://schemas.xmlsoap.org/soap/envelope/"));
				raiz->AddProperty(wxT("soapenv:encodingStyle"),wxT("http://schemas.xmlsoap.org/soap/encoding/"));
				wxXmlNode* body = new wxXmlNode(raiz,wxXML_ELEMENT_NODE,wxT("soapenv:Body"));
				wxXmlNode* funcion = new wxXmlNode(body,wxXML_ELEMENT_NODE,wxT("getContext"));
				wxXmlNode* parametro = new wxXmlNode(funcion,wxXML_ELEMENT_NODE,wxT("ticket_id"));
				parametro->AddProperty(wxT("type"),wxT("xsd:string"));
				new wxXmlNode(parametro,wxXML_TEXT_NODE,wxT(""),wxString::FromUTF8(ticket.c_str()));

				wxStringOutputStream outstr;
				wxXmlDocument doc;
				doc.SetRoot(raiz);
				doc.Save(outstr);

				std::string salida(outstr.GetString().ToUTF8());
				return salida;

			}

			std::string ClienteSOAPIntegracion::ParsearSOAPRespuesta(const std::string& respuesta)
			{
				//lo metemos en un xmldocument...
				wxStringInputStream inputStr(wxString::FromUTF8(respuesta.c_str()));
				wxXmlDocument doc(inputStr);
				
				wxXmlNode* raiz = doc.GetRoot();

				if (raiz == NULL || !CompararNombreIgnorandoNamespace(raiz->GetName(),wxT("Envelope"))) {
					return "";
				}

				wxXmlNode* body = raiz->GetChildren();
				if (body == NULL || !CompararNombreIgnorandoNamespace(body->GetName(),wxT("Body"))) {
					throw ClienteSOAPException(_Std("Malformed server response"));
				}

				wxXmlNode* hijoBody = body->GetChildren();
				if(hijoBody == NULL || CompararNombreIgnorandoNamespace(hijoBody->GetName(),wxT("Fault"))) {
					//excepcion... recogemos la causa y formamos el mensaje se recorren los hijos buscando faultcode y faultstring
					wxString faultCode;
					wxString faultString;
					for (wxXmlNode* nodo = hijoBody->GetChildren(); nodo != NULL; nodo = nodo->GetNext()) {
						if (CompararNombreIgnorandoNamespace(nodo->GetName(),wxT("faultcode"))) { 
							faultCode = nodo->GetChildren()->GetContent();
						}
						if (CompararNombreIgnorandoNamespace(nodo->GetName(),wxT("faultstring"))) { 
							faultString = nodo->GetChildren()->GetContent();
						}
					}
					std::ostringstream ostr;
					ostr << _Std("There was an error when you invoke the Web service") << std::endl;
					ostr << _Std("Code:") << faultCode.ToUTF8() << std::endl;
					ostr << _Std("Reason:")<< faultString.ToUTF8();

					throw ClienteSOAPException(ostr.str());
				} else if(hijoBody == NULL || CompararNombreIgnorandoNamespace(hijoBody->GetName(),wxT("getContextResponse"))) {
					//parsear resultados
					for (wxXmlNode* nodo = hijoBody->GetChildren(); nodo != NULL; nodo = nodo->GetNext()) {
						if (CompararNombreIgnorandoNamespace(nodo->GetName(),wxT("getContextReturn"))) { 
							std::string xmlRespuesta(nodo->GetChildren()->GetContent().ToUTF8());
							return xmlRespuesta;
						}
					}
				}
				return "";
			}

			bool ClienteSOAPIntegracion::CompararNombreIgnorandoNamespace(const wxString& nombre,const wxString& comparacion)
			{
				int posicion = nombre.find_first_of(':');
				if(posicion == (int)wxString::npos) {
					return nombre.Lower() == comparacion.Lower();
				} else {
					wxString str1 = nombre.substr(posicion+1);
					return str1.Lower() == comparacion.Lower();
				}
			}
		};
	};
};
