/*
*  
*  $Id: iherramientapaneltags.h 4329 2011-10-25 09:46:09Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/iherramienta.h>
#include <api/icontrato.h>
#include <export/icontratoscore.h>
#include "iherramientascore.h"

namespace GNC {
	namespace GCS {
		class EXTAPI IPanelHerramientaTags
		{
		public:
			IPanelHerramientaTags() {}
			~IPanelHerramientaTags() {}

			virtual bool IsVisiblePanelTags() = 0;
			virtual void MostrarOcultarPanelTags() = 0;
			virtual void SetEstudio(GnkPtr<GNC::GCS::IContextoEstudio> pEstudio) = 0;
		};

		class EXTAPI IHerramientaPanelTags: public GNC::GCS::IHerramienta, public GNC::GCS::IContratable<IContrato> {
		public:
			

			typedef GNC::GCS::IContrato                      TContratoPanelTags;
			typedef GNC::GCS::IContratable<IContrato> TContratablePanelTags;

			static const IHerramienta::UID ID = HCore_PanelTags;
			IHerramientaPanelTags() : IHerramienta(HCore_PanelTags,TMenuHerramientas, _Std("DICOM Inspector")) {};
			virtual ~IHerramientaPanelTags() {};

			virtual void SetVistaActiva(GNC::GCS::IVista* pVista) = 0;

			virtual void ConectarContratos(bool) = 0;

			virtual void SetVentanaTags(IPanelHerramientaTags* pWindow) = 0;

			virtual bool ValidaContratos(GNC::GCS::IVista* pVista) {
				return GNC::GCS::IContratable<TContratoPanelTags>::ValidaContrato(pVista);
			}
		};

	};
}
