/*
 *  
 *  $Id: ivista.h 3763 2011-04-25 12:07:55Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include <api/api.h>
#include <api/globals.h>
#include <api/ilock.h>
#include <string>
#include <vector>
#include <yasper/yasper.h>


//----------------------------------------------------------------------------------------------------
//region Forward Declarations

class wxWindow;
class vtkAlgorithmOutput;
class vtkImageData;

namespace GNC{
	namespace GCS {
		class IControladorModulo;
		class IContextoEstudio;
		class IHerramienta;
		class IComando;
	}
}

namespace GIL {
	class IModeloIntegracion;
}
//endregion


namespace GNC {
	namespace GCS {

//----------------------------------------------------------------------------------------------------
//region Excepcion de tipo vista
		class EXTAPI VistaException : public std::exception {
		public:
			VistaException(const std::string& msg, const std::string& componente="Modelo", bool fatal = true) throw();

			~VistaException() throw();

			const std::string& GetComponent() const;

			const std::string& GetCause() const;

			std::string GetFullCause() const;

			bool IsFatal()  const;

			operator const std::string () const;

			friend std::ostream& operator<<(std::ostream& out, const VistaException& ex);

			friend std::ostream& operator<<(std::ostream& out, const VistaException* ex);

		protected:
			std::string cause;
			std::string component;
			bool fatal;
		};
//endregion

//----------------------------------------------------------------------------------------------------
//region Interfaz de vistas

		class EXTAPI IVista : public GNC::GCS::ILockable {
		public:

			/* Constructor */
			IVista(const GnkPtr<GNC::GCS::IContextoEstudio>& estudio);

			/* Destructor */
			virtual ~IVista();

			virtual std::string& GetTitulo();

			virtual wxWindow* GetWindow() = 0;

			virtual bool SoportaHerramienta(GNC::GCS::IHerramienta* pHerramienta);

			virtual bool SoportaGuardar() = 0;

			virtual bool SoportaExportar() = 0;

			/* Notificacion de cambio en la configuracion */
			virtual void OnConfiguracionCambiada();

			virtual void Activar();

			virtual void Desactivar();

			/* Obtiene el identificador unico del modulo al que pertenece */
			virtual const std::string& GetUIDModulo();

			/* Obtiene el modulo al que pertenece */
			virtual GNC::GCS::IControladorModulo* GetModulo();

			GnkPtr<GNC::GCS::IContextoEstudio>& GetEstudio();

			virtual bool EstaCargada();

			virtual bool EstaModificada();

			virtual void SetCargada(bool cargada = true);

			virtual bool Guardar();

			virtual const std::vector<std::string> GetRutasImagenes() const;
			virtual const std::vector<std::string> GetRutasDiagnosticos() const;

			virtual void ActivarRuta(const std::string& path);

			//----------------------------------------------------------------------------------------------------
			//region Interfaz de Carga

			// Comienzo de carga. Metodo sincrono con la interfaz.
			virtual void OnCargaIniciada() = 0;

			// Paso 1: Cargar el estudio. Metodo NO sincrono con la interfaz.
			virtual void CargarEstudio(GNC::GCS::IComando* pCmdInvocador) = 0;

			// Finalizacion de la carga. Metodo sincrono con la interfaz.
			virtual void OnCargaFinalizada() = 0;

			// Paso 2: Inicializacion del pipeline. Metodo sincrono con la interfaz.
			virtual void IniciarPipeline() = 0;

			// Parada del pipeline. Metodo sincrono con la interfaz Se invoca en el caso de que ocurra un error de carga.
			virtual void DetenerPipeline() = 0;

			//endregion

		private:
			// Estudio is a pointer to GnkPtr to avoid circular dependencies.
			GnkPtr<GNC::GCS::IContextoEstudio>* Estudio;

		protected:
			std::string                        m_Titulo;

			bool                               m_Activada;
			bool                               m_Cargada;
			bool                               m_Guardada;

		};
	}
}
