/*
*
*  $Id: volumepipeline.cpp 3830 2011-05-06 13:30:18Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include "volumepipeline.h"
#include "../volumedataset/volumedataset.h"

#include <exception>
#include <wx/window.h>

#include <main/controllers/controladorlog.h>

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif

#include <vtkCommand.h>
#include <vtkImageData.h>
#include <vtkRenderer.h>
#include <vtkImageData.h>
#include <vtkRenderer.h>
#include <vtkImageResample.h>
#include <vtkImageData.h>
#include <vtkRenderer.h>
#include <vtkImageResample.h>
#include <vtkVolume.h>
#include <vtkSmartVolumeMapper.h>
#include <vtkColorTransferFunction.h>
#include <vtkPiecewiseFunction.h>
#include <vtkVolumeProperty.h>
#include <vtkImageReslice.h>

#include <vtkCamera.h>
#include <vtkProperty.h>
#include <vtkRenderWindow.h>
#include <vtkRenderWindowInteractor.h>

#include <vtkWindowToImageFilter.h>
#include <vtkJPEGWriter.h>

#include "../interactors/reconstructioninteractor.h"
#include <vtkInteractorStyleTrackballCamera.h>

class InteractionCommand : public vtkCommand
{
public:

	typedef MedicalViewer::Reconstruction::Pipelines::VolumePipeline TPipeline;
	typedef GinkgoInteractorStyleReconstruction TStyleReconstruction;

	InteractionCommand() : Pipeline(NULL), InitialWindow(0), InitialLevel(0), WindowEventStatus(false)
	{
		Initiallized = false;
	}

	static  InteractionCommand* New()
	{
		return new InteractionCommand();
	}

	void SetPipeline(TPipeline* pipeline)
	{
		Pipeline = pipeline;
	}

	void Execute(vtkObject *   caller,
				 unsigned long event,
				 void *        callData)
	{

		if (this->Pipeline == NULL)
		{
			return;
		}

		if (event == vtkCommand::StartWindowLevelEvent) {
			if (this->Pipeline->IsInitiallized() ) {
				Initiallized = true;
			}
			if (Initiallized) {
				this->StartWindowing();
			}
			return;
		}
		if (event == vtkCommand::EndWindowLevelEvent) {
			if (Initiallized) {
				this->EndWindowing();
			}
			return;
		}
		if (event == vtkCommand::WindowLevelEvent) {
			if (Initiallized) {
				this->Windowing( (TStyleReconstruction*) caller);
			}
			return;
		}
	}

	//ETX

private:

	void Windowing(TStyleReconstruction* p_isi)
	{
		if( !p_isi )
		{
			return;
		}

		double window = this->InitialWindow;
		double level  = this->InitialLevel;
		double EPS    = std::numeric_limits<double>::epsilon();


		double dx = p_isi->GetWindowStep();
		double dy = p_isi->GetLevelStep();

		// Scale by current values
		if (fabs(window) > EPS)
		{
			dx = dx * window;
		}
		else
		{
			dx = dx * (window < 0 ? -EPS : EPS);
		}

		if (fabs(level) > EPS)
		{
			dy = dy * level;
		}
		else
		{
			dy = dy * (level < 0 ? -EPS : EPS);
		}

		// Abs so that direction does not flip
		if (window < 0.0f)
		{
			dx = -1*dx;
		}
		if (level < 0.0f)
		{
			dy = -1*dy;
		}

		// Compute new window level
		double newWindow = dx + window;
		double newLevel  = level - dy;

		// Stay away from zero and really
		if (fabs(newWindow) < EPS)
		{
			newWindow = EPS * (newWindow < 0 ? -1 : 1);
		}

		if (fabs(newLevel) < EPS)
		{
			newLevel = EPS * (newLevel < 0 ? -1 : 1);
		}

		this->Pipeline->UpdateBlending(newWindow, newLevel);
	}

	void StartWindowing()
	{
		this->InitialWindow = this->Pipeline->Window;
		this->InitialLevel  = this->Pipeline->Level;
	}

	void EndWindowing()
	{

	}

private:
	TPipeline*      Pipeline;

	double          InitialWindow;
	double          InitialLevel;

	bool            WindowEventStatus;
	bool            Initiallized;

};

//==============================================================================================

namespace MedicalViewer {
	namespace Reconstruction {
		namespace Pipelines {

			class VolumeCommandObserver : public vtkCommand
			{
			public:

				static VolumeCommandObserver* New() {
					return new VolumeCommandObserver();
				}

				void SetInformation(const std::string& text)
				{
					Text = text;
				}

				void SetNotifier(IReconstructionNotifier* notifier)
				{
					Notifier = notifier;
				}

				virtual void Execute(vtkObject* caller, unsigned long, void *callData) {
					double dProgress = *( (double*)(callData) );
					vtkAlgorithm* alg = (vtkAlgorithm* ) caller;
					if (Notifier) {
						if (! Notifier->NotifyReconstructionProgress( Text, (float)dProgress) ){
							alg->AbortExecuteOn();
						}
					}
				}

				std::string Text;

				IReconstructionNotifier* Notifier;
			};
		}
	}
}

MedicalViewer::Reconstruction::Pipelines::VolumePipeline::VolumePipeline(wxWindow* win3d) : IPipeline("Reconstruction/Surface", win3d)
{

	CurrentBlendType = VBT_MIP;
	vtkSmartPointer<VolumeCommandObserver> Progress;

	Renderer->SetBackground(0.0, 0.0, 0.0);

	Resample = vtkSmartPointer<vtkImageResample>::New();

	Volume = vtkSmartPointer<vtkVolume>::New();
	Mapper = vtkSmartPointer<vtkSmartVolumeMapper>::New();
	Mapper->SetRequestedRenderMode(vtkSmartVolumeMapper::RayCastRenderMode);
	Mapper->SetInputConnection( Resample->GetOutputPort() );

	ColorTransferFunction   = vtkSmartPointer<vtkColorTransferFunction>::New();
	OpacityTransferFunction = vtkSmartPointer<vtkPiecewiseFunction>::New();

	VolumeProperty = vtkSmartPointer<vtkVolumeProperty>::New();

	VolumeProperty->SetColor( ColorTransferFunction );
	VolumeProperty->SetScalarOpacity( OpacityTransferFunction );
	VolumeProperty->SetInterpolationTypeToLinear();

	Volume->SetProperty( VolumeProperty );
	Volume->SetMapper( Mapper );
	Volume->VisibilityOff();

	Renderer->AddVolume(Volume);

	Interactor = vtkSmartPointer<GinkgoInteractorStyleReconstruction>::New();

	//Progresses

	Progress = vtkSmartPointer<VolumeCommandObserver>::New();
	Progress->SetInformation("Resampling volume");
	Resample->AddObserver(vtkCommand::ProgressEvent, Progress);
	Progresses.push_back(Progress);

	Progress = vtkSmartPointer<VolumeCommandObserver>::New();
	Progress->SetInformation("Computing volume");
	Volume->AddObserver(vtkCommand::ProgressEvent, Progress);
	Progresses.push_back(Progress);

	Progress = vtkSmartPointer<VolumeCommandObserver>::New();
	Progress->SetInformation("Mapping volume");
	Mapper->AddObserver(vtkCommand::ProgressEvent, Progress);
	Progresses.push_back(Progress);



}
MedicalViewer::Reconstruction::Pipelines::VolumePipeline::~VolumePipeline()
{
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::SetupInteractor()
{

	vtkSmartPointer<InteractionCommand> cbk = vtkSmartPointer<InteractionCommand>::New();
	cbk->SetPipeline(this);
	//Interactor->AddObserver(vtkCommand::KeyPressEvent, cbk);
	Interactor->AddObserver(vtkCommand::WindowLevelEvent, cbk);
	Interactor->AddObserver(vtkCommand::StartWindowLevelEvent, cbk);
	Interactor->AddObserver(vtkCommand::ResetWindowLevelEvent, cbk);
	Interactor->AddObserver(vtkCommand::EndWindowLevelEvent, cbk);
	//Interactor->AddObserver(InteractionCommand::ZoomEvent, cbk);
	SetInteractorStyleToDefault();

}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::SetInteractorStyleToDefault()
{
	Renderer->GetRenderWindow()->GetInteractor()->SetInteractorStyle(vtkSmartPointer<vtkInteractorStyleTrackballCamera>::New());
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::SetInteractorStyleToWindowLevel()
{
	Renderer->GetRenderWindow()->GetInteractor()->SetInteractorStyle(Interactor);
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::SetWindowLevel(double window, double level)
{
	SettedWindow = Window = window;
	SettedLevel = Level = level;
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::ResetWindowLevel()
{
	Window = SettedWindow;
	Level = SettedLevel;
	if (CurrentBlendType < VBT_RGB_Composite) {
		SetBlendingType(CurrentBlendType);
	}
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::UpdateBlending(double window, double level)
{
	Window = window;
	Level = level;
	if (CurrentBlendType < VBT_RGB_Composite) {
		SetBlendingType(CurrentBlendType);
		Render();
	}

}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::SetBlendingType(VolumeBlendType blendType) {
	switch(blendType) {
		case VBT_CompositeRamp:
			SetBlendingToCompositeRamp();
			break;
		case VBT_CompositeShadeRamp:
			SetBlendingToCompositeShadeRamp();
			break;
		case VBT_RGB_Composite:
			SetBlendingToRGBComposite();
			break;
		case VBT_CT_Skin:
			SetBlendingToCTSkin();
			break;
		case VBT_CT_Muscle:
			SetBlendingToCTMuscle();
			break;
		case VBT_CT_Bone:
			SetBlendingToCTBone();
			break;
		case VBT_MIP:
		default:
			SetBlendingToMIP();
			break;
	}
	CurrentBlendType = blendType;
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::SetBlendingToMIP()
{
	ColorTransferFunction->RemoveAllPoints();
	OpacityTransferFunction->RemoveAllPoints();
	OpacityTransferFunction->Modified();
	ColorTransferFunction->Modified();

	ColorTransferFunction->AddRGBSegment(0.0, 1.0, 1.0, 1.0, 255.0, 1.0, 1.0, 1.0 );
	OpacityTransferFunction->AddSegment( Level - 0.5 * Window, 0.0,
						  Level + 0.5 * Window, 1.0 );
	Mapper->SetBlendModeToMaximumIntensity();
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::SetBlendingToCompositeRamp()
{
	ColorTransferFunction->RemoveAllPoints();
	OpacityTransferFunction->RemoveAllPoints();
	OpacityTransferFunction->Modified();
	ColorTransferFunction->Modified();

	ColorTransferFunction->AddRGBSegment(Level - 0.5 * Window, 0.0, 0.0, 0.0, Level + 0.5*Window, 1.0, 1.0, 1.0 );
	OpacityTransferFunction->AddSegment( Level - 0.5 * Window, 0.0, Level + 0.5 * Window, 1.0 );
	Mapper->SetBlendModeToComposite();
	VolumeProperty->ShadeOff();
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::SetBlendingToCompositeShadeRamp()
{
	ColorTransferFunction->RemoveAllPoints();
	OpacityTransferFunction->RemoveAllPoints();
	OpacityTransferFunction->Modified();
	ColorTransferFunction->Modified();

	ColorTransferFunction->AddRGBSegment(0.0, 1.0, 1.0, 1.0, 255.0, 1.0, 1.0, 1.0 );
	OpacityTransferFunction->AddSegment( Level - 0.5 * Window, 0.0, Level + 0.5 * Window, 1.0 );
	Mapper->SetBlendModeToComposite();
	VolumeProperty->ShadeOn();
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::SetBlendingToRGBComposite()
{
	ColorTransferFunction->RemoveAllPoints();
	OpacityTransferFunction->RemoveAllPoints();
	OpacityTransferFunction->Modified();
	ColorTransferFunction->Modified();

	OpacityTransferFunction->AddPoint(0, 0.0);
	OpacityTransferFunction->AddPoint(5.0, 0.0);
	OpacityTransferFunction->AddPoint(30.0, 0.05);
	OpacityTransferFunction->AddPoint(31.0, 0.0);
	OpacityTransferFunction->AddPoint(90.0, 0.0);
	OpacityTransferFunction->AddPoint(100.0, 0.3);
	OpacityTransferFunction->AddPoint(110.0, 0.0);
	OpacityTransferFunction->AddPoint(190.0, 0.0);
	OpacityTransferFunction->AddPoint(200.0, 0.4);
	OpacityTransferFunction->AddPoint(210.0, 0.0);
	OpacityTransferFunction->AddPoint(245.0, 0.0);
	OpacityTransferFunction->AddPoint(255.0, 0.5);

	Mapper->SetBlendModeToComposite();
	VolumeProperty->ShadeOff();
	VolumeProperty->SetScalarOpacityUnitDistance(1.0);
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::SetBlendingToCTSkin()
{
	ColorTransferFunction->RemoveAllPoints();
	OpacityTransferFunction->RemoveAllPoints();
	OpacityTransferFunction->Modified();
	ColorTransferFunction->Modified();

	ColorTransferFunction->AddRGBPoint( -3024, 0, 0, 0, 0.5, 0.0 );
	ColorTransferFunction->AddRGBPoint( -1000, .62, .36, .18, 0.5, 0.0 );
	ColorTransferFunction->AddRGBPoint( 100, .88, .60, .29, 0.33, 0.45 );
	ColorTransferFunction->AddRGBPoint( 3071, .83, .66, 1, 0.5, 0.0 );

	OpacityTransferFunction->AddPoint(-3024, 0, 0.5, 0.0 );
	OpacityTransferFunction->AddPoint(-1000, 0, 0.5, 0.0 );
	OpacityTransferFunction->AddPoint(100, 1.0, 0.33, 0.45 );
	OpacityTransferFunction->AddPoint(3071, 1.0, 0.5, 0.0);

	Mapper->SetBlendModeToComposite();
	VolumeProperty->ShadeOn();
	VolumeProperty->SetAmbient(0.1);
	VolumeProperty->SetDiffuse(0.9);
	VolumeProperty->SetSpecular(0.2);
	VolumeProperty->SetSpecularPower(10.0);
	VolumeProperty->SetScalarOpacityUnitDistance(0.8919);
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::SetBlendingToCTMuscle()
{
	ColorTransferFunction->RemoveAllPoints();
	OpacityTransferFunction->RemoveAllPoints();
	OpacityTransferFunction->Modified();
	ColorTransferFunction->Modified();

	ColorTransferFunction->AddRGBPoint( -3024, 0, 0, 0, 0.5, 0.0 );
	ColorTransferFunction->AddRGBPoint( -155, .55, .25, .15, 0.5, .92 );
	ColorTransferFunction->AddRGBPoint( 217, .88, .60, .29, 0.33, 0.45 );
	ColorTransferFunction->AddRGBPoint( 420, 1, .94, .95, 0.5, 0.0 );
	ColorTransferFunction->AddRGBPoint( 3071, .83, .66, 1, 0.5, 0.0 );

	OpacityTransferFunction->AddPoint(-3024, 0, 0.5, 0.0 );
	OpacityTransferFunction->AddPoint(-155, 0, 0.5, 0.92 );
	OpacityTransferFunction->AddPoint(217, .68, 0.33, 0.45 );
	OpacityTransferFunction->AddPoint(420,.83, 0.5, 0.0);
	OpacityTransferFunction->AddPoint(3071, .80, 0.5, 0.0);

	Mapper->SetBlendModeToComposite();
	VolumeProperty->ShadeOn();
	VolumeProperty->SetAmbient(0.1);
	VolumeProperty->SetDiffuse(0.9);
	VolumeProperty->SetSpecular(0.2);
	VolumeProperty->SetSpecularPower(10.0);
	VolumeProperty->SetScalarOpacityUnitDistance(0.8919);
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::SetBlendingToCTBone()
{
	ColorTransferFunction->RemoveAllPoints();
	OpacityTransferFunction->RemoveAllPoints();
	OpacityTransferFunction->Modified();
	ColorTransferFunction->Modified();

	ColorTransferFunction->AddRGBPoint( -3024, 0, 0, 0, 0.5, 0.0 );
	ColorTransferFunction->AddRGBPoint( -16, 0.73, 0.25, 0.30, 0.49, .61 );
	ColorTransferFunction->AddRGBPoint( 641, .90, .82, .56, .5, 0.0 );
	ColorTransferFunction->AddRGBPoint( 3071, 1, 1, 1, .5, 0.0 );

	OpacityTransferFunction->AddPoint(-3024, 0, 0.5, 0.0 );
	OpacityTransferFunction->AddPoint(-16, 0, .49, .61 );
	OpacityTransferFunction->AddPoint(641, .72, .5, 0.0 );
	OpacityTransferFunction->AddPoint(3071, .71, 0.5, 0.0);

	Mapper->SetBlendModeToComposite();
	VolumeProperty->ShadeOn();
	VolumeProperty->SetAmbient(0.1);
	VolumeProperty->SetDiffuse(0.9);
	VolumeProperty->SetSpecular(0.2);
	VolumeProperty->SetSpecularPower(10.0);
	VolumeProperty->SetScalarOpacityUnitDistance(0.8919);
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::SetDataSet(unsigned int volNum, double reductionFactor)
{

	GnkPtr<TDataSet> vol = FindDataSet(volNum);

	if (!vol) {
		LOG_ERROR("Reconstruction/Volume", "Unable to set DataSet " << volNum << ": DataSet not found");
		return;
	}

	LOG_DEBUG("Reconstruction/Volume", "Setting DataSet " << volNum << ". Range = [ " << vol->MinValue << ", " << vol->MaxValue << " ]");

	CurrentImage = vol->Img;
	Window = (double)vol->MaxValue - (double)vol->MinValue;
	Level = 0.5 * Window;

	Resample->RemoveAllInputs();
	Resample->SetInput(CurrentImage);
	Resample->SetAxisMagnificationFactor(0, reductionFactor);
	Resample->SetAxisMagnificationFactor(1, reductionFactor);
	Resample->SetAxisMagnificationFactor(2, reductionFactor);
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::Enable(bool enable)
{
	Volume->SetVisibility(enable? 1: 0);
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::Update()
{

	LOG_DEBUG("VolumePipeline", _Std("Updating..."));

	Resample->AbortExecuteOff();
	Mapper->AbortExecuteOff();

	try {
		Mapper->Update();
	}
	catch (...)
	{
	}

	LOG_DEBUG("VolumePipeline", _Std("Update done"));
}

void MedicalViewer::Reconstruction::Pipelines::VolumePipeline::SetProgressNotifier(IReconstructionNotifier* notifier)
{
	for (TProgressList::iterator it = Progresses.begin(); it != Progresses.end(); it++) {
		(*it)->SetNotifier(notifier);
	}
}
