/*
 *  
 *  $Id: lightvisualizatorstudy.h 3905 2011-06-30 08:47:47Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/icontextoestudio.h>

class wxWindow;
class wxSizer;
class wxXmlNode;
class wxXmlDocument;

namespace LightVisualizator {
	//study represents files handled by a view, resolve tasks like widgets load/store, dicom tags reading, diagnostic handling...
	//you have only to extent GNC::GCS::IContextoEstudio and implement Callbacks
	//you can extent functionality to load specific tags handled with this view
	class LightVisualizatorStudy : public GNC::GCS::IContextoEstudio
	{
	public:
		
		LightVisualizatorStudy();
		~LightVisualizatorStudy();

		virtual void SetIndiceActivo(int indice);

		//initialization method
		virtual void InicializarContextoEstudio(std::vector<std::string>& rutas, const std::string uidEstudioDiagnostico, GNC::GCS::IContextoEstudio::TModoFuncionamiento modoFuncionamiento);


		virtual bool CallbackPreCrearDiagnostico(const int indice, GIL::DICOM::TipoJerarquia* pJerarquiaSR, std::list<GnkPtr<GIL::DICOM::TipoPrivateTags> >& listaTagsPrivados) {return true;}
		virtual bool CallbackPreGuardarDiagnostico(const int /*indice*/, GIL::DICOM::IDICOMManager* /*pDicomManager*/) {return true;}
		virtual void CallbackCargarTagsImagen(const int /*indice*/, GIL::DICOM::IDICOMManager* /*pDicomManager*/) {}


	protected:

	};
}
