/*
 *  
 *  $Id: ginkgohttp.cpp 3814 2011-05-01 11:36:06Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "ginkgohttp.h"
#include <sstream>

namespace GIL {
	namespace GnkNetwork {
		namespace GnkHTTP {
			GinkgoHTTP::GinkgoHTTP() 
			{
				m_http_response = 0;
				m_post_buf = "";
			}

			GinkgoHTTP::~GinkgoHTTP() 
			{
				ClearHeaders();
			}

			void GinkgoHTTP::ClearHeaders()
			{
				m_headers.clear();
				m_content = "";
			}

			const std::string GinkgoHTTP::GetContentType() const
			{
				return GetHeader("Content-Type");
			}

			const std::string GinkgoHTTP::GetContent() const {
				return m_content;
			}

			const int& GinkgoHTTP::GetHttpResponseCode() const {
				return m_http_response;
			}

			GinkgoHTTP::IteradorHeaders GinkgoHTTP::FindHeader(const std::string& header){
				IteradorHeaders it = m_headers.begin();
				for(; it != m_headers.end(); ++it) {
					if(header == (*it).first){
						break;
					}
				}
				return it;	
			}

			GinkgoHTTP::IteradorHeadersConst GinkgoHTTP::FindHeader(const std::string& header) const
			{
				IteradorHeadersConst it = m_headers.begin();
				for(; it != m_headers.end(); ++it) {
					if(header == (*it).first){
						break;
					}
				}
				return it;	
			}


			void GinkgoHTTP::SetHeader(const std::string& clave, const std::string& valor)
			{
				IteradorHeaders it = FindHeader(clave);
				if (it != m_headers.end())
					it->second = valor;
				else
					m_headers[clave] = valor;
			}

			std::string GinkgoHTTP::GetHeader(const std::string& header) const
			{
				IteradorHeadersConst it = FindHeader(header);

				return it == m_headers.end() ? "" : it->second;
			}

			void GinkgoHTTP::SetPostBuffer(const std::string& post_buf)
			{
				m_post_buf = post_buf;
			}

			std::string GinkgoHTTP::ConstruyeHeaders()
			{
				std::stringstream ostr;

				for (IteradorHeaders it = m_headers.begin(), en = m_headers.end(); it != en; ++it )
				{
					ostr<<(*it).first<<": "<<(*it).second<<"\r\n";
				}

				return ostr.str();
			}

			std::string GinkgoHTTP::BuildGetRequest(const std::string& path)
			{
				return BuildRequest(path,HTTP_GET);
			}

			std::string GinkgoHTTP::BuildPostRequest(const std::string& path)
			{
				return BuildRequest(path,HTTP_POST);
			}

			std::string GinkgoHTTP::BuildRequest(const std::string& path,GnkHTTP_Req req)
			{
				std::string request;

				switch (req)
				{
				case HTTP_GET:
					request = "GET";
					break;

				case HTTP_POST:
					request = "POST";
					if ( GetHeader( "Content-Length" ) == "" ){
						std::stringstream ostr;
						ostr << m_post_buf.size();
						SetHeader( "Content-Length", ostr.str() );
					}
					break;

				default:
					return "";
				}

				m_http_response = 0;

				// If there is no User-Agent defined, define it.
				if (GetHeader("User-Agent") == "")
					SetHeader("User-Agent", "Ginkgo");

				std::ostringstream ostrPeticion;

				ostrPeticion << request << " " << path << " HTTP/1.0\r\n";
				ostrPeticion << ConstruyeHeaders() << "\r\n";

				if ( req == HTTP_POST ) {
					ostrPeticion << m_post_buf;
				}

				return ostrPeticion.str();
			}

			int GinkgoHTTP::GetLinea(const std::string& cadena, std::string& linea, int indice)
			{
				int posicion =cadena.find('\n',indice);
				if(posicion ==(int)std::string::npos) {
					linea = cadena.substr(indice);
				} else {
					linea = cadena.substr(indice,posicion-indice);
				}
				return posicion+1;
			}

			bool GinkgoHTTP::ParseResponse(std::string response)
			{
				ClearHeaders();
				m_http_response =0;

				bool salida = true;
				int indice;

				std::string tmpString;
				indice = GetLinea(response,tmpString,0);
				if(indice == (int)std::string::npos) {
					return false;
				}

				if(tmpString.find_first_of("HTTP/")==std::string::npos) {
					// TODO: support HTTP v0.9 which can have no header.
					// FIXME: tmp_str is not put back in the in-queue of the socket.
					SetHeader("Content-Length", "-1");
					SetHeader("Content-Type", "none/none");
					return true;
				}

				if(tmpString.find_first_of(' ') != std::string::npos) {
					std::string tmpSubString = tmpString.substr(tmpString.find_first_of(' ')+1);
					std::istringstream isstream(tmpSubString);
					isstream >> m_http_response;
					if(tmpSubString.at(0) != '2'){
						salida = false;
					}
				}

				std::string strLinea;

				do {
					indice = GetLinea(response,strLinea,indice);
					int puntos = strLinea.find_first_of(':');
					if(puntos>0) {
						std::string cabecera = strLinea.substr(0,puntos);
						m_headers[cabecera] = strLinea.substr(puntos+1,strLinea.size()-1);
					} else {
						m_content = response.substr(indice);
						break;
					}
				}while (indice != (int)std::string::npos);

				return salida;
			}
		};
	};
};

