/*
 *  
 *  $Id: herramientapuntero.cpp 3830 2011-05-06 13:30:18Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <api/iwidgetsmanager.h>
#include "herramientapuntero.h"
#include <resources/ginkgoresourcemanager.h>


#include <iostream>
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>


GNC::HerramientaPuntero::HerramientaPuntero() {
	m_Activa = false;

	m_Descripcion = _Std("Pointer");
	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoFlecha();
}

GNC::HerramientaPuntero::~HerramientaPuntero() {
	;
}

//region "Realización de la interfaz IHerramienta"

void GNC::HerramientaPuntero::CrearPaneles( wxPanel* /*panel*/ ) {
	m_pAbstractPanelHerramientaOpciones = NULL;
}

void GNC::HerramientaPuntero::ConectarContratoFalso(bool activar) {
	if (TContratableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	for (TContratableWidgets::IteradorListaContratos it = TContratableWidgets::m_pListaActiva->begin(); it != TContratableWidgets::m_pListaActiva->end(); it++) {
		TContratoWidgets* pC = (*it);
		if (pC->Inicializado()) {
			pC->GetManager()->EnableAnotacionDinamica(activar);
			if (activar) {
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				GTRACE( "HerramientaPuntero: Conectando contrato falso de vista " << TContratableWidgets::m_pVistaActiva );
			} else {
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				GTRACE( "HerramientaPuntero: Desconectando contrato falso de vista " << TContratableWidgets::m_pVistaActiva );
			}
		}
	}
}

void GNC::HerramientaPuntero::SetVistaActiva(GNC::GCS::IVista* pVista) {
	if (pVista == NULL) {
		;
	}
	TContratableWidgets::EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaPuntero::SetVistaActiva(" <<  pVista << ")");

}

void GNC::HerramientaPuntero::ConectarContratos(bool activar) {

	TContratableWidgets::ListaContratos* lista = TContratableWidgets::ObtenerContratosDeActiva();
	if (lista == NULL) {
		if (activar) {
			std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		} else {
			if (m_pSeleccionBuilder != NULL)
			{
				delete m_pSeleccionBuilder;
				m_pSeleccionBuilder = NULL;
			}
		}
		return;
	}

	for (TContratableWidgets::IteradorListaContratos it = lista->begin(); it != lista->end(); it++) {
		TContratoWidgets* pC = (*it);
		if (pC->Inicializado()) {
			pC->GetManager()->EnableAnotacionDinamica(activar);
			if (activar) {
				GTRACE( "HerramientaPuntero: Conectando contratos de vista " << TContratableWidgets::m_pVistaActiva );
				m_pSeleccionBuilder = new TSeleccionBuilder(pC->GetManager(), (unsigned long)this);
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(m_pSeleccionBuilder->GetCursor());
			}
			else {
				GTRACE( "HerramientaPuntero: Desconectando contratos de vista " << TContratableWidgets::m_pVistaActiva );
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				// DesSubscribimos los eventos de la ventana a un metodo especifico del panel de esta herramienta
				delete m_pSeleccionBuilder;
				m_pSeleccionBuilder = NULL;
			}
		}
	}
}

//endregion


//region "Eventos refinados desde los paneles"

//endregion
