/*
 *  
 *  $Id: herramientalayoutventana.h 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <export/iherramientalayoutventana.h>
#include <api/api.h>

#include <map>

namespace GNC {

	class EXTAPI HerramientaLayoutVentana : public GNC::GCS::IHerramientaLayoutVentana {

	protected:

	public:
		HerramientaLayoutVentana();
		~HerramientaLayoutVentana();

		virtual bool AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent);
		virtual wxMenu* GetMenu(wxWindow* pParent);

		//region "Realizacin de la interfaz IHerramienta"

		// Setup de paneles
		virtual void CrearPaneles( wxPanel* pParent );
		
		//endregion

		//acciones
		virtual void SetLayoutVentana(int filas, int columnas);
		virtual void AddFila();
		virtual void AddColumna();
		virtual void DelFila();
		virtual void DelColumna();
		
		virtual bool PuedeAgregar();
		virtual bool Soporta(int filas, int columnas);
		virtual bool PuedeEliminarFila();
		virtual bool PuedeEliminarColumna();

		virtual void ConectarContratoFalso(bool activar);
		virtual void SetVistaActiva(GNC::GCS::IVista* pVista);
		virtual void ConectarContratos(bool activar);


	protected:

	};
}
