/*
 *  
 *  $Id: panelconfiguracionanonimizacion.h 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iconfiguracion.h>
#include "panelesconfiguracionginkgobase.h"
#include <string>
#include <vector>

namespace GNC {
	namespace GUI {

		class PanelConfiguracionAnonimizacion: public PanelConfiguracionAnonimizacionBase, public IPasoConfiguracion
		{
			public:
				PanelConfiguracionAnonimizacion(wxWindow* pParent,IDialogoConfiguracion* pDialogo);
				~PanelConfiguracionAnonimizacion();

				void Recargar();

				//region "Metodos de IPasoConfiguracion"
				wxWindow* GetPanel();

				std::string GetTitle();

				std::string GetCabecera();

				bool Validar();

				bool Guardar();

				void Exportar(wxXmlNode* pNodo);

				void Importar(wxXmlNode* pNodo);

				//endregion


			protected:
				void OnSize(wxSizeEvent &){
					Layout();
				}

				void OnListBoxClick(wxCommandEvent &event);

				void OnListBoxDClick(wxCommandEvent &event);

				void OnAddClick(wxCommandEvent &event);

				void OnEliminarClick(wxCommandEvent &event);

				void OnModificarClick(wxCommandEvent &event);

				void OnValorAnonimizarDefecto(wxCommandEvent &event);
		};
	};
};
