/*
 *  
 *  $Id: dicommoveassocation.cpp 3907 2011-07-01 07:27:36Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *  Code adapted from Aeskulap
 *
 */
#define LOGGER "C-MOVE"

#include <api/icontroladorlog.h>
#include <main/controllers/controladorlog.h>
#include <api/dicom/imodelodicom.h>
#include <main/controllers/controladorpermisos.h>
#include <api/controllers/ipacscontroller.h>

#include <api/icontextoestudio.h>
#include <api/internacionalization/internacionalization.h>

#include "istorecallback.h"

#include "dicomnetwork.h"
#include "dicommoveassociation.h"

#include <dcmtk/dcmnet/diutil.h>
#include <dcmtk/dcmnet/assoc.h>
#include <dcmtk/dcmjpeg/djencode.h>
#include <dcmtk/dcmjpeg/djrplol.h>
#include <dcmtk/dcmdata/dcuid.h>
#include <dcmtk/dcmdata/dcdatset.h>
#include <dcmtk/dcmdata/dcdeftag.h>

#include <wx/string.h>
#include <wx/intl.h>

#include "tls/tls.h"
#include "tls/gtlslayer.h"
#include <dcmtk/dcmtls/tlstrans.h>

std::string MoveAssociation::m_errorMessage = "";

MoveAssociation::MoveAssociation(const std::string& _ambitolog, IModeloDicom* pModelo) : FindAssociation(_ambitolog) {
	m_abstractSyntax = (char*) UID_MOVEStudyRootQueryRetrieveInformationModel;
	m_maxReceivePDULength = ASC_DEFAULTMAXPDU;
	m_pHandler = NULL;
	m_pModelo = pModelo;
	m_numeroImagenes=0;
	m_mensaje="";
	m_errorMessage = "";
	m_bytesDescargados = 0;
}

MoveAssociation::~MoveAssociation() { }

void MoveAssociation::Create(const std::string& title, const std::string& peer, int port, const std::string& ouraet, /*int ourPort,*/ const char *abstractSyntax) {
	Association::Create(title, peer, port, ouraet, abstractSyntax);
}

void MoveAssociation::SetModelo(IModeloDicom* pModelo) {
	m_pModelo = pModelo;
}

CONDITION MoveAssociation::SendObject(DcmDataset *dataset) {
	return moveSCU(dataset);
}

void MoveAssociation::OnAddPresentationContext(T_ASC_Parameters *params) {
	addAllStoragePresentationContexts(params, true, true);
}

CONDITION MoveAssociation::moveSCU(DcmDataset *pdset) {
	CONDITION cond;
	T_ASC_PresentationContextID presId;
	T_DIMSE_C_MoveRQ req;
	T_DIMSE_C_MoveRSP rsp;
	DIC_US msgId = assoc->nextMsgID++;
	DcmDataset* rspIds = NULL;
	const char* sopClass;
	DcmDataset* statusDetail = NULL;
	MoveCallbackInfo callbackData;

	if (pdset == NULL) {
		LOG_ERROR(ambitolog, "Dataset nulo en moveSCU");
		return DIMSE_NULLKEY;
	}

	//sopClass = m_abstractSyntaxMove;
	sopClass = m_abstractSyntax.c_str();

	// which presentation context should be used
	presId = ASC_findAcceptedPresentationContextID(assoc, sopClass);

	if (presId == 0) {
		return DIMSE_NOVALIDPRESENTATIONCONTEXTID;
	}

	callbackData.assoc = assoc;
	callbackData.presId = presId;
	callbackData.pCaller = this;

	req.MessageID = msgId;
	strcpy(req.AffectedSOPClassUID, sopClass);
	req.Priority = DIMSE_PRIORITY_HIGH;
	req.DataSetType = DIMSE_DATASET_PRESENT;
	strcpy(req.MoveDestination, m_ourAET.c_str());

	ResetearMedida(true);
	m_numeroImagenes=0;
	cond = DIMSE_moveUser(
		assoc,
		presId,
		&req,
		pdset,
		moveCallback,
		&callbackData,
		DIMSE_BLOCKING,
		0,
		GetNetwork()->GetDcmtkNet(),
		subOpCallback,
		this,
		&rsp, &statusDetail, &rspIds);

	if (statusDetail != NULL) {
		LOG_DEBUG(ambitolog, "DIMSE_moveUser(): Estado: " << std::endl << DumpDataset(statusDetail));
		delete statusDetail;
	}

	if (rspIds != NULL) {
		delete rspIds;
	}

	if(m_errorMessage != "")
	{
		throw GIL::DICOM::PACSException(m_errorMessage, "Acquisition");
	}

	return cond;
}

void MoveAssociation::moveCallback(void* /*callbackData*/, T_DIMSE_C_MoveRQ* /*request*/, int /*responseCount*/, T_DIMSE_C_MoveRSP* /*response*/)
{
}

void MoveAssociation::subOpCallback(void *pCaller, T_ASC_Network *aNet, T_ASC_Association **subAssoc) {
	MoveAssociation* caller = (MoveAssociation*) pCaller;

	if (caller->GetNetwork() == NULL) {
		return;
	}

	wxString msg = wxString::Format(_("Downloading file %d"), ++caller->m_numeroImagenes);
	caller->m_mensaje = std::string(msg.ToUTF8());
	LOG_DEBUG(caller->ambitolog, caller->m_mensaje);
	caller->NotificarProgreso((float)caller->m_numeroImagenes/100,caller->m_mensaje);

	if (*subAssoc == NULL) {
		// negotiate association
		LOG_DEBUG(caller->ambitolog, "Aceptando subAsociacion");
		caller->acceptSubAssoc(aNet, subAssoc);
	}
	else {
		// be a service class provider
		LOG_DEBUG(caller->ambitolog, "Invocando subOp SCP");
		caller->subOpSCP(subAssoc);
	}
}

CONDITION MoveAssociation::acceptSubAssoc(T_ASC_Network *aNet, T_ASC_Association **assoc) {
	CONDITION cond = ASC_NORMAL;
	
	const char* knownAbstractSyntaxes[] = {UID_VerificationSOPClass};
	
	//////	
	if (m_TLS)
    {
		 
		std::string cliCert = GetCliCert();
		std::string cliKey  = GetCliKey();
		GTLSTransportLayer* tLayer = new GTLSTransportLayer(DICOM_APPLICATION_REQUESTOR, NULL);
		if (tLayer == NULL)
		{
			LOG_ERROR("C-MOVE SubAssoc", "unable to create TLS transport layer");
			//return 1;
			return EC_IllegalParameter;
		}
		tLayer->setCertificateFromString(cliCert);
		tLayer->setPrivateKeyFromString(cliKey);
		
		if (! tLayer->checkPrivateKeyMatchesCertificate())
		{
			LOG_ERROR("C-MOVE SubAssoc", "private key and certificate do not match");
			return EC_IllegalParameter;
		}
		
		tLayer->addSystemTrustedCertificates();
		
		if (m_Validate) {
			tLayer->setCertificateVerification(DCV_requireCertificate);
		}
		else {
			tLayer->setCertificateVerification(DCV_ignoreCertificate);
		}
		/*
		 if (opt_dhparam && ! (tLayer->setTempDHParameters(opt_dhparam)))
		 {
		 LOG_WARN("C-MOVE SubAssoc", "unable to load temporary DH parameters. Ignoring");
		 }
		 */
		
		cond = ASC_setTransportLayer(aNet, tLayer, 0);
		if (cond.bad())
		{
			LOG_ERROR("C-MOVE SubAssoc", "Error al insertar capa de transporte segura: " << cond.text());
			return EC_IllegalParameter;
		}
		
    }
	cond = ASC_receiveAssociation(aNet, assoc, m_maxReceivePDULength, NULL, NULL, m_TLS);
	
	if (cond.bad()) {
		LOG_ERROR("C-MOVE SubAssoc", "No se pudo recibir la asociacin" << cond.text());
	}
	
	if (cond.good() && assoc && *assoc && m_TLS) {
		cond = ASC_setTransportLayerType((*assoc)->params, m_TLS);
	
		if (cond.bad()) {
			LOG_ERROR("C-MOVE SubAssoc", "No se pudo fijar la capa TLS sobre la asociacin" << cond.text());
		}
	}
	if(cond.good()) {

		// accept the Verification SOP Class if presented */
		cond = ASC_acceptContextsWithPreferredTransferSyntaxes(
			(*assoc)->params,
			knownAbstractSyntaxes, DIM_OF(knownAbstractSyntaxes),
			AllTransferSyntaxes, 3);

		if (cond.good()) {
			cond = ASC_acceptContextsWithPreferredTransferSyntaxes(
				(*assoc)->params,
				dcmAllStorageSOPClassUIDs, numberOfAllDcmStorageSOPClassUIDs,
				AllTransferSyntaxes, AllTransferSyntaxesCount);
		}
		else {
			LOG_ERROR("C-MOVE SubAssoc", "No se pudo aceptar el Verification SOP Class aun estando presente: " << cond.text());
		}
	}

	bool reconocida = false;
	if (cond.good()) {
		cond = ASC_acknowledgeAssociation(*assoc);
		reconocida = true;
	}
	else {
		
		LOG_ERROR("C-MOVE SubAssoc", "No se pudo enviar el reconocimiento de la asociacin" << cond.text());
	}

	if (cond.bad()) {
		if (reconocida) {
			LOG_ERROR("C-MOVE SubAssoc", "Error al reconocer la asociacin: " << cond.text());
		}
		ASC_releaseAssociation(*assoc);
		ASC_dropAssociation(*assoc);
		ASC_destroyAssociation(assoc);
	}

	return cond;

}

CONDITION MoveAssociation::subOpSCP(T_ASC_Association **subAssoc) {
	T_DIMSE_Message msg;
	T_ASC_PresentationContextID presID;

	/* just in case */
	if (!ASC_dataWaiting(*subAssoc, 0)) {
		LOG_TRACE(ambitolog, "No hay datos pendientes");
		return DIMSE_NODATAAVAILABLE;
	}

	OFCondition cond = DIMSE_receiveCommand(*subAssoc, DIMSE_BLOCKING, 0, &presID, &msg, NULL);

	if (cond == EC_Normal) {
		switch (msg.CommandField) {
			case DIMSE_C_STORE_RQ:
				LOG_TRACE(ambitolog, "Invocando C-STORE_RQ");
				cond = storeSCP(*subAssoc, &msg, presID);
				break;
			case DIMSE_C_ECHO_RQ:
				LOG_TRACE(ambitolog, "Invocando C-ECHO_RQ");
				cond = echoSCP(*subAssoc, &msg, presID);
				break;
			default:
				LOG_ERROR(ambitolog, "Tipo de comando incorrecto. Slo se aceptan C-STORE_RQ o C-ECHO_RQ en esta etapa" << cond.text());
				cond = DIMSE_BADCOMMANDTYPE;
				break;
		}
	}

	// clean up on association termination
	if (cond == DUL_PEERREQUESTEDRELEASE) {
		LOG_TRACE(ambitolog, "El PACS remoto solicit el cierre de la asociacin");
		ASC_acknowledgeRelease(*subAssoc);

		ASC_dropSCPAssociation(*subAssoc);
		ASC_destroyAssociation(subAssoc);

		return cond;
	}
	else if (cond == DUL_PEERABORTEDASSOCIATION) {
		LOG_ERROR(ambitolog, "El PACS remoto abort la asociacin"  << cond.text());

		ASC_dropSCPAssociation(*subAssoc);
		ASC_destroyAssociation(subAssoc);
		return cond;

	}
	else if (cond != EC_Normal) {
		LOG_ERROR(ambitolog, "Ha ocurrido un error y se abortar la asociacin"  << cond.text());
		// some kind of error so abort the association
		ASC_releaseAssociation(*subAssoc);

		ASC_dropSCPAssociation(*subAssoc);
		ASC_destroyAssociation(subAssoc);
		return cond;
	}

	return cond;
}

CONDITION MoveAssociation::storeSCP(T_ASC_Association *assoc, T_DIMSE_Message *msg, T_ASC_PresentationContextID presID) {
	CONDITION cond;
	T_DIMSE_C_StoreRQ* req;
	DcmDataset *dset = new DcmDataset;

	req = &msg->msg.CStoreRQ;

	StoreCallbackInfo callbackData;
	callbackData.dataset = dset;
	callbackData.pCaller = this;
	callbackData.assoc = assoc;

	cond = DIMSE_storeProvider(assoc, presID, req, (char *) NULL, 1,
		&dset, storeSCPCallback, (void*) & callbackData,
		DIMSE_BLOCKING, 0);

	delete dset;
	return cond;
}

void MoveAssociation::storeSCPCallback(void *callbackData, T_DIMSE_StoreProgress *progress, T_DIMSE_C_StoreRQ *req, char* /*imageFileName*/, DcmDataset **imageDataSet, T_DIMSE_C_StoreRSP *rsp, DcmDataset **statusDetail) {
	DIC_UI sopClass;
	DIC_UI sopInstance;

	StoreCallbackInfo *cbdata = (StoreCallbackInfo*) callbackData;
	MoveAssociation* caller = cbdata->pCaller;

	if (progress->state == DIMSE_StoreBegin) {
		caller->m_bytesDescargados += progress->totalBytes;
		GNC::GCS::Permisos::EstadoPermiso estado = GNC::GCS::ControladorPermisos::Instance()->Get("core.pacs.limits", "study_size");
		if (estado) {
			if (estado.ObtenerValor<long>() < (caller->m_bytesDescargados / 1024) ) {
				caller->m_errorMessage = _Std("Study download size limit exceded");
				cbdata->pCaller->Stop();
				rsp->DimseStatus = STATUS_MOVE_Cancel_SubOperationsTerminatedDueToCancelIndication;
				ASC_releaseAssociation(cbdata->assoc);
				LOG_INFO(caller->ambitolog, "Study download size limit exceded");
				return;
			}
		}
	}


	if (progress->state == DIMSE_StoreProgressing) {
		//si ha pasado medio segundo...
		std::stringstream ostr;
		ostr << caller->m_mensaje;
		ostr.setf(std::ios::floatfield, std::ios::fixed );
		ostr.precision(2);
		ostr <<  " (" << caller->TasaTransferencia(progress->progressBytes) << " kb/s)";
		std::string msg(ostr.str());
		if(!caller->NotificarProgreso(((float)progress->progressBytes/progress->totalBytes),msg))
		{
			cbdata->pCaller->Stop();
			rsp->DimseStatus = STATUS_MOVE_Cancel_SubOperationsTerminatedDueToCancelIndication;
			ASC_releaseAssociation(cbdata->assoc);
			LOG_INFO(caller->ambitolog, "Operation canceled by user");
			return;
		}
	}

	if (progress->state == DIMSE_StoreEnd) {
		LOG_TRACE(caller->ambitolog, "storeSCPCallback(). DIMSE_StoreEnd");
		*statusDetail = NULL; /* no status detail */
		caller->ResetearMedida();

		/* could save the image somewhere else, put it in database, etc */
		rsp->DimseStatus = STATUS_Success;

		if ((imageDataSet) && (*imageDataSet)) {
			// do not duplicate the dataset, let the user do this
			// if he wants to
			caller->OnResponseReceived(cbdata->dataset);
		}

		/* should really check the image to make sure it is consistent,
		* that its sopClass and sopInstance correspond with those in
		* the request.
		*/
		if (rsp->DimseStatus == STATUS_Success) {
			/* which SOP class and SOP instance ? */
			if (!DU_findSOPClassAndInstanceInDataSet(cbdata->dataset, sopClass, sopInstance)) {
				rsp->DimseStatus = STATUS_STORE_Error_CannotUnderstand;
				LOG_ERROR(caller->ambitolog, "No se pudo encontrar SOPClass o SOPInstanceUID en el dataset");
			}
			else if (strcmp(sopClass, req->AffectedSOPClassUID) != 0) {
				rsp->DimseStatus = STATUS_STORE_Error_DataSetDoesNotMatchSOPClass;
				LOG_ERROR(caller->ambitolog, "El SOPClass del dataset(" << sopClass << ") no coincide con el SOPClass requerido (" << req->AffectedSOPClassUID << ")");
			}
			else if (strcmp(sopInstance, req->AffectedSOPInstanceUID) != 0) {
				rsp->DimseStatus = STATUS_STORE_Error_DataSetDoesNotMatchSOPClass;
				LOG_ERROR(caller->ambitolog, "El SOPInstance del dataset(" << sopInstance << ") no coincide con el SOPInstanceUID requerido (" << req->AffectedSOPInstanceUID << ")");
			}
		}

	}

}

CONDITION MoveAssociation::echoSCP(T_ASC_Association *assoc, T_DIMSE_Message *msg, T_ASC_PresentationContextID presID) {
	CONDITION cond;

	// the echo succeeded !!
	cond = DIMSE_sendEchoResponse(assoc, presID, &msg->msg.CEchoRQ, STATUS_Success, NULL);

	return cond;
}

void MoveAssociation::OnResponseReceived(DcmDataset* dset) {
	if (m_pHandler != NULL) {
		m_pHandler->Store(dset);
	}
	if (m_pModelo != NULL) {
		OFString OFEstudioUId;
		if (dset->findAndGetOFString(DCM_StudyInstanceUID, OFEstudioUId).good()) {
			OFString OFPacienteUID;
			std::string PacienteUID;
			if (dset->findAndGetOFString(DCM_PatientID, OFPacienteUID).good()) {
				PacienteUID.assign(OFPacienteUID.c_str());
			}

			OFString OFPacienteNombre;
			std::string PacienteNombre;
			if (dset->findAndGetOFString(DCM_PatientName, OFPacienteNombre).good()) {
				PacienteNombre.assign(OFPacienteNombre.c_str());
			}

			OFString OFPacienteFechaNacimiento;
			std::string PacienteFechaNacimiento;

			if (dset->findAndGetOFString(DCM_PatientBirthDate, OFPacienteFechaNacimiento).good()) {
				PacienteFechaNacimiento.assign(OFPacienteFechaNacimiento.c_str());
			}


			OFString OFPacienteSexo;
			std::string PacienteSexo;
			if (dset->findAndGetOFString(DCM_PatientSex, OFPacienteSexo).good()) {
				PacienteSexo.assign(OFPacienteSexo.c_str());
			}

			const IModeloPaciente& paciente = m_pModelo->InsertarPaciente(PacienteUID, PacienteNombre, PacienteFechaNacimiento, PacienteSexo);

			OFString OFEstudioUID;
			std::string EstudioUID;
			if (dset->findAndGetOFString(DCM_StudyInstanceUID, OFEstudioUID).good()) {
				EstudioUID.assign(OFEstudioUID.c_str());
			}

			OFString OFEAccNumber;
			std::string AccNumber;
			if (dset->findAndGetOFString(DCM_AccessionNumber, OFEAccNumber).good()) {
				AccNumber.assign(OFEAccNumber.c_str());
			}

			OFString OFEstudioDescripcion;
			std::string EstudioDescripcion;
			if (dset->findAndGetOFString(DCM_StudyDescription, OFEstudioDescripcion).good()) {
				EstudioDescripcion.assign(OFEstudioDescripcion.c_str());
			}

			OFString OFEstudioModalidad;
			std::string EstudioModalidad;
			if (dset->findAndGetOFString(DCM_ModalitiesInStudy, OFEstudioModalidad).good()) {
				EstudioModalidad.assign(OFEstudioModalidad.c_str());
			}

			OFString OFEstudioFecha;
			std::string EstudioFecha;
			if (dset->findAndGetOFString(DCM_StudyDate, OFEstudioFecha).good()) {
				EstudioFecha.assign(OFEstudioFecha.c_str());
			}

			OFString OFEstudioHora;
			std::string EstudioHora;
			if (dset->findAndGetOFString(DCM_StudyTime, OFEstudioHora).good()) {
				EstudioHora.assign(OFEstudioHora.c_str());
			}


			OFString OFEstudioDoctor;
			std::string EstudioDoctor;
			if (dset->findAndGetOFString(DCM_ReferringPhysicianName, OFEstudioDoctor).good()) {
				EstudioDoctor.assign(OFEstudioDoctor.c_str());
			}

			m_pModelo->InsertarEstudio(paciente.GetUID(), EstudioUID, AccNumber, EstudioDescripcion, EstudioModalidad, EstudioFecha, EstudioHora, EstudioDoctor);

			OFString OFSerieUID;
			std::string SerieUID;
			if (dset->findAndGetOFString(DCM_SeriesInstanceUID, OFSerieUID).good()) {
				SerieUID.assign(OFSerieUID.c_str());
			}

			OFString OFSerieTipo;
			std::string SerieTipo;
			if (dset->findAndGetOFString(DCM_SeriesType, OFSerieTipo).good()) {
				SerieTipo.assign(OFSerieTipo.c_str());
			}

			OFString OFSerieFecha;
			std::string SerieFecha;
			if (dset->findAndGetOFString(DCM_SeriesDate, OFSerieFecha).good()) {
				SerieFecha.assign(OFSerieFecha.c_str());
			}

			OFString OFSerieHora;
			std::string SerieHora;
			if (dset->findAndGetOFString(DCM_SeriesTime, OFSerieHora).good()) {
				SerieHora.assign(OFSerieHora.c_str());
			}

			OFString OFSerieDescripcion;
			std::string SerieDescripcion;
			if (dset->findAndGetOFString(DCM_SeriesDescription, OFSerieDescripcion).good()) {
				SerieDescripcion.assign(OFSerieDescripcion.c_str());
			}

			OFString OFSerieNumero;
			std::string SerieNumero;
			if (dset->findAndGetOFString(DCM_NumberOfSeriesRelatedInstances, OFSerieNumero).good()) {
				SerieNumero.assign(OFSerieNumero.c_str());
			}

			OFString OFSerieDoctor;
			std::string SerieDoctor;
			if (dset->findAndGetOFString(DCM_ReferringPhysicianName, OFSerieDoctor).good()) {
				SerieDoctor.assign(OFSerieDoctor.c_str());
			}

			m_pModelo->InsertarSerie(EstudioUID, SerieUID, SerieTipo, SerieFecha, SerieHora, SerieDescripcion,SerieNumero,SerieDoctor);

			OFString OFUIDImagen;
			std::string UIDImagen;
			if (dset->findAndGetOFString(DCM_SOPInstanceUID, OFUIDImagen).good()) {
				UIDImagen.assign(OFUIDImagen.c_str());
				m_pModelo->InsertarImagen(SerieUID,UIDImagen);
			}
		}
	}
}

void MoveAssociation::SetCallbackHandler(IStoreCallBack * handler) {
	m_pHandler = handler;
}

float MoveAssociation::TasaTransferencia(int bytesDescargados)
{
	time_t nuevoInstante = time(NULL);
	const double tiempo = difftime(nuevoInstante,m_medida.m_instante);
	if(tiempo>0.15f){
		if(bytesDescargados > m_medida.bytesDescargados) {
			const double bytesRecibidosPeriodo = bytesDescargados - m_medida.bytesDescargados;
			m_medida.oldTasa = ( ((float)bytesRecibidosPeriodo/1024.0f)/tiempo );
			m_medida.bytesDescargados = bytesDescargados;
			m_medida.m_instante = nuevoInstante;
		}
	}
	return m_medida.oldTasa;
}

void MoveAssociation::ResetearMedida(bool clearTasa) {
	m_medida.bytesDescargados = 0;
	m_medida.m_instante = time(NULL);
	if(clearTasa) {
		m_medida.oldTasa=0.0f;
	}
}

